/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.tile;

import com.github.alexthe666.rats.server.entity.tile.TileEntityRatlantisPortal;
import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.FloatBuffer;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class RenderRatlantisPortal
extends TileEntityRenderer<TileEntityRatlantisPortal> {
    private static final ResourceLocation END_SKY_TEXTURE = new ResourceLocation("rats:textures/environment/ratlantis_sky_portal.png");
    private static final ResourceLocation END_PORTAL_TEXTURE = new ResourceLocation("rats:textures/environment/ratlantis_portal.png");
    private static final Random RANDOM = new Random(31100L);
    private static final FloatBuffer MODELVIEW = GLAllocation.func_74529_h((int)16);
    private static final FloatBuffer PROJECTION = GLAllocation.func_74529_h((int)16);
    private final FloatBuffer buffer = GLAllocation.func_74529_h((int)16);

    public void render(TileEntityRatlantisPortal tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage) {
        GlStateManager.pushMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.disableLighting();
        RANDOM.setSeed(31100L);
        GlStateManager.getMatrix((int)2982, (FloatBuffer)MODELVIEW);
        GlStateManager.getMatrix((int)2983, (FloatBuffer)PROJECTION);
        double d0 = x * x + y * y + z * z;
        int i = this.getPasses(d0);
        float f = this.getOffset();
        boolean flag = false;
        GameRenderer gamerenderer = Minecraft.func_71410_x().field_71460_t;
        for (int j = 0; j < i; ++j) {
            GlStateManager.pushMatrix();
            float f1 = 2.0f / (float)(18 - j);
            if (j == 0) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(END_SKY_TEXTURE);
                f1 = 0.15f;
                GlStateManager.enableBlend();
                GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }
            if (j >= 1) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(END_PORTAL_TEXTURE);
                flag = true;
                gamerenderer.func_191514_d(true);
            }
            if (j == 1) {
                GlStateManager.enableBlend();
                GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            }
            GlStateManager.texGenMode((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9216);
            GlStateManager.texGenMode((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9216);
            GlStateManager.texGenMode((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9216);
            GlStateManager.texGenParam((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9474, (FloatBuffer)this.getBuffer(1.0f, 0.0f, 0.0f, 0.0f));
            GlStateManager.texGenParam((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9474, (FloatBuffer)this.getBuffer(0.0f, 1.0f, 0.0f, 0.0f));
            GlStateManager.texGenParam((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9474, (FloatBuffer)this.getBuffer(0.0f, 0.0f, 1.0f, 0.0f));
            GlStateManager.enableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.S);
            GlStateManager.enableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.T);
            GlStateManager.enableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.R);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5890);
            GlStateManager.pushMatrix();
            GlStateManager.loadIdentity();
            GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.0f);
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)1.0f);
            float f2 = j + 1;
            float time = ((float)(Minecraft.func_71410_x().field_71439_g.field_70173_aa - 1) + 1.0f * partialTicks) % 800.0f / 800.0f;
            if (tileEntityIn == null) {
                time = ((float)(Minecraft.func_71410_x().field_181542_y.func_181750_b() - 1) + 1.0f * partialTicks) % 3200.0f / 3200.0f;
            }
            GlStateManager.translatef((float)(17.0f / f2 * time * (float)RANDOM.nextGaussian()), (float)((2.0f + f2 / 1.5f) * time), (float)0.0f);
            GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float scal = 4.5f - f2 / 4.0f;
            GlStateManager.scalef((float)scal, (float)scal, (float)1.0f);
            GlStateManager.multMatrix((FloatBuffer)PROJECTION);
            GlStateManager.multMatrix((FloatBuffer)MODELVIEW);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            float f3 = 1.0f;
            float f4 = 0.98f;
            float f5 = 0.79f;
            float alpha2 = 0.7f;
            if (tileEntityIn == null || tileEntityIn.func_184313_a(Direction.SOUTH)) {
                bufferbuilder.func_181662_b(x, y, z + 1.0).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y, z + 1.0).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y + 1.0, z + 1.0).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x, y + 1.0, z + 1.0).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
            }
            if (tileEntityIn == null || tileEntityIn.func_184313_a(Direction.NORTH)) {
                bufferbuilder.func_181662_b(x, y + 1.0, z).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y + 1.0, z).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y, z).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x, y, z).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
            }
            if (tileEntityIn == null || tileEntityIn.func_184313_a(Direction.EAST)) {
                bufferbuilder.func_181662_b(x + 1.0, y + 1.0, z).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y + 1.0, z + 1.0).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y, z + 1.0).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y, z).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
            }
            if (tileEntityIn == null || tileEntityIn.func_184313_a(Direction.WEST)) {
                bufferbuilder.func_181662_b(x, y, z).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x, y, z + 1.0).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x, y + 1.0, z + 1.0).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x, y + 1.0, z).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
            }
            if (tileEntityIn == null || tileEntityIn.func_184313_a(Direction.DOWN)) {
                bufferbuilder.func_181662_b(x, y, z).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y, z).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y, z + 1.0).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x, y, z + 1.0).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
            }
            if (tileEntityIn == null || tileEntityIn.func_184313_a(Direction.UP)) {
                bufferbuilder.func_181662_b(x, y + (double)f, z + 1.0).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y + (double)f, z + 1.0).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x + 1.0, y + (double)f, z).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
                bufferbuilder.func_181662_b(x, y + (double)f, z).func_181666_a(f3, f4, f5, alpha2).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5888);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(END_SKY_TEXTURE);
        }
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.disableBlend();
        GlStateManager.disableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.S);
        GlStateManager.disableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.T);
        GlStateManager.disableTexGen((GlStateManager.TexGen)GlStateManager.TexGen.R);
        GlStateManager.enableLighting();
        GlStateManager.popMatrix();
        if (flag) {
            gamerenderer.func_191514_d(false);
        }
        GlStateManager.popMatrix();
    }

    protected int getPasses(double p_191286_1_) {
        int i = p_191286_1_ > 36864.0 ? 1 : (p_191286_1_ > 25600.0 ? 3 : (p_191286_1_ > 16384.0 ? 5 : (p_191286_1_ > 9216.0 ? 7 : (p_191286_1_ > 4096.0 ? 9 : (p_191286_1_ > 1024.0 ? 11 : (p_191286_1_ > 576.0 ? 13 : (p_191286_1_ > 256.0 ? 14 : 15)))))));
        return i;
    }

    protected float getOffset() {
        return 1.0f;
    }

    private FloatBuffer getBuffer(float p_147525_1_, float p_147525_2_, float p_147525_3_, float p_147525_4_) {
        this.buffer.clear();
        this.buffer.put(p_147525_1_).put(p_147525_2_).put(p_147525_3_).put(p_147525_4_);
        this.buffer.flip();
        return this.buffer;
    }
}

