/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.blocks;

import com.github.alexthe666.rats.server.blocks.IUsesTEISR;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatHole;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockRatHole
extends ContainerBlock
implements IUsesTEISR {
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    private static final VoxelShape TOP_AABB = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NS_LEFT_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)8.0, (double)16.0);
    private static final VoxelShape NS_RIGHT_AABB = Block.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape EW_LEFT_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)4.0);
    private static final VoxelShape EW_RIGHT_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape NORTH_CORNER_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)8.0, (double)4.0);
    private static final VoxelShape EAST_CORNER_AABB = Block.func_208617_a((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)4.0);
    private static final VoxelShape SOUTH_CORNER_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0, (double)16.0);
    private static final VoxelShape WEST_CORNER_AABB = Block.func_208617_a((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)8.0, (double)16.0);
    private VoxelShape shape;

    protected BlockRatHole() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200948_a(1.3f, 0.0f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)));
        this.shape = VoxelShapes.func_197878_a((VoxelShape)TOP_AABB, (VoxelShape)NORTH_CORNER_AABB, (IBooleanFunction)IBooleanFunction.field_223244_o_).func_197753_c();
        this.shape = VoxelShapes.func_197878_a((VoxelShape)this.shape, (VoxelShape)SOUTH_CORNER_AABB, (IBooleanFunction)IBooleanFunction.field_223244_o_).func_197753_c();
        this.shape = VoxelShapes.func_197878_a((VoxelShape)this.shape, (VoxelShape)EAST_CORNER_AABB, (IBooleanFunction)IBooleanFunction.field_223244_o_).func_197753_c();
        this.shape = VoxelShapes.func_197878_a((VoxelShape)this.shape, (VoxelShape)WEST_CORNER_AABB, (IBooleanFunction)IBooleanFunction.field_223244_o_).func_197753_c();
        this.setRegistryName("rats:rat_hole");
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_200124_e(BlockState state) {
        return false;
    }

    public boolean isOpaqueCube(BlockState state) {
        return false;
    }

    public boolean isFullCube(BlockState state) {
        return false;
    }

    public int getMetaFromState(BlockState state) {
        return 0;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (worldIn.func_175625_s(pos) != null && worldIn.func_175625_s(pos) instanceof TileEntityRatHole) {
            TileEntityRatHole te = (TileEntityRatHole)worldIn.func_175625_s(pos);
            NonNullList ret = NonNullList.func_191196_a();
            if (!worldIn.field_72995_K && worldIn instanceof ServerWorld) {
                te.getImmitatedBlockState().func_177230_c();
                Block.func_220070_a((BlockState)te.getImmitatedBlockState(), (ServerWorld)((ServerWorld)worldIn), (BlockPos)pos, null);
                for (ItemStack stack : ret) {
                    ItemEntity ItemEntity2 = new ItemEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
                    worldIn.func_217376_c((Entity)ItemEntity2);
                }
            }
        }
        worldIn.func_175713_t(pos);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World iblockreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockPos blockpos1 = blockpos.func_177978_c();
        BlockPos blockpos2 = blockpos.func_177974_f();
        BlockPos blockpos3 = blockpos.func_177968_d();
        BlockPos blockpos4 = blockpos.func_177976_e();
        BlockState blockstate = iblockreader.func_180495_p(blockpos1);
        BlockState blockstate1 = iblockreader.func_180495_p(blockpos2);
        BlockState blockstate2 = iblockreader.func_180495_p(blockpos3);
        BlockState blockstate3 = iblockreader.func_180495_p(blockpos4);
        return (BlockState)((BlockState)((BlockState)((BlockState)super.func_196258_a(context).func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canFenceConnectTo(blockstate, blockstate.func_224755_d((IBlockReader)iblockreader, blockpos1, Direction.SOUTH), Direction.SOUTH)))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canFenceConnectTo(blockstate1, blockstate1.func_224755_d((IBlockReader)iblockreader, blockpos2, Direction.WEST), Direction.WEST)))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canFenceConnectTo(blockstate2, blockstate2.func_224755_d((IBlockReader)iblockreader, blockpos3, Direction.NORTH), Direction.NORTH)))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canFenceConnectTo(blockstate3, blockstate3.func_224755_d((IBlockReader)iblockreader, blockpos4, Direction.EAST), Direction.EAST)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape1 = this.shape;
        if (state.func_177230_c() instanceof BlockRatHole) {
            if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
                shape1 = VoxelShapes.func_197882_b((VoxelShape)shape1, (VoxelShape)EW_LEFT_AABB, (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
                shape1 = VoxelShapes.func_197882_b((VoxelShape)shape1, (VoxelShape)EW_RIGHT_AABB, (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
                shape1 = VoxelShapes.func_197882_b((VoxelShape)shape1, (VoxelShape)NS_LEFT_AABB, (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
            if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
                shape1 = VoxelShapes.func_197882_b((VoxelShape)shape1, (VoxelShape)NS_RIGHT_AABB, (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
        }
        return shape1;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{NORTH, EAST, WEST, SOUTH});
    }

    private boolean canFenceConnectTo(BlockState p_220111_1_, boolean p_220111_2_, Direction p_220111_3_) {
        Block block = p_220111_1_.func_177230_c();
        boolean flag = p_220111_1_.func_185904_a() == this.field_149764_J;
        return !BlockRatHole.func_220073_a((Block)block) && p_220111_2_ && block != this;
    }

    public SoundType func_220072_p(BlockState state) {
        return SoundType.field_185848_a;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityRatHole();
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        BooleanProperty connect = null;
        switch (facing) {
            case NORTH: {
                connect = NORTH;
                break;
            }
            case SOUTH: {
                connect = SOUTH;
                break;
            }
            case EAST: {
                connect = EAST;
                break;
            }
            case WEST: {
                connect = WEST;
            }
        }
        if (connect == null) {
            return stateIn;
        }
        return (BlockState)stateIn.func_206870_a((IProperty)connect, (Comparable)Boolean.valueOf(this.canFenceConnectTo(facingState, facingState.func_224755_d((IBlockReader)worldIn, facingPos, facing.func_176734_d()), facing.func_176734_d())));
    }
}

