/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityPlagueBeast;
import com.github.alexthe666.rats.server.entity.EntityPlagueCloud;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.IPlagueLegion;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.RatsEntityRegistry;
import com.github.alexthe666.rats.server.entity.ai.BlackDeathAIStrife;
import com.github.alexthe666.rats.server.entity.ai.BlackDeathAITargetNonPlagued;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.ServerBossInfo;
import net.minecraft.world.World;

public class EntityBlackDeath
extends MonsterEntity
implements IPlagueLegion,
IRangedAttackMob {
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(EntityBlackDeath.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_SUMMONING = EntityDataManager.func_187226_a(EntityBlackDeath.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> RAT_COUNT = EntityDataManager.func_187226_a(EntityBlackDeath.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> CLOUD_COUNT = EntityDataManager.func_187226_a(EntityBlackDeath.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BEAST_COUNT = EntityDataManager.func_187226_a(EntityBlackDeath.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS);
    private int ratCooldown = 0;
    private int summonAnimationCooldown = 0;

    public EntityBlackDeath(EntityType type, World worldIn) {
        super(type, worldIn);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new BlackDeathAIStrife(this, 1.0, 100, 32.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{EntityRat.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new BlackDeathAITargetNonPlagued((CreatureEntity)this, LivingEntity.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
        this.field_70180_af.func_187214_a(IS_SUMMONING, (Object)false);
        this.field_70180_af.func_187214_a(RAT_COUNT, (Object)0);
        this.field_70180_af.func_187214_a(CLOUD_COUNT, (Object)0);
        this.field_70180_af.func_187214_a(BEAST_COUNT, (Object)0);
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        if (potioneffectIn.func_188419_a() == RatsMod.PLAGUE_POTION) {
            return false;
        }
        return super.func_70687_e(potioneffectIn);
    }

    protected SoundEvent func_184639_G() {
        return RatsSoundRegistry.BLACK_DEATH_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return RatsSoundRegistry.BLACK_DEATH_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return RatsSoundRegistry.BLACK_DEATH_DIE;
    }

    public int func_70627_aG() {
        return 10;
    }

    protected boolean canDespawn() {
        return false;
    }

    public void func_70106_y() {
        if (!this.func_70089_S()) {
            double dist = 20.0;
            for (EntityRat rat : this.field_70170_p.func_217357_a(EntityRat.class, new AxisAlignedBB(this.field_70165_t - dist, this.field_70163_u - dist, this.field_70161_v - dist, this.field_70165_t + dist, this.field_70163_u + dist, this.field_70161_v + dist))) {
                if (!rat.func_152114_e((LivingEntity)this)) continue;
                rat.func_70903_f(false);
                rat.func_184754_b(null);
                rat.fleePos = new BlockPos((Entity)rat);
                rat.func_70624_b(null);
                rat.func_70604_c(null);
            }
        }
        super.func_70106_y();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)RatConfig.blackDeathHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)RatConfig.blackDeathAttack);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(128.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(12.0);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean isSummoning() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SUMMONING);
    }

    public void setSummoning(boolean summoning) {
        this.field_70180_af.func_187227_b(IS_SUMMONING, (Object)summoning);
    }

    public int getRatsSummoned() {
        return (Integer)this.field_70180_af.func_187225_a(RAT_COUNT);
    }

    public void setRatsSummoned(int count) {
        this.field_70180_af.func_187227_b(RAT_COUNT, (Object)count);
    }

    public int getCloudsSummoned() {
        return (Integer)this.field_70180_af.func_187225_a(CLOUD_COUNT);
    }

    public void setCloudsSummoned(int count) {
        this.field_70180_af.func_187227_b(CLOUD_COUNT, (Object)count);
    }

    public int getBeastsSummoned() {
        return (Integer)this.field_70180_af.func_187225_a(BEAST_COUNT);
    }

    public void setBeastsSummoned(int count) {
        this.field_70180_af.func_187227_b(BEAST_COUNT, (Object)count);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("RatsSummoned", this.getRatsSummoned());
        compound.func_74768_a("CloudsSummoned", this.getCloudsSummoned());
        compound.func_74768_a("BeastsSummoned", this.getBeastsSummoned());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
        this.setRatsSummoned(compound.func_74762_e("RatsSummoned"));
        this.setCloudsSummoned(compound.func_74762_e("CloudsSummoned"));
        this.setBeastsSummoned(compound.func_74762_e("BeastsSummoned"));
    }

    public void func_200203_b(ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        this.summonMinion(this.getMinionTypeToSpawn());
    }

    public void setSwingingArms(boolean swingingArms) {
        this.field_70180_af.func_187227_b(SWINGING_ARMS, (Object)swingingArms);
    }

    public void summonMinion(int type) {
        if (this.ratCooldown == 0) {
            if (!this.isSummoning()) {
                this.setSummoning(true);
                this.summonAnimationCooldown = 20;
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)82);
            if (type == 0 && this.getRatsSummoned() < 15) {
                EntityRat rat = new EntityRat(RatsEntityRegistry.RAT, this.field_70170_p);
                rat.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos((Entity)this)), SpawnReason.MOB_SUMMONED, null, null);
                rat.func_82149_j((Entity)this);
                rat.setPlague(true);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_217376_c((Entity)rat);
                }
                rat.func_70903_f(true);
                rat.setTamedByPlayerFlag(false);
                rat.func_184754_b(this.func_110124_au());
                rat.setCommand(RatCommand.FOLLOW);
                if (this.func_70638_az() != null) {
                    rat.func_70624_b(this.func_70638_az());
                }
                this.setRatsSummoned(this.getRatsSummoned() + 1);
            }
            if (type == 1 && this.getCloudsSummoned() < 4) {
                EntityPlagueCloud cloud = new EntityPlagueCloud(RatsEntityRegistry.PLAGUE_CLOUD, this.field_70170_p);
                cloud.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos((Entity)this)), SpawnReason.MOB_SUMMONED, null, null);
                cloud.func_82149_j((Entity)this);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_217376_c((Entity)cloud);
                }
                cloud.setOwnerId(this.func_110124_au());
                if (this.func_70638_az() != null) {
                    cloud.func_70624_b(this.func_70638_az());
                }
                this.setCloudsSummoned(this.getCloudsSummoned() + 1);
            }
            if (type == 2 && this.getBeastsSummoned() < 3) {
                EntityPlagueBeast beast = new EntityPlagueBeast(RatsEntityRegistry.PLAGUE_BEAST, this.field_70170_p);
                beast.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos((Entity)this)), SpawnReason.MOB_SUMMONED, null, null);
                beast.func_82149_j((Entity)this);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_217376_c((Entity)beast);
                }
                beast.setOwnerId(this.func_110124_au());
                if (this.func_70638_az() != null) {
                    beast.func_70624_b(this.func_70638_az());
                }
                this.setBeastsSummoned(this.getBeastsSummoned() + 1);
            }
            this.ratCooldown = 40;
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() != null && this.func_70638_az() instanceof EntityRat && ((EntityRat)this.func_70638_az()).hasPlague()) {
            this.func_70624_b(null);
        }
        if (this.ratCooldown > 0) {
            --this.ratCooldown;
        }
        if (this.summonAnimationCooldown > 0) {
            --this.summonAnimationCooldown;
        }
        if (this.isSummoning() && this.summonAnimationCooldown <= 0) {
            this.setSummoning(false);
            this.summonAnimationCooldown = 0;
        }
        if (this.field_70170_p.field_72995_K && this.isSummoning()) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            float f = this.field_70761_aq * ((float)Math.PI / 180) + MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.6662f)) * 0.25f;
            float f1 = MathHelper.func_76134_b((float)f);
            float f2 = MathHelper.func_76126_a((float)f);
            RatsMod.PROXY.addParticle("black_death", this.field_70165_t + (double)f1 * 0.6, this.field_70163_u + 1.8, this.field_70161_v + (double)f2 * 0.6, d0, d1, d2);
            RatsMod.PROXY.addParticle("black_death", this.field_70165_t - (double)f1 * 0.6, this.field_70163_u + 1.8, this.field_70161_v - (double)f2 * 0.6, d0, d1, d2);
        }
        if (this.getRatsSummoned() < 15 && this.ratCooldown == 0) {
            this.summonMinion(0);
        }
    }

    private int getMinionTypeToSpawn() {
        if (this.func_70638_az() != null) {
            return this.getLowestMinionType();
        }
        return 0;
    }

    private int getLowestMinionType() {
        if (this.getCloudsSummoned() < 4 && this.field_70146_Z.nextBoolean()) {
            return 1;
        }
        if (this.getBeastsSummoned() < 3 && this.field_70146_Z.nextBoolean()) {
            return 2;
        }
        return 0;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)RatsItemRegistry.PLAGUE_SCYTHE));
        this.func_184642_a(EquipmentSlotType.MAINHAND, 0.0f);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData iLivingEntitydata = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.func_180481_a(difficultyIn);
        this.func_180483_b(difficultyIn);
        return iLivingEntitydata;
    }
}

