/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.server.entity.EntityDutchratSword;
import com.github.alexthe666.rats.server.entity.IPirat;
import com.github.alexthe666.rats.server.entity.IRatlantean;
import com.github.alexthe666.rats.server.entity.RatsEntityRegistry;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import com.google.common.base.Predicate;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.ServerBossInfo;
import net.minecraft.world.World;

public class EntityDutchrat
extends MonsterEntity
implements IAnimatedEntity,
IRangedAttackMob,
IRatlantean,
IPirat {
    private int animationTick;
    private boolean useRangedAttack = false;
    private int ticksSinceThrownSword = 0;
    private Animation currentAnimation;
    public static final Animation ANIMATION_SLASH = Animation.create((int)25);
    public static final Animation ANIMATION_STAB = Animation.create((int)17);
    public static final Animation ANIMATION_THROW = Animation.create((int)15);
    public static final Animation ANIMATION_SPEAK = Animation.create((int)10);
    private static final DataParameter<Boolean> THROWN_SWORD = EntityDataManager.func_187226_a(EntityDutchrat.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final Predicate<LivingEntity> NOT_RATLANTEAN = new Predicate<LivingEntity>(){

        public boolean apply(@Nullable LivingEntity entity) {
            return entity.func_70089_S() && !(entity instanceof IRatlantean);
        }
    };
    private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.GREEN, BossInfo.Overlay.PROGRESS);

    public EntityDutchrat(EntityType<? extends MonsterEntity> type, World world) {
        super(type, world);
        this.field_70765_h = new AIMoveControl(this);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)RatConfig.dutchratHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)RatConfig.dutchratAttack);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(128.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new AIFollowPrey(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AIMoveRandom());
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 0, false, false, NOT_RATLANTEAN));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(THROWN_SWORD, (Object)false);
    }

    public void setThrownSword(boolean sword) {
        this.field_70180_af.func_187227_b(THROWN_SWORD, (Object)sword);
    }

    public boolean hasThrownSword() {
        return (Boolean)this.field_70180_af.func_187225_a(THROWN_SWORD);
    }

    public boolean func_189652_ae() {
        return true;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.field_70145_X = true;
        if (this.getAnimation() == ANIMATION_THROW && this.getAnimationTick() > 7) {
            if (!this.hasThrownSword()) {
                float radius = -1.5f;
                float angle = (float)Math.PI / 180 * this.field_70761_aq - 230.0f;
                double extraX = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + this.field_70165_t;
                double extraZ = (double)(radius * MathHelper.func_76134_b((float)angle)) + this.field_70161_v;
                double extraY = (double)1.7f + this.field_70163_u;
                EntityDutchratSword sword = new EntityDutchratSword(RatsEntityRegistry.DUTCHRAT_SWORD, this.field_70170_p, extraX, extraY, extraZ, (LivingEntity)this);
                this.field_70170_p.func_217376_c((Entity)sword);
                this.useRangedAttack = this.field_70146_Z.nextBoolean();
            }
            this.setThrownSword(true);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.hasThrownSword()) {
                ++this.ticksSinceThrownSword;
            }
            if (this.ticksSinceThrownSword > 60) {
                this.setThrownSword(false);
                this.ticksSinceThrownSword = 0;
            }
        }
        if (this.useRangedAttack && this.getAnimation() != ANIMATION_THROW && !this.hasThrownSword() && this.func_70638_az() != null && this.func_70685_l((Entity)this.func_70638_az())) {
            this.setAnimation(ANIMATION_THROW);
            this.func_70625_a((Entity)this.func_70638_az(), 360.0f, 80.0f);
        }
        if (!this.useRangedAttack && this.func_70638_az() != null && !this.hasThrownSword() && this.func_70032_d((Entity)this.func_70638_az()) < 7.0f && this.func_70685_l((Entity)this.func_70638_az())) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(this.field_70146_Z.nextBoolean() ? ANIMATION_SLASH : ANIMATION_STAB);
            }
            this.func_70625_a((Entity)this.func_70638_az(), 360.0f, 80.0f);
            if (this.getAnimation() == ANIMATION_SLASH && (this.getAnimationTick() == 10 || this.getAnimationTick() == 20)) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                this.func_70638_az().func_70653_a((Entity)this.func_70638_az(), 1.5f, this.field_70165_t - this.func_70638_az().field_70165_t, this.field_70161_v - this.func_70638_az().field_70161_v);
                this.useRangedAttack = this.field_70146_Z.nextBoolean();
            }
            if (this.getAnimation() == ANIMATION_STAB && this.getAnimationTick() == 10) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                this.func_70638_az().func_70653_a((Entity)this.func_70638_az(), 1.5f, this.func_70638_az().field_70165_t - this.field_70165_t, this.func_70638_az().field_70161_v - this.field_70161_v);
                this.useRangedAttack = this.field_70146_Z.nextBoolean();
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.func_184611_a(Hand.MAIN_HAND, new ItemStack((IItemProvider)RatsItemRegistry.GHOST_PIRAT_CUTLASS));
        this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)RatsItemRegistry.GHOST_PIRAT_HAT));
        return spawnDataIn;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SLASH, ANIMATION_STAB, ANIMATION_THROW, ANIMATION_SPEAK};
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_200203_b(ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public void func_70642_aH() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(ANIMATION_SPEAK);
            }
            super.func_70642_aH();
        }
    }

    protected void func_184581_c(DamageSource source) {
        if (this.getAnimation() == NO_ANIMATION && !this.field_70170_p.field_72995_K) {
            this.setAnimation(ANIMATION_SPEAK);
        }
        super.func_184581_c(source);
    }

    protected SoundEvent func_184639_G() {
        return RatsSoundRegistry.DUTCHRAT_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return RatsSoundRegistry.DUTCHRAT_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return RatsSoundRegistry.DUTCHRAT_DIE;
    }

    class AIFollowPrey
    extends Goal {
        private final EntityDutchrat parentEntity;
        public int attackTimer;
        private double followDist;

        public AIFollowPrey(EntityDutchrat ghast) {
            this.parentEntity = ghast;
        }

        public boolean func_75250_a() {
            this.followDist = EntityDutchrat.this.func_174813_aQ().func_72320_b();
            LivingEntity LivingEntity2 = this.parentEntity.func_70638_az();
            double maxFollow = this.parentEntity.useRangedAttack ? 5.0 * this.followDist : this.followDist;
            return LivingEntity2 != null && ((double)LivingEntity2.func_70032_d((Entity)this.parentEntity) >= maxFollow || !this.parentEntity.func_70685_l((Entity)LivingEntity2));
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            double maxFollow;
            LivingEntity LivingEntity2 = this.parentEntity.func_70638_az();
            double d = maxFollow = this.parentEntity.useRangedAttack ? 5.0 * this.followDist : this.followDist;
            if ((double)LivingEntity2.func_70032_d((Entity)this.parentEntity) >= maxFollow || !this.parentEntity.func_70685_l((Entity)LivingEntity2)) {
                if (EntityDutchrat.this.hasThrownSword()) {
                    BlockPos blockpos = new BlockPos((Entity)EntityDutchrat.this);
                    if (EntityDutchrat.this.func_213394_dL()) {
                        blockpos = EntityDutchrat.this.func_213384_dI();
                    }
                    BlockPos blockpos1 = blockpos.func_177982_a(EntityDutchrat.this.field_70146_Z.nextInt(15) - 7, 0, EntityDutchrat.this.field_70146_Z.nextInt(15) - 7);
                    EntityDutchrat.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n(), (double)blockpos1.func_177956_o(), (double)blockpos1.func_177952_p(), 1.0);
                } else {
                    EntityDutchrat.this.field_70765_h.func_75642_a(LivingEntity2.field_70165_t, LivingEntity2.field_70163_u + 1.0, LivingEntity2.field_70161_v, 1.0);
                }
            }
        }
    }

    class AIMoveRandom
    extends Goal {
        public AIMoveRandom() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !EntityDutchrat.this.field_70765_h.func_75640_a() && EntityDutchrat.this.field_70146_Z.nextInt(2) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = new BlockPos((Entity)EntityDutchrat.this);
            if (EntityDutchrat.this.func_213394_dL()) {
                blockpos = EntityDutchrat.this.func_213384_dI();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityDutchrat.this.field_70146_Z.nextInt(15) - 7, Math.min(EntityDutchrat.this.field_70146_Z.nextInt(10) - 5, 10), EntityDutchrat.this.field_70146_Z.nextInt(15) - 7);
                if (!EntityDutchrat.this.field_70170_p.func_175623_d(blockpos1)) continue;
                EntityDutchrat.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 1.0);
                if (EntityDutchrat.this.func_70638_az() != null) break;
                EntityDutchrat.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class AIMoveControl
    extends MovementController {
        public AIMoveControl(EntityDutchrat vex) {
            super((MobEntity)vex);
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                double edgeLength;
                Vec3d vec3d = new Vec3d(this.field_75646_b - EntityDutchrat.this.field_70165_t, this.field_75647_c - EntityDutchrat.this.field_70163_u, this.field_75644_d - EntityDutchrat.this.field_70161_v);
                double d0 = vec3d.func_72433_c();
                if (d0 < (edgeLength = EntityDutchrat.this.func_174813_aQ().func_72320_b())) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    EntityDutchrat.this.func_213317_d(EntityDutchrat.this.func_213322_ci().func_186678_a(0.5));
                } else {
                    EntityDutchrat.this.func_213317_d(EntityDutchrat.this.func_213322_ci().func_178787_e(vec3d.func_186678_a(this.field_75645_e * 0.1 / d0)));
                    if (EntityDutchrat.this.func_70638_az() == null) {
                        Vec3d vec3d1 = EntityDutchrat.this.func_213322_ci();
                        EntityDutchrat.this.field_70761_aq = EntityDutchrat.this.field_70177_z = -((float)MathHelper.func_181159_b((double)vec3d1.field_72450_a, (double)vec3d1.field_72449_c)) * 57.295776f;
                    } else {
                        double d4 = EntityDutchrat.this.func_70638_az().field_70165_t - EntityDutchrat.this.field_70165_t;
                        double d5 = EntityDutchrat.this.func_70638_az().field_70161_v - EntityDutchrat.this.field_70161_v;
                        EntityDutchrat.this.field_70761_aq = EntityDutchrat.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }
}

