/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityFeralRatlantean;
import com.github.alexthe666.rats.server.entity.EntityLaserPortal;
import com.github.alexthe666.rats.server.entity.EntityThrownBlock;
import com.github.alexthe666.rats.server.entity.IRatlantean;
import com.github.alexthe666.rats.server.entity.RatsEntityRegistry;
import com.github.alexthe666.rats.server.message.MessageSyncThrownBlock;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.ServerBossInfo;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityNeoRatlantean
extends MonsterEntity
implements IAnimatedEntity,
IRangedAttackMob,
IRatlantean {
    private static final Predicate<LivingEntity> NOT_RATLANTEAN = new Predicate<LivingEntity>(){

        public boolean apply(@Nullable LivingEntity entity) {
            return entity.func_70089_S() && !(entity instanceof IRatlantean);
        }
    };
    private static final DataParameter<Integer> COLOR_VARIANT = EntityDataManager.func_187226_a(EntityFeralRatlantean.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final ServerBossInfo bossInfo = new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.BLUE, BossInfo.Overlay.PROGRESS);
    private int animationTick;
    private Animation currentAnimation;
    private int attackSelection = 0;
    private int summonCooldown = 0;
    private int humTicks = 0;

    public EntityNeoRatlantean(EntityType type, World worldIn) {
        super(type, worldIn);
        this.func_70606_j(this.func_110138_aP());
        ((GroundPathNavigator)this.func_70661_as()).func_212239_d(true);
        this.field_70728_aV = 80;
        this.field_70765_h = new AIMoveControl(this);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.field_70173_aa % 100 == 0) {
            this.func_70691_i(1.0f);
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected boolean canDespawn() {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR_VARIANT, (Object)0);
    }

    public int getColorVariant() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR_VARIANT);
    }

    public void setColorVariant(int color) {
        this.field_70180_af.func_187227_b(COLOR_VARIANT, (Object)color);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("ColorVariant", this.getColorVariant());
        compound.func_74768_a("AttackSelection", this.attackSelection);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setColorVariant(compound.func_74762_e("ColorVariant"));
        this.attackSelection = compound.func_74762_e("AttackSelection");
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_200203_b(ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setColorVariant(this.func_70681_au().nextInt(4));
        return spawnDataIn;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            RatsMod.PROXY.addParticle("rat_lightning", this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() / 2.0, this.field_70163_u + (double)this.func_70047_e() + (double)(this.field_70146_Z.nextFloat() * 0.35f), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() / 2.0, 0.0, 0.0, 0.0);
        }
        if (this.summonCooldown > 0) {
            --this.summonCooldown;
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.humTicks % 80 == 0) {
            this.func_184185_a(RatsSoundRegistry.NEORATLANTEAN_LOOP, 1.0f, 1.0f);
        }
        ++this.humTicks;
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null) {
            int i;
            int bounds;
            LivingEntity entity = this.func_70638_az();
            if (this.attackSelection == 0 && this.summonCooldown == 0) {
                this.summonCooldown = 100;
                bounds = 5;
                for (i = 0; i < this.field_70146_Z.nextInt(3) + 3; ++i) {
                    EntityLaserPortal laserPortal = new EntityLaserPortal(RatsEntityRegistry.LASER_PORTAL, this.field_70170_p, entity.field_70165_t + (double)this.field_70146_Z.nextInt(bounds * 2) - (double)bounds, this.field_70163_u + 2.0, entity.field_70161_v + (double)this.field_70146_Z.nextInt(bounds * 2) - (double)bounds, (LivingEntity)this);
                    this.field_70170_p.func_217376_c((Entity)laserPortal);
                }
                this.resetAttacks();
            }
            if (this.attackSelection == 1 && this.summonCooldown == 0) {
                bounds = 20;
                if (!this.field_70170_p.field_72995_K) {
                    ((ServerWorld)this.field_70170_p).func_217468_a(new LightningBoltEntity(this.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, false));
                    for (i = 0; i < this.field_70146_Z.nextInt(3) + 2; ++i) {
                        ((ServerWorld)this.field_70170_p).func_217468_a(new LightningBoltEntity(this.field_70170_p, entity.field_70165_t + (double)this.field_70146_Z.nextInt(bounds * 2) - (double)bounds, entity.field_70163_u, entity.field_70161_v + (double)this.field_70146_Z.nextInt(bounds * 2) - (double)bounds, false));
                    }
                }
                this.summonCooldown = 100;
                this.resetAttacks();
            }
            if (this.attackSelection == 2 && this.summonCooldown == 0) {
                int searchRange = 10;
                BlockPos ourPos = new BlockPos((Entity)this);
                ArrayList<BlockPos> listOfAll = new ArrayList<BlockPos>();
                for (BlockPos pos : BlockPos.func_218281_b((BlockPos)ourPos.func_177982_a(-searchRange, -searchRange, -searchRange), (BlockPos)ourPos.func_177982_a(searchRange, searchRange, searchRange)).map(BlockPos::func_185334_h).collect(Collectors.toList())) {
                    BlockState state = this.field_70170_p.func_180495_p(pos);
                    if (this.field_70170_p.func_175623_d(pos) || !this.canPickupBlock(state)) continue;
                    listOfAll.add(pos);
                }
                boolean flag = false;
                if (listOfAll.size() > 0) {
                    BlockPos pos;
                    pos = (BlockPos)listOfAll.get(this.field_70146_Z.nextInt(listOfAll.size()));
                    EntityThrownBlock thrownBlock = new EntityThrownBlock(RatsEntityRegistry.THROWN_BLOCK, this.field_70170_p, this.field_70170_p.func_180495_p(pos), (LivingEntity)this);
                    thrownBlock.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_217376_c((Entity)thrownBlock);
                    }
                    RatsMod.sendMSGToAll(new MessageSyncThrownBlock(thrownBlock.func_145782_y(), pos.func_218275_a()));
                    this.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    this.summonCooldown = 40;
                }
                this.resetAttacks();
            }
            if (this.attackSelection == 3 && this.summonCooldown == 0) {
                this.func_70638_az().func_195064_c(new EffectInstance(Effects.field_188423_x, 200));
                this.func_70638_az().func_195064_c(new EffectInstance(Effects.field_82731_v, 200));
                this.func_70638_az().func_195064_c(new EffectInstance(Effects.field_188424_y, 200));
                this.summonCooldown = 40;
                this.resetAttacks();
            }
        }
    }

    public void resetAttacks() {
        this.attackSelection = this.field_70146_Z.nextInt(4);
    }

    public boolean canPickupBlock(BlockState state) {
        return WitherEntity.func_181033_a((BlockState)state);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new AIFollowPrey(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AIMoveRandom());
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 0, false, false, NOT_RATLANTEAN));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)RatConfig.neoRatlanteanHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)RatConfig.neoRatlanteanAttack);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(128.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public int getAnimationTick() {
        return 0;
    }

    public void setAnimationTick(int tick) {
    }

    public Animation getAnimation() {
        return null;
    }

    public void setAnimation(Animation animation) {
    }

    public Animation[] getAnimations() {
        return new Animation[0];
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
    }

    protected SoundEvent func_184639_G() {
        return RatsSoundRegistry.NEORATLANTEAN_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return RatsSoundRegistry.NEORATLANTEAN_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return RatsSoundRegistry.NEORATLANTEAN_DIE;
    }

    public int func_70627_aG() {
        return 10;
    }

    public class AIMoveRandom
    extends Goal {
        public AIMoveRandom() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return !EntityNeoRatlantean.this.field_70765_h.func_75640_a() && EntityNeoRatlantean.this.field_70146_Z.nextInt(2) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = new BlockPos((Entity)EntityNeoRatlantean.this);
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityNeoRatlantean.this.field_70146_Z.nextInt(15) - 7, EntityNeoRatlantean.this.field_70146_Z.nextInt(11) - 5, EntityNeoRatlantean.this.field_70146_Z.nextInt(15) - 7);
                if (!EntityNeoRatlantean.this.field_70170_p.func_175623_d(blockpos1)) continue;
                EntityNeoRatlantean.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 1.0);
                if (EntityNeoRatlantean.this.func_70638_az() != null) break;
                EntityNeoRatlantean.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    public class AIFollowPrey
    extends Goal {
        private final EntityNeoRatlantean parentEntity;
        public int attackTimer;
        private double followDist;

        public AIFollowPrey(EntityNeoRatlantean ghast) {
            this.parentEntity = ghast;
        }

        public boolean func_75250_a() {
            this.followDist = EntityNeoRatlantean.this.func_174813_aQ().func_72320_b();
            LivingEntity LivingEntity2 = this.parentEntity.func_70638_az();
            double maxFollow = this.followDist * 5.0;
            return LivingEntity2 != null && ((double)LivingEntity2.func_70032_d((Entity)this.parentEntity) >= maxFollow || !this.parentEntity.func_70685_l((Entity)LivingEntity2));
        }

        public void func_75249_e() {
            this.attackTimer = 0;
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            LivingEntity LivingEntity2 = this.parentEntity.func_70638_az();
            double maxFollow = this.followDist * 5.0;
            if ((double)LivingEntity2.func_70032_d((Entity)this.parentEntity) >= maxFollow || !this.parentEntity.func_70685_l((Entity)LivingEntity2)) {
                EntityNeoRatlantean.this.field_70765_h.func_75642_a(LivingEntity2.field_70165_t + (double)EntityNeoRatlantean.this.field_70146_Z.nextInt(10) - 20.0, LivingEntity2.field_70163_u + 3.0, LivingEntity2.field_70161_v + (double)EntityNeoRatlantean.this.field_70146_Z.nextInt(10) - 20.0, 1.0);
            }
        }
    }

    class AIMoveControl
    extends MovementController {
        public AIMoveControl(EntityNeoRatlantean vex) {
            super((MobEntity)vex);
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                double edgeLength;
                Vec3d vec3d = new Vec3d(this.field_75646_b - EntityNeoRatlantean.this.field_70165_t, this.field_75647_c - EntityNeoRatlantean.this.field_70163_u, this.field_75644_d - EntityNeoRatlantean.this.field_70161_v);
                double d0 = vec3d.func_72433_c();
                if (d0 < (edgeLength = EntityNeoRatlantean.this.func_174813_aQ().func_72320_b())) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    EntityNeoRatlantean.this.func_213317_d(EntityNeoRatlantean.this.func_213322_ci().func_186678_a(0.5));
                } else {
                    EntityNeoRatlantean.this.func_213317_d(EntityNeoRatlantean.this.func_213322_ci().func_178787_e(vec3d.func_186678_a(this.field_75645_e * 0.1 / d0)));
                    if (EntityNeoRatlantean.this.func_70638_az() == null) {
                        Vec3d vec3d1 = EntityNeoRatlantean.this.func_213322_ci();
                        EntityNeoRatlantean.this.field_70761_aq = EntityNeoRatlantean.this.field_70177_z = -((float)MathHelper.func_181159_b((double)vec3d1.field_72450_a, (double)vec3d1.field_72449_c)) * 57.295776f;
                    } else {
                        double d4 = EntityNeoRatlantean.this.func_70638_az().field_70165_t - EntityNeoRatlantean.this.field_70165_t;
                        double d5 = EntityNeoRatlantean.this.func_70638_az().field_70161_v - EntityNeoRatlantean.this.field_70161_v;
                        EntityNeoRatlantean.this.field_70761_aq = EntityNeoRatlantean.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }
}

