/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.server.entity.EntityRat;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class EntityRatMountBase
extends MobEntity {
    protected double riderY;
    protected double riderXZ;
    protected boolean mechanical = true;
    protected Item upgrade = Items.field_190931_a;

    protected EntityRatMountBase(EntityType<? extends MobEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MoveHelperController(this);
        this.riderY = 1.1;
        this.riderXZ = 0.0;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        EntityRat rat = this.getRat();
        return rat != null && rat.func_184645_a(player, hand);
    }

    public boolean func_70039_c(CompoundNBT compound) {
        String s = this.func_70022_Q();
        compound.func_74778_a("id", s);
        super.func_70039_c(compound);
        return true;
    }

    public boolean func_82171_bF() {
        return true;
    }

    public boolean func_184186_bw() {
        return false;
    }

    public boolean shouldRiderFaceForward(PlayerEntity player) {
        return true;
    }

    public Entity func_184179_bs() {
        return this.getRat();
    }

    public EntityRat getRat() {
        if (!this.func_184188_bt().isEmpty()) {
            for (Entity entity : this.func_184188_bt()) {
                if (!(entity instanceof EntityRat)) continue;
                return (EntityRat)entity;
            }
        }
        return null;
    }

    public boolean func_180431_b(DamageSource source) {
        EntityRat rat = this.getRat();
        if (rat != null) {
            return rat.func_180431_b(source);
        }
        return super.func_180431_b(source);
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (this.func_184196_w(passenger)) {
            float radius = (float)this.riderXZ;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            double extraY = this.riderY;
            passenger.func_70107_b(this.field_70165_t + extraX, this.field_70163_u + extraY, this.field_70161_v + extraZ);
            if (passenger instanceof LivingEntity) {
                ((LivingEntity)passenger).field_70761_aq = this.field_70761_aq;
                ((LivingEntity)passenger).field_70177_z = this.field_70177_z;
                ((LivingEntity)passenger).field_70759_as = this.field_70177_z;
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        EntityRat rat = this.getRat();
        if (this.func_70638_az() != null && this.func_184191_r((Entity)this.func_70638_az())) {
            this.func_70624_b(null);
        }
        if (this.func_70638_az() != null && this.func_70638_az().func_145782_y() == this.func_145782_y()) {
            this.func_70624_b(null);
        }
        if (this.func_70638_az() != null && this.func_70638_az().func_184215_y((Entity)this)) {
            this.func_70624_b(null);
        }
        if (rat != null && rat.hasUpgrade(this.upgrade)) {
            if (this.func_70638_az() != null && rat.func_70638_az() != this.func_70638_az()) {
                this.func_70624_b(null);
            }
            if (rat.func_70638_az() != null && rat.func_70638_az() != this) {
                this.func_70624_b(rat.func_70638_az());
            }
            if (this.func_70643_av() != null && rat.func_70643_av() != this && !this.func_184191_r((Entity)this.func_70643_av())) {
                rat.func_70604_c(this.func_70643_av());
                rat.func_70624_b(this.func_70643_av());
            }
        } else {
            for (int k = 0; k < 20; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d2, d0, d1);
            }
            this.func_70106_y();
        }
    }

    protected void func_70609_aI() {
        Vec3d vec3d = this.func_213322_ci();
        EntityRat rat = this.getRat();
        if (rat != null) {
            rat.mountRespawnCooldown = 1000;
        }
        this.func_213317_d(vec3d.func_216372_d(1.0, 0.6, 1.0));
        this.field_70757_a = 20;
        ++this.field_70725_aQ;
        if (this.field_70725_aQ >= 5) {
            this.func_70106_y();
            for (int k = 0; k < 20; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)(this.mechanical ? ParticleTypes.field_197627_t : ParticleTypes.field_197627_t), this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d2, d0, d1);
            }
        }
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn == null) {
            return false;
        }
        return super.func_184191_r(entityIn) || this.getRat() != null && this.getRat().func_184191_r(entityIn);
    }

    static class MoveHelperController
    extends MovementController {
        private final EntityRatMountBase mount;

        public MoveHelperController(EntityRatMountBase mount) {
            super((MobEntity)mount);
            this.mount = mount;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.STRAFE) {
                NodeProcessor nodeprocessor;
                float f = (float)this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
                float f1 = (float)this.field_75645_e * f;
                float f2 = this.field_188489_f;
                float f3 = this.field_188490_g;
                float f4 = MathHelper.func_76129_c((float)(f2 * f2 + f3 * f3));
                if (f4 < 1.0f) {
                    f4 = 1.0f;
                }
                f4 = f1 / f4;
                float f5 = MathHelper.func_76126_a((float)(this.field_75648_a.field_70177_z * ((float)Math.PI / 180)));
                float f6 = MathHelper.func_76134_b((float)(this.field_75648_a.field_70177_z * ((float)Math.PI / 180)));
                float f7 = (f2 *= f4) * f6 - (f3 *= f4) * f5;
                float f8 = f3 * f6 + f2 * f5;
                PathNavigator pathnavigator = this.field_75648_a.func_70661_as();
                if (pathnavigator != null && (nodeprocessor = pathnavigator.func_189566_q()) != null && nodeprocessor.func_186330_a((IBlockReader)this.field_75648_a.field_70170_p, MathHelper.func_76128_c((double)(this.field_75648_a.field_70165_t + (double)f7)), MathHelper.func_76128_c((double)this.field_75648_a.field_70163_u), MathHelper.func_76128_c((double)(this.field_75648_a.field_70161_v + (double)f8))) != PathNodeType.WALKABLE) {
                    this.field_188489_f = 1.0f;
                    this.field_188490_g = 0.0f;
                    f1 = f;
                }
                this.field_75648_a.func_70659_e(f1);
                this.field_75648_a.func_191989_p(this.field_188489_f);
                this.field_75648_a.func_184646_p(this.field_188490_g);
                this.field_188491_h = MovementController.Action.WAIT;
            } else if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                this.field_188491_h = MovementController.Action.WAIT;
                double d0 = this.field_75646_b - this.field_75648_a.field_70165_t;
                double d2 = this.field_75647_c - this.field_75648_a.field_70163_u;
                double d1 = this.field_75644_d - this.field_75648_a.field_70161_v;
                double d3 = d0 * d0 + d2 * d2 + d1 * d1;
                if (d3 < 2.500000277905201E-7) {
                    this.field_75648_a.func_191989_p(0.0f);
                    return;
                }
                float f9 = (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
                this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, f9, 90.0f);
                this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                BlockPos blockpos = new BlockPos((Entity)this.field_75648_a);
                BlockState blockstate = this.field_75648_a.field_70170_p.func_180495_p(blockpos);
                Block block = blockstate.func_177230_c();
                VoxelShape voxelshape = blockstate.func_196952_d((IBlockReader)this.field_75648_a.field_70170_p, blockpos);
                if (d2 > (double)this.field_75648_a.field_70138_W && d0 * d0 + d1 * d1 < (double)Math.max(1.0f, this.field_75648_a.func_213311_cf()) || !voxelshape.func_197766_b() && this.field_75648_a.field_70163_u < voxelshape.func_197758_c(Direction.Axis.Y) + (double)blockpos.func_177956_o() && !block.func_203417_a(BlockTags.field_200029_f) && !block.func_203417_a(BlockTags.field_219748_G)) {
                    this.field_75648_a.func_70683_ar().func_75660_a();
                    this.field_188491_h = MovementController.Action.JUMPING;
                }
            } else if (this.field_188491_h == MovementController.Action.JUMPING) {
                this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                if (this.field_75648_a.field_70122_E) {
                    this.field_188491_h = MovementController.Action.WAIT;
                }
            } else {
                this.field_75648_a.func_191989_p(0.0f);
            }
        }
    }
}

