/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.server.entity.RatsEntityRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityThrownBlock
extends Entity {
    public LivingEntity shootingEntity;
    public BlockState fallTile;
    public boolean dropBlock = true;
    public CompoundNBT tileEntityData;
    private int ticksAlive;
    private int ticksInAir;

    public EntityThrownBlock(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    public EntityThrownBlock(FMLPlayMessages.SpawnEntity spawnEntity, World worldIn) {
        this(RatsEntityRegistry.THROWN_BLOCK, worldIn);
    }

    public EntityThrownBlock(EntityType type, World worldIn, BlockState blockState, LivingEntity entityNeoRatlantean) {
        super(type, worldIn);
        this.fallTile = blockState;
        this.shootingEntity = entityNeoRatlantean;
    }

    protected void func_70088_a() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K || (this.shootingEntity == null || this.shootingEntity.func_70089_S()) && this.field_70170_p.func_175667_e(new BlockPos((Entity)this))) {
            super.func_70071_h_();
            ++this.ticksInAir;
            if (this.ticksInAir > 25) {
                this.field_70145_X = true;
                RayTraceResult raytraceresult = ProjectileHelper.func_221266_a((Entity)this, (boolean)true, (this.ticksInAir >= 25 ? 1 : 0) != 0, (Entity)this.shootingEntity, (RayTraceContext.BlockMode)RayTraceContext.BlockMode.COLLIDER);
                if (raytraceresult != null && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)raytraceresult)) {
                    this.onImpact(raytraceresult);
                }
            } else {
                this.field_70145_X = false;
            }
            this.field_70165_t += this.func_213322_ci().field_72450_a;
            this.field_70163_u += this.func_213322_ci().field_72448_b;
            this.field_70161_v += this.func_213322_ci().field_72449_c;
            ProjectileHelper.func_188803_a((Entity)this, (float)0.2f);
            float f = this.getMotionFactor();
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    float f1 = 0.25f;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.field_70165_t - this.func_213322_ci().field_72450_a * 0.25, this.field_70163_u - this.func_213322_ci().field_72448_b * 0.25, this.field_70161_v - this.func_213322_ci().field_72449_c * 0.25, this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c);
                }
                f = 0.8f;
            }
            if (this.shootingEntity != null && this.shootingEntity instanceof LivingEntity && ((MobEntity)this.shootingEntity).func_70638_az() != null) {
                LivingEntity target = ((MobEntity)this.shootingEntity).func_70638_az();
                double d0 = target.field_70165_t - this.field_70165_t;
                double d1 = target.field_70163_u - this.field_70163_u;
                double d2 = target.field_70161_v - this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                d3 = MathHelper.func_76133_a((double)d3);
                Vec3d vec3d = this.func_213322_ci();
                vec3d.func_72441_c(d0 / d3 * 0.2, d1 / d3 * 0.2, d2 / d3 * 0.2);
                this.func_213317_d(vec3d);
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        } else {
            this.func_70106_y();
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
    }

    public boolean canEntityBeSeen(Entity entityIn) {
        return this.field_70170_p.func_217299_a(new RayTraceContext(new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v), new Vec3d(entityIn.field_70165_t, entityIn.field_70163_u + (double)entityIn.func_70047_e(), entityIn.field_70161_v), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)) == null;
    }

    protected float getMotionFactor() {
        return 0.95f;
    }

    protected void onImpact(RayTraceResult result) {
        if (this.fallTile != null) {
            Block block = this.fallTile.func_177230_c();
            BlockPos pos = null;
            if (result instanceof BlockRayTraceResult) {
                pos = ((BlockRayTraceResult)result).func_216350_a();
            }
            if (result instanceof EntityRayTraceResult) {
                pos = new BlockPos(((EntityRayTraceResult)result).func_216348_a());
            }
            if (pos != null) {
                TileEntity tileentity;
                for (Entity hitMobs : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(1.0, 1.0, 1.0))) {
                    hitMobs.func_70097_a(DamageSource.field_76368_d, RatConfig.neoRatlanteanAttack);
                }
                BlockPos blockpos1 = pos.func_177984_a();
                if (this.dropBlock) {
                    this.field_70170_p.func_175656_a(blockpos1, this.fallTile);
                }
                if (block instanceof FallingBlock) {
                    ((FallingBlock)block).func_176502_a_(this.field_70170_p, blockpos1, this.fallTile, this.fallTile);
                }
                if (this.tileEntityData != null && block.hasTileEntity(this.fallTile) && (tileentity = this.field_70170_p.func_175625_s(blockpos1)) != null) {
                    CompoundNBT CompoundNBT2 = tileentity.func_189515_b(new CompoundNBT());
                    for (String s : this.tileEntityData.func_150296_c()) {
                        INBT nbtbase = this.tileEntityData.func_74781_a(s);
                        if ("x".equals(s) || "y".equals(s) || "z".equals(s)) continue;
                        CompoundNBT2.func_218657_a(s, nbtbase.func_74737_b());
                    }
                    tileentity.func_145839_a(CompoundNBT2);
                    tileentity.func_70296_d();
                }
                this.func_70106_y();
            }
        }
    }

    public void writeEntityToNBT(CompoundNBT compound) {
        compound.func_218657_a("direction", (INBT)this.func_70087_a(new double[]{this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c}));
        compound.func_74768_a("life", this.ticksAlive);
        Block block = this.fallTile != null ? this.fallTile.func_177230_c() : Blocks.field_150350_a;
        ResourceLocation resourcelocation = Registry.field_212618_g.func_177774_c((Object)block);
        compound.func_74778_a("Block", resourcelocation == null ? "" : resourcelocation.toString());
        if (this.tileEntityData != null) {
            compound.func_218657_a("TileEntityData", (INBT)this.tileEntityData);
        }
    }

    public void readEntityFromNBT(CompoundNBT compound) {
        if (compound.func_150297_b("power", 9)) {
            ListNBT listNBT = compound.func_150295_c("power", 6);
        }
        this.ticksAlive = compound.func_74762_e("life");
        if (compound.func_150297_b("direction", 9) && compound.func_150295_c("direction", 6).size() == 3) {
            ListNBT nbttaglist1 = compound.func_150295_c("direction", 6);
            this.func_213293_j(nbttaglist1.func_150309_d(0), nbttaglist1.func_150309_d(1), nbttaglist1.func_150309_d(2));
        } else {
            this.func_70106_y();
        }
        int i = compound.func_74771_c("Data") & 0xFF;
        this.fallTile = compound.func_150297_b("Block", 8) ? ((Block)Registry.field_212618_g.func_82594_a(new ResourceLocation(compound.func_74779_i("Block")))).func_176223_P() : (compound.func_150297_b("TileID", 99) ? Block.func_196257_b((int)compound.func_74762_e("TileID")).getBlockState() : Block.func_196257_b((int)(compound.func_74771_c("Tile") & 0xFF)).getBlockState());
        Block block = this.fallTile.func_177230_c();
        if (block == null || block.func_176223_P().func_185904_a() == Material.field_151579_a) {
            this.fallTile = Blocks.field_150349_c.func_176223_P();
        }
        if (compound.func_150297_b("TileEntityData", 10)) {
            this.tileEntityData = compound.func_74775_l("TileEntityData");
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public float func_70111_Y() {
        return 1.0f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        this.func_70018_K();
        if (source.func_76346_g() != null) {
            Vec3d vec3d = source.func_76346_g().func_70040_Z();
            if (vec3d != null) {
                this.func_213317_d(vec3d);
            }
            if (source.func_76346_g() instanceof LivingEntity) {
                this.shootingEntity = (LivingEntity)source.func_76346_g();
            }
            return true;
        }
        return false;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

