/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class RatNukeExplosion
extends Explosion {
    private final boolean causesFire;
    private final boolean damagesTerrain;
    private final Random random = new Random();
    private final World world;
    private final double x;
    private final double y;
    private final double z;
    private final Entity exploder;
    private final float size;
    private final List<BlockPos> affectedBlockPositions = Lists.newArrayList();
    private final Map<PlayerEntity, Vec3d> playerKnockbackMap = Maps.newHashMap();
    private final Vec3d position;

    @OnlyIn(value=Dist.CLIENT)
    public RatNukeExplosion(World worldIn, Entity entityIn, double x, double y, double z, float size, List<BlockPos> affectedPositions) {
        this(worldIn, entityIn, x, y, z, size, false, true, affectedPositions);
    }

    @OnlyIn(value=Dist.CLIENT)
    public RatNukeExplosion(World worldIn, Entity entityIn, double x, double y, double z, float size, boolean causesFire, boolean damagesTerrain, List<BlockPos> affectedPositions) {
        this(worldIn, entityIn, x, y, z, size, causesFire, damagesTerrain);
        this.affectedBlockPositions.addAll(affectedPositions);
    }

    public RatNukeExplosion(World worldIn, Entity entityIn, double x, double y, double z, float size, boolean causesFire, boolean damagesTerrain) {
        super(worldIn, entityIn, x, y, z, size, causesFire, damagesTerrain ? Explosion.Mode.DESTROY : Explosion.Mode.NONE);
        this.world = worldIn;
        this.exploder = entityIn;
        this.size = size;
        this.x = x;
        this.y = y;
        this.z = z;
        this.causesFire = causesFire;
        this.damagesTerrain = damagesTerrain;
        this.position = new Vec3d(this.x, this.y, this.z);
    }

    public void func_77278_a() {
        HashSet set = Sets.newHashSet();
        int i = 16;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.x;
                    double d6 = this.y;
                    double d8 = this.z;
                    float f1 = 0.3f;
                    for (float f = this.size * (0.7f + this.world.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos(d4, d6, d8);
                        BlockState blockstate = this.world.func_180495_p(blockpos);
                        IFluidState ifluidstate = this.world.func_204610_c(blockpos);
                        if (!blockstate.isAir((IBlockReader)this.world, blockpos) || !ifluidstate.func_206888_e()) {
                            float f2 = Math.max(blockstate.getExplosionResistance((IWorldReader)this.world, blockpos, this.exploder, (Explosion)this), ifluidstate.getExplosionResistance((IWorldReader)this.world, blockpos, this.exploder, (Explosion)this));
                            if (this.exploder != null) {
                                f2 = this.exploder.func_180428_a((Explosion)this, (IBlockReader)this.world, blockpos, blockstate, ifluidstate, f2);
                            }
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && (this.exploder == null || this.exploder.func_174816_a((Explosion)this, (IBlockReader)this.world, blockpos, blockstate, f))) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(set);
        float f3 = this.size * 2.0f;
        int k1 = MathHelper.func_76128_c((double)(this.x - (double)f3 - 1.0));
        int l1 = MathHelper.func_76128_c((double)(this.x + (double)f3 + 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.y - (double)f3 - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.y + (double)f3 + 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.z - (double)f3 - 1.0));
        int j1 = MathHelper.func_76128_c((double)(this.z + (double)f3 + 1.0));
        List list = this.world.func_72839_b(this.exploder, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((World)this.world, (Explosion)this, (List)list, (double)f3);
        Vec3d vec3d = new Vec3d(this.x, this.y, this.z);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            PlayerEntity playerentity;
            double d9;
            double d7;
            double d5;
            double d13;
            double d12;
            Entity entity = (Entity)list.get(k2);
            if (entity.func_180427_aV() || !((d12 = (double)(MathHelper.func_76133_a((double)entity.func_195048_a(new Vec3d(this.x, this.y, this.z))) / f3)) <= 1.0) || (d13 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - this.x) * d5 + (d7 = entity.field_70163_u + (double)entity.func_70047_e() - this.y) * d7 + (d9 = entity.field_70161_v - this.z) * d9))) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = RatNukeExplosion.func_222259_a((Vec3d)vec3d, (Entity)entity);
            double d10 = (1.0 - d12) * d14;
            entity.func_70097_a(this.func_199591_b(), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f3 + 1.0)));
            double d11 = d10;
            if (entity instanceof LivingEntity) {
                d11 = ProtectionEnchantment.func_92092_a((LivingEntity)((LivingEntity)entity), (double)d10);
            }
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(d5 * d11, d7 * d11, d9 * d11));
            if (!(entity instanceof PlayerEntity) || (playerentity = (PlayerEntity)entity).func_175149_v() || playerentity.func_184812_l_() && playerentity.field_71075_bZ.field_75100_b) continue;
            this.playerKnockbackMap.put(playerentity, new Vec3d(d5 * d10, d7 * d10, d9 * d10));
        }
    }

    private boolean canHurt(Entity entity) {
        return this.exploder == null || !this.exploder.func_184191_r(entity);
    }

    public void func_77279_a(boolean addParticles) {
        this.world.func_184148_a(null, this.x, this.y, this.z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        if (this.size >= 2.0f && this.damagesTerrain) {
            this.world.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.x, this.y, this.z, 1.0, 0.0, 0.0);
        } else {
            this.world.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.x, this.y, this.z, 1.0, 0.0, 0.0);
        }
        if (this.damagesTerrain) {
            for (BlockPos blockpos : this.affectedBlockPositions) {
                BlockState BlockState2 = this.world.func_180495_p(blockpos);
                Block block = BlockState2.func_177230_c();
                if (addParticles) {
                    double d0 = (float)blockpos.func_177958_n() + this.world.field_73012_v.nextFloat();
                    double d1 = (float)blockpos.func_177956_o() + this.world.field_73012_v.nextFloat();
                    double d2 = (float)blockpos.func_177952_p() + this.world.field_73012_v.nextFloat();
                    double d3 = d0 - this.x;
                    double d4 = d1 - this.y;
                    double d5 = d2 - this.z;
                    double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d7 = 0.5 / (d6 / (double)this.size + 0.1);
                    this.world.func_195594_a((IParticleData)ParticleTypes.field_197627_t, (d0 + this.x) / 2.0, (d1 + this.y) / 2.0, (d2 + this.z) / 2.0, d3 *= (d7 *= (double)(this.world.field_73012_v.nextFloat() * this.world.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7);
                    this.world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, d3, d4, d5);
                }
                if (BlockState2.func_185904_a() == Material.field_151579_a) continue;
                if (block.func_149659_a((Explosion)this)) {
                    block.canDropFromExplosion(this.world.func_180495_p(blockpos), (IBlockReader)this.world, blockpos, (Explosion)this);
                }
                block.onBlockExploded(BlockState2, this.world, blockpos, (Explosion)this);
            }
        }
        if (this.causesFire) {
            for (BlockPos blockpos1 : this.affectedBlockPositions) {
                if (this.world.func_180495_p(blockpos1).func_185904_a() != Material.field_151579_a || !this.world.func_180495_p(blockpos1.func_177977_b()).func_200132_m() || this.random.nextInt(3) != 0) continue;
                this.world.func_175656_a(blockpos1, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    public Map<PlayerEntity, Vec3d> func_77277_b() {
        return this.playerKnockbackMap;
    }

    @Nullable
    public LivingEntity func_94613_c() {
        if (this.exploder == null) {
            return null;
        }
        return this.exploder instanceof LivingEntity ? (LivingEntity)this.exploder : null;
    }

    public void func_180342_d() {
        this.affectedBlockPositions.clear();
    }

    public List<BlockPos> func_180343_e() {
        return this.affectedBlockPositions;
    }

    public Vec3d getPosition() {
        return this.position;
    }
}

