/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.google.common.base.Predicates;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class RatAIFleeMobs
extends Goal {
    private final com.google.common.base.Predicate<Entity> canBeSeenSelector = new com.google.common.base.Predicate<Entity>(){

        public boolean apply(@Nullable Entity p_apply_1_) {
            return p_apply_1_.func_70089_S() && RatAIFleeMobs.this.entity.func_70635_at().func_75522_a(p_apply_1_) && !RatAIFleeMobs.this.entity.func_184191_r(p_apply_1_);
        }
    };
    private final double farSpeed;
    private final double nearSpeed;
    private final float avoidDistance;
    private final PathNavigator navigation;
    private final com.google.common.base.Predicate<Entity> avoidTargetSelector;
    protected EntityRat entity;
    protected LivingEntity closestLivingEntity;
    private Path path;

    public RatAIFleeMobs(EntityRat entityIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn) {
        this(entityIn, (com.google.common.base.Predicate<Entity>)Predicates.alwaysTrue(), avoidDistanceIn, farSpeedIn, nearSpeedIn);
    }

    public RatAIFleeMobs(EntityRat entityIn, com.google.common.base.Predicate<Entity> avoidTargetSelectorIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn) {
        this.entity = entityIn;
        this.avoidTargetSelector = avoidTargetSelectorIn;
        this.avoidDistance = avoidDistanceIn;
        this.farSpeed = farSpeedIn;
        this.nearSpeed = nearSpeedIn;
        this.navigation = entityIn.func_70661_as();
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (this.entity.func_70909_n() || this.entity.hasPlague()) {
            return false;
        }
        List ocelotList = this.entity.field_70170_p.func_175647_a(OcelotEntity.class, this.entity.func_174813_aQ().func_72314_b((double)this.avoidDistance, 8.0, (double)this.avoidDistance), (Predicate)Predicates.and(this.canBeSeenSelector, this.avoidTargetSelector));
        List playerList = this.entity.field_70170_p.func_175647_a(PlayerEntity.class, this.entity.func_174813_aQ().func_72314_b((double)this.avoidDistance, 8.0, (double)this.avoidDistance), (Predicate)Predicates.and(this.canBeSeenSelector, this.avoidTargetSelector));
        if (ocelotList.isEmpty() && playerList.isEmpty()) {
            return false;
        }
        this.closestLivingEntity = !ocelotList.isEmpty() ? (LivingEntity)ocelotList.get(0) : (LivingEntity)playerList.get(0);
        Vec3d vec3d = RandomPositionGenerator.func_75461_b((CreatureEntity)this.entity, (int)16, (int)7, (Vec3d)new Vec3d(this.closestLivingEntity.field_70165_t, this.closestLivingEntity.field_70163_u, this.closestLivingEntity.field_70161_v));
        if (vec3d == null) {
            return false;
        }
        if (this.closestLivingEntity.func_70092_e(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c) < this.closestLivingEntity.func_70068_e((Entity)this.entity)) {
            return false;
        }
        this.entity.isFleeing = true;
        this.path = this.entity.func_70661_as().func_179680_a(new BlockPos(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c), 0);
        return this.path != null;
    }

    private boolean shouldFlee(LivingEntity mob) {
        int trust = this.entity.wildTrust;
        Vec3d vec3d = mob.func_70676_i(1.0f).func_72432_b();
        Vec3d vec3d1 = new Vec3d(this.entity.field_70165_t - mob.field_70165_t, this.entity.func_174813_aQ().field_72338_b + (double)this.entity.func_70047_e() - (mob.field_70163_u + (double)mob.func_70047_e()), this.entity.field_70161_v - mob.field_70161_v);
        double d0 = vec3d1.func_72433_c();
        vec3d1 = vec3d1.func_72432_b();
        double d1 = vec3d.func_72430_b(vec3d1);
        if (trust < 100 || !(mob instanceof PlayerEntity)) {
            return d1 > 0.5 / d0 && mob.func_70685_l((Entity)this.entity);
        }
        return false;
    }

    public boolean func_75253_b() {
        return !this.entity.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        this.entity.func_70661_as().func_75484_a(this.path, this.farSpeed);
    }

    public void func_75251_c() {
        this.entity.isFleeing = false;
        this.closestLivingEntity = null;
    }

    public void func_75246_d() {
        this.entity.func_70661_as().func_75489_a(this.getRunSpeed());
    }

    public double getRunSpeed() {
        if (this.closestLivingEntity == null || !(this.closestLivingEntity instanceof PlayerEntity)) {
            if (this.entity.func_70068_e((Entity)this.closestLivingEntity) < 49.0) {
                return this.nearSpeed;
            }
            return this.farSpeed;
        }
        return 0.6 + (double)(50 - Math.min(this.entity.wildTrust, 50)) * 0.04;
    }
}

