/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;

public class RatAIHarvestMine
extends Goal {
    private final EntityRat entity;
    private final BlockSorter targetSorter;
    private BlockPos targetBlock = null;
    private int breakingTime;
    private int previousBreakProgress;
    private BlockState prevMiningState = null;

    public RatAIHarvestMine(EntityRat entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (!this.entity.canMove() || !this.entity.func_70909_n() || this.entity.getCommand() != RatCommand.HARVEST || this.entity.isInCage() || !this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MINER)) {
            return false;
        }
        if (!this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    private void resetTarget() {
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        NonNullList<ItemStack> mining = this.getMiningList();
        int RADIUS = this.entity.getSearchRadius();
        for (BlockPos pos : BlockPos.func_218281_b((BlockPos)this.entity.getSearchCenter().func_177982_a(-RADIUS, -RADIUS, -RADIUS), (BlockPos)this.entity.getSearchCenter().func_177982_a(RADIUS, RADIUS, RADIUS)).map(BlockPos::func_185334_h).collect(Collectors.toList())) {
            if (!this.doesListContainBlock(this.entity.field_70170_p, mining, pos)) continue;
            allBlocks.add(pos);
        }
        if (!allBlocks.isEmpty()) {
            allBlocks.sort(this.targetSorter);
            this.targetBlock = (BlockPos)allBlocks.get(0);
        }
    }

    private NonNullList<ItemStack> getMiningList() {
        CompoundNBT CompoundNBT1 = this.entity.getUpgrade(RatsItemRegistry.RAT_UPGRADE_MINER).func_77978_p();
        NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
        if (CompoundNBT1 != null && CompoundNBT1.func_150297_b("Items", 9)) {
            ItemStackHelper.func_191283_b((CompoundNBT)CompoundNBT1, (NonNullList)nonnulllist);
        }
        return nonnulllist;
    }

    private boolean doesListContainBlock(World world, NonNullList<ItemStack> list, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        ItemStack getStack = state.func_177230_c().func_185473_a((IBlockReader)world, pos, state);
        for (ItemStack stack : list) {
            if (!stack.func_77969_a(getStack)) continue;
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.targetBlock != null && this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b();
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
    }

    public void func_75246_d() {
        if (this.targetBlock != null) {
            BlockPos rayPos = this.entity.rayTraceBlockPos(this.targetBlock);
            if (rayPos == null) {
                rayPos = this.targetBlock;
            }
            if (this.entity.func_70661_as().func_75492_a((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p() + 0.5, 1.25)) {
                rayPos = this.targetBlock;
            } else {
                this.entity.func_70661_as().func_75492_a((double)rayPos.func_177958_n() + 0.5, (double)rayPos.func_177956_o(), (double)rayPos.func_177952_p() + 0.5, 1.25);
            }
            if (!this.entity.func_70605_aq().func_75640_a() && this.entity.field_70122_E) {
                double distance;
                BlockState block = this.entity.field_70170_p.func_180495_p(rayPos);
                SoundType soundType = block.func_177230_c().getSoundType(block, (IWorldReader)this.entity.field_70170_p, rayPos, null);
                if (RatUtils.canRatBreakBlock(this.entity.field_70170_p, rayPos, this.entity) && block.func_185904_a().func_76230_c() && block.func_185904_a() != Material.field_151579_a && (distance = this.entity.func_70092_e(rayPos.func_177958_n(), rayPos.func_177956_o(), rayPos.func_177952_p())) < 4.5 * this.entity.getRatDistanceModifier()) {
                    this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)85);
                    this.entity.crafting = true;
                    if (block == this.prevMiningState) {
                        this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)85);
                        this.entity.crafting = true;
                    } else {
                        this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)86);
                        this.entity.crafting = false;
                    }
                    if (distance < 1.5 * this.entity.getRatDistanceModifier()) {
                        this.entity.func_213293_j(0.0, 0.0, 0.0);
                        this.entity.func_70661_as().func_75499_g();
                    }
                    ++this.breakingTime;
                    int hardness = (int)(block.func_185887_b((IBlockReader)this.entity.field_70170_p, rayPos) * 50.0f);
                    int i = (int)((float)this.breakingTime / (float)hardness * 10.0f);
                    if (this.breakingTime % 5 == 0) {
                        this.entity.func_184185_a(soundType.func_185846_f(), soundType.field_185860_m + 1.0f, soundType.field_185861_n);
                    }
                    if (i != this.previousBreakProgress) {
                        this.entity.field_70170_p.func_175715_c(this.entity.func_145782_y(), rayPos, i);
                        this.previousBreakProgress = i;
                    }
                    if (this.breakingTime == hardness) {
                        this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)86);
                        this.entity.func_184185_a(soundType.func_185845_c(), soundType.field_185860_m, soundType.field_185861_n);
                        this.entity.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 1.0f);
                        this.breakingTime = 0;
                        this.previousBreakProgress = -1;
                        this.destroyBlock(rayPos, block);
                        this.entity.fleePos = rayPos;
                        this.targetBlock = null;
                        this.entity.crafting = false;
                        this.func_75251_c();
                    }
                    this.prevMiningState = block;
                }
            }
        }
    }

    private void destroyBlock(BlockPos pos, BlockState state) {
        if (this.entity.field_70170_p instanceof ServerWorld) {
            LootContext.Builder loot = new LootContext.Builder((ServerWorld)this.entity.field_70170_p).func_216015_a(LootParameters.field_216286_f, (Object)new BlockPos((Vec3i)pos)).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216023_a(this.entity.func_70681_au()).func_186469_a(1.0f);
            List drops = state.func_177230_c().func_220076_a(state, loot);
            if (!drops.isEmpty() && this.entity.canRatPickupItem((ItemStack)drops.get(0))) {
                for (ItemStack drop : drops) {
                    this.entity.func_70099_a(drop, 0.0f);
                }
                this.entity.field_70170_p.func_175655_b(pos, false);
                this.entity.fleePos = pos;
            }
        }
    }

    public class BlockSorter
    implements Comparator<BlockPos> {
        private final Entity entity;

        public BlockSorter(Entity entity) {
            this.entity = entity;
        }

        @Override
        public int compare(BlockPos pos1, BlockPos pos2) {
            double distance1 = this.getDistance(pos1);
            double distance2 = this.getDistance(pos2);
            return Double.compare(distance1, distance2);
        }

        private double getDistance(BlockPos pos) {
            double deltaX = this.entity.field_70165_t - ((double)pos.func_177958_n() + 0.5);
            double deltaY = this.entity.field_70163_u + (double)this.entity.func_70047_e() - ((double)pos.func_177956_o() + 0.5);
            double deltaZ = this.entity.field_70161_v - ((double)pos.func_177952_p() + 0.5);
            return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        }
    }
}

