/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.EnumSet;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldReader;

public class RatAIHarvestPlacer
extends Goal {
    private final EntityRat entity;
    private BlockPos targetBlock = null;

    public RatAIHarvestPlacer(EntityRat entity) {
        this.entity = entity;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (!(this.entity.canMove() && this.entity.func_70909_n() && this.entity.getCommand() == RatCommand.HARVEST && !this.entity.isInCage() && this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_PLACER) && this.holdingBlock())) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    private boolean holdingBlock() {
        ItemStack stack = this.entity.func_184586_b(Hand.MAIN_HAND);
        return !stack.func_190926_b() && stack.func_77973_b() instanceof BlockItem;
    }

    public boolean func_75253_b() {
        return this.targetBlock != null && this.holdingBlock() && this.entity.field_70170_p.func_180495_p(this.targetBlock).func_185904_a().func_76222_j();
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
    }

    public void func_75246_d() {
        if (this.targetBlock != null && this.holdingBlock()) {
            ItemStack stack = this.entity.func_184586_b(Hand.MAIN_HAND);
            BlockItem blockItem = (BlockItem)stack.func_77973_b();
            BlockState block = this.entity.field_70170_p.func_180495_p(this.targetBlock);
            BlockPos moveToPos = this.targetBlock;
            this.entity.func_70661_as().func_75492_a((double)moveToPos.func_177958_n() + 0.5, (double)moveToPos.func_177956_o(), (double)moveToPos.func_177952_p() + 0.5, 1.25);
            if (block.func_177230_c().func_196260_a(block, (IWorldReader)this.entity.field_70170_p, this.targetBlock) && this.entity.field_70170_p.func_175623_d(this.targetBlock.func_177984_a())) {
                double distance = this.entity.func_70092_e(this.targetBlock.func_177958_n(), this.targetBlock.func_177956_o(), this.targetBlock.func_177952_p());
                if (distance < 2.5 * this.entity.getRatDistanceModifier()) {
                    ItemStack seedStack = this.entity.func_184586_b(Hand.MAIN_HAND).func_77946_l();
                    seedStack.func_190920_e(1);
                    this.entity.func_184586_b(Hand.MAIN_HAND).func_190918_g(1);
                    BlockRayTraceResult raytrace = this.entity.field_70170_p.func_217299_a(new RayTraceContext(new Vec3d((Vec3i)this.targetBlock), new Vec3d((Vec3i)this.targetBlock), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.entity));
                    ItemUseContext itemusecontext = new ItemUseContext(null, Hand.MAIN_HAND, raytrace);
                    BlockState BlockState1 = blockItem.func_179223_d().func_196258_a(new BlockItemUseContext(itemusecontext));
                    this.entity.field_70170_p.func_175656_a(this.targetBlock, BlockState1);
                    if (this.entity.func_70094_T()) {
                        this.entity.func_70107_b(this.entity.field_70165_t, this.entity.field_70163_u + 1.0, this.entity.field_70161_v);
                    }
                    SoundType placeSound = BlockState1.func_177230_c().getSoundType(BlockState1, (IWorldReader)this.entity.field_70170_p, this.targetBlock, (Entity)this.entity);
                    this.entity.func_184185_a(placeSound.func_185841_e(), (placeSound.func_185843_a() + 1.0f) / 2.0f, placeSound.func_185847_b() * 0.8f);
                    this.targetBlock = null;
                    this.func_75251_c();
                }
            } else {
                this.targetBlock = null;
                this.func_75251_c();
            }
        }
    }

    private void resetTarget() {
        BlockPos newTarget = null;
        if (this.entity.func_213394_dL() && !this.entity.field_70170_p.func_180495_p(newTarget = this.entity.func_213384_dI()).func_185904_a().func_76222_j()) {
            newTarget = newTarget.func_177984_a();
        }
        if (newTarget != null) {
            this.targetBlock = newTarget;
        }
    }
}

