/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.events;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.entity.EntityIllagerPiper;
import com.github.alexthe666.rats.server.entity.EntityPlagueDoctor;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.EntityRatMountBase;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.entity.RatsEntityRegistry;
import com.github.alexthe666.rats.server.events.RatsCustomEvents;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.message.MessageCheeseStaffRat;
import com.github.alexthe666.rats.server.message.MessageRatDismount;
import com.github.alexthe666.rats.server.message.MessageSwingArm;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.HuskEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.IProperty;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="rats")
public class CommonEvents {
    @SubscribeEvent
    public static void onPlayerInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        ItemStack heldItem;
        if (RatUtils.isPredator(event.getTarget()) && event.getTarget() instanceof AnimalEntity) {
            AnimalEntity ocelot = (AnimalEntity)event.getTarget();
            Item heldItem2 = event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b();
            Random random = event.getWorld().field_73012_v;
            if (ocelot.func_110143_aJ() < ocelot.func_110138_aP()) {
                int i;
                if (heldItem2 == RatsItemRegistry.RAW_RAT) {
                    ocelot.func_70691_i(4.0f);
                    event.getWorld().func_184148_a(null, ocelot.field_70165_t, ocelot.field_70163_u, ocelot.field_70161_v, SoundEvents.field_191253_dD, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    event.getWorld().func_184148_a(null, ocelot.field_70165_t, ocelot.field_70163_u, ocelot.field_70161_v, SoundEvents.field_187636_O, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    for (i = 0; i < 3; ++i) {
                        event.getWorld().func_195594_a((IParticleData)ParticleTypes.field_197632_y, ocelot.field_70165_t + random.nextDouble() - random.nextDouble(), ocelot.field_70163_u + 0.5 + random.nextDouble() - random.nextDouble(), ocelot.field_70161_v + random.nextDouble() - random.nextDouble(), 0.0, 0.0, 0.0);
                    }
                }
                if (heldItem2 == RatsItemRegistry.COOKED_RAT) {
                    ocelot.func_70691_i(8.0f);
                    event.getWorld().func_184148_a(null, ocelot.field_70165_t, ocelot.field_70163_u, ocelot.field_70161_v, SoundEvents.field_191253_dD, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    event.getWorld().func_184148_a(null, ocelot.field_70165_t, ocelot.field_70163_u, ocelot.field_70161_v, SoundEvents.field_187636_O, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                    for (i = 0; i < 3; ++i) {
                        event.getWorld().func_195594_a((IParticleData)ParticleTypes.field_197632_y, ocelot.field_70165_t + random.nextDouble() - random.nextDouble(), ocelot.field_70163_u + 0.5 + random.nextDouble() - random.nextDouble(), ocelot.field_70161_v + random.nextDouble() - random.nextDouble(), 0.0, 0.0, 0.0);
                    }
                }
            }
        }
        if (event.getTarget() instanceof VillagerEntity && (heldItem = event.getEntityPlayer().func_184586_b(event.getHand())).func_77973_b() == RatsItemRegistry.PLAGUE_DOCTORATE && !((VillagerEntity)event.getTarget()).func_70631_g_()) {
            VillagerEntity villager = (VillagerEntity)event.getTarget();
            EntityPlagueDoctor doctor = new EntityPlagueDoctor(RatsEntityRegistry.PLAGUE_DOCTOR, event.getWorld());
            doctor.func_82149_j((Entity)villager);
            villager.func_70106_y();
            doctor.func_213386_a((IWorld)event.getWorld(), event.getWorld().func_175649_E(event.getPos()), SpawnReason.MOB_SUMMONED, null, null);
            if (!event.getWorld().field_72995_K) {
                event.getWorld().func_217376_c((Entity)doctor);
            }
            doctor.func_94061_f(villager.func_175446_cd());
            if (villager.func_145818_k_()) {
                doctor.func_200203_b(villager.func_200201_e());
            }
            event.getEntityPlayer().func_184609_a(event.getHand());
            if (!event.getEntityPlayer().func_184812_l_()) {
                heldItem.func_190918_g(1);
            }
        }
        if (event.getEntityPlayer().func_70644_a(RatsMod.PLAGUE_POTION) && RatConfig.plagueSpread && !(event.getTarget() instanceof EntityRat) && event.getTarget() instanceof LivingEntity && !((LivingEntity)event.getTarget()).func_70644_a(RatsMod.PLAGUE_POTION)) {
            ((LivingEntity)event.getTarget()).func_195064_c(new EffectInstance(RatsMod.PLAGUE_POTION, 6000));
            event.getTarget().func_184185_a(SoundEvents.field_187945_hs, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void onHitEntity(LivingAttackEvent event) {
        LivingEntity attacker;
        if (event.getSource().func_76364_f() instanceof LivingEntity && RatConfig.plagueSpread && (attacker = (LivingEntity)event.getSource().func_76364_f()).func_70644_a(RatsMod.PLAGUE_POTION) && !(event.getEntityLiving() instanceof EntityRat) && !event.getEntityLiving().func_70644_a(RatsMod.PLAGUE_POTION)) {
            event.getEntityLiving().func_195064_c(new EffectInstance(RatsMod.PLAGUE_POTION, 6000));
            event.getEntityLiving().func_184185_a(SoundEvents.field_187945_hs, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void onPlayerPunch(AttackEntityEvent event) {
        ItemStack itemstack = event.getEntityPlayer().func_184586_b(Hand.MAIN_HAND);
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() != null && event.getEntity() instanceof IronGolemEntity && RatConfig.golemsTargetRats) {
            IronGolemEntity golem = (IronGolemEntity)event.getEntity();
            golem.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)golem, EntityRat.class, 10, false, false, RatUtils.UNTAMED_RAT_SELECTOR));
        }
        if (event.getEntity() != null && RatUtils.isPredator(event.getEntity()) && event.getEntity() instanceof AnimalEntity) {
            AnimalEntity animal = (AnimalEntity)event.getEntity();
            animal.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)animal, EntityRat.class, true));
        }
        if (event.getEntity() != null && event.getEntity() instanceof HuskEntity && ((HuskEntity)event.getEntity()).func_70681_au().nextFloat() < RatConfig.archeologistHatSpawnRate) {
            event.getEntity().func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)RatsItemRegistry.ARCHEOLOGIST_HAT));
        }
    }

    @SubscribeEvent
    public static void onPlayerLeftClick(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack itemstack = event.getEntityPlayer().func_184586_b(Hand.MAIN_HAND);
        RatsCustomEvents.onPlayerSwing(event.getPlayer(), itemstack);
        RatsMod.NETWORK_WRAPPER.sendToServer((Object)new MessageSwingArm());
        if (event.getEntityPlayer().func_70093_af() && !event.getEntityPlayer().func_184188_bt().isEmpty()) {
            for (Entity passenger : event.getEntityPlayer().func_184188_bt()) {
                if (!(passenger instanceof EntityRat)) continue;
                passenger.func_184210_p();
                passenger.func_70107_b(event.getEntityPlayer().field_70165_t, event.getEntityPlayer().field_70163_u, event.getEntityPlayer().field_70161_v);
                RatsMod.NETWORK_WRAPPER.sendToServer((Object)new MessageRatDismount(passenger.func_145782_y()));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack itemstack = event.getEntityPlayer().func_184586_b(Hand.MAIN_HAND);
    }

    @SubscribeEvent
    public static void onGatherCollisionBoxes(GetCollisionBoxesEvent event) {
        if (event.getEntity() instanceof EntityRat) {
            event.getCollisionBoxesList().removeIf(aabb -> ((EntityRat)event.getEntity()).canPhaseThroughBlock(event.getWorld(), new BlockPos(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c)));
        }
    }

    @SubscribeEvent
    public static void onDrops(LivingDropsEvent event) {
        if (event.getEntityLiving() instanceof EntityIllagerPiper && event.getSource().func_76346_g() instanceof PlayerEntity && event.getEntityLiving().field_70170_p.field_73012_v.nextFloat() < RatConfig.piperHatDropRate + RatConfig.piperHatDropRate / 2.0f * (float)event.getLootingLevel()) {
            event.getDrops().add(new ItemEntity(event.getEntity().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, new ItemStack((IItemProvider)RatsItemRegistry.PIPER_HAT)));
        }
        if (event.getEntityLiving() instanceof CreeperEntity && ((CreeperEntity)event.getEntityLiving()).func_70830_n()) {
            event.getDrops().add(new ItemEntity(event.getEntity().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, new ItemStack((IItemProvider)RatsItemRegistry.CHARGED_CREEPER_CHUNK, event.getLootingLevel() + 1 + event.getEntityLiving().field_70170_p.field_73012_v.nextInt(2))));
        }
        if (event.getSource().func_76346_g() instanceof EntityRat && ((EntityRat)event.getSource().func_76346_g()).hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ARISTOCRAT)) {
            event.getDrops().add(new ItemEntity(event.getEntity().field_70170_p, event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u, event.getEntityLiving().field_70161_v, new ItemStack((IItemProvider)RatsItemRegistry.TINY_COIN)));
        }
    }

    @SubscribeEvent
    public static void onLivingHeal(LivingHealEvent event) {
        if (event.getEntityLiving().func_70660_b(RatsMod.PLAGUE_POTION) != null) {
            EffectInstance effect = event.getEntityLiving().func_70660_b(RatsMod.PLAGUE_POTION);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            AxisAlignedBB axisalignedbb = event.getEntityLiving().func_174813_aQ().func_72314_b(RatConfig.ratVoodooDistance, RatConfig.ratVoodooDistance, RatConfig.ratVoodooDistance);
            List list = event.getEntityLiving().field_70170_p.func_217357_a(EntityRat.class, axisalignedbb);
            ArrayList<EntityRat> voodooRats = new ArrayList<EntityRat>();
            boolean capturedRat = false;
            if (!list.isEmpty()) {
                for (EntityRat rat : list) {
                    if (!rat.func_70909_n() || !rat.func_152114_e(event.getEntityLiving()) || !rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_VOODOO)) continue;
                    voodooRats.add(rat);
                }
                if (!voodooRats.isEmpty()) {
                    float damage = event.getAmount() / (float)Math.max(1, voodooRats.size());
                    event.setCanceled(true);
                    for (EntityRat rat : voodooRats) {
                        rat.func_70097_a(event.getSource(), damage);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        EntityRat rat;
        if (event.getTarget() instanceof EntityRatMountBase && (rat = ((EntityRatMountBase)event.getTarget()).getRat()) != null && event.getEntityLiving() instanceof IMob && rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_UNDEAD)) {
            event.getEntityLiving().func_70604_c(null);
            if (event.getEntityLiving() instanceof MobEntity) {
                ((MobEntity)event.getEntityLiving()).func_70624_b(null);
            }
        }
        if (event.getTarget() instanceof EntityRat) {
            rat = (EntityRat)event.getTarget();
            if (event.getEntityLiving() instanceof IMob && rat.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_UNDEAD)) {
                event.getEntityLiving().func_70604_c(null);
                if (event.getEntityLiving() instanceof MobEntity) {
                    ((MobEntity)event.getEntityLiving()).func_70624_b(null);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        Random rand;
        if (event.getEntityLiving().field_70170_p.field_72995_K && (event.getEntityLiving().func_70644_a(RatsMod.PLAGUE_POTION) || event.getEntityLiving() instanceof EntityRat && ((EntityRat)event.getEntityLiving()).hasPlague()) && (rand = event.getEntityLiving().func_70681_au()).nextInt(4) == 0) {
            int entitySize = 1;
            if (event.getEntityLiving().func_174813_aQ().func_72320_b() > 0.0) {
                entitySize = Math.max(1, (int)event.getEntityLiving().func_174813_aQ().func_72320_b());
            }
            for (int i = 0; i < entitySize; ++i) {
                float motionX = rand.nextFloat() * 0.1f - 0.05f;
                float motionZ = rand.nextFloat() * 0.1f - 0.05f;
                RatsMod.PROXY.addParticle("flea", event.getEntityLiving().field_70165_t + (double)(rand.nextFloat() * event.getEntityLiving().func_213311_cf() * 2.0f) - (double)event.getEntityLiving().func_213311_cf(), event.getEntityLiving().field_70163_u + (double)(rand.nextFloat() * event.getEntityLiving().func_213302_cg()), event.getEntityLiving().field_70161_v + (double)(rand.nextFloat() * event.getEntityLiving().func_213311_cf() * 2.0f) - (double)event.getEntityLiving().func_213311_cf(), motionX, 0.0, motionZ);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntityPlayer().func_184586_b(Hand.MAIN_HAND).func_77973_b() == RatsItemRegistry.CHEESE_STICK || event.getEntityPlayer().func_184586_b(Hand.OFF_HAND).func_77973_b() == RatsItemRegistry.CHEESE_STICK) {
            event.setCanceled(true);
            RatsMod.PROXY.setCheeseStaffContext(event.getPos(), event.getFace());
            Entity rat = null;
            ItemStack stack = event.getPlayer().func_184586_b(event.getHand());
            if (stack.func_77978_p() != null && stack.func_77978_p().func_186855_b("RatUUID") && !event.getWorld().func_201670_d() && event.getWorld() instanceof ServerWorld) {
                rat = ((ServerWorld)event.getWorld()).func_217461_a(stack.func_77978_p().func_186857_a("RatUUID"));
            }
            event.getPlayer().func_184609_a(event.getHand());
            if (!event.getWorld().field_72995_K && rat != null && rat instanceof EntityRat) {
                RatsMod.sendMSGToAll(new MessageCheeseStaffRat(rat.func_145782_y(), false));
                EntityRat boundRat = (EntityRat)rat;
                RatsMod.PROXY.setRefrencedRat(boundRat);
                event.getPlayer().func_184609_a(event.getHand());
            }
            RatsMod.PROXY.openCheeseStaffGui();
        }
        if (!(event.getEntityPlayer().func_184586_b(Hand.MAIN_HAND).func_77973_b() != RatsItemRegistry.CHUNKY_CHEESE_TOKEN && event.getEntityPlayer().func_184586_b(Hand.OFF_HAND).func_77973_b() != RatsItemRegistry.CHUNKY_CHEESE_TOKEN || RatConfig.disableRatlantis)) {
            if (!event.getEntityPlayer().func_184812_l_()) {
                event.getItemStack().func_190918_g(1);
            }
            boolean canBuild = true;
            BlockPos pos = event.getPos().func_177972_a(event.getFace());
            for (int i = 0; i < 4; ++i) {
                BlockState state = event.getWorld().func_180495_p(pos.func_177981_b(i));
                if (state.func_185887_b((IBlockReader)event.getWorld(), pos.func_177981_b(i)) != -1.0f) continue;
                canBuild = false;
            }
            if (canBuild) {
                event.getEntityPlayer().func_184185_a(SoundEvents.field_193782_bq, 1.0f, 1.0f);
                event.getWorld().func_175656_a(pos, RatsBlockRegistry.MARBLED_CHEESE_RAW.func_176223_P());
                event.getWorld().func_175656_a(pos.func_177984_a(), RatsBlockRegistry.RATLANTIS_PORTAL.func_176223_P());
                event.getWorld().func_175656_a(pos.func_177981_b(2), RatsBlockRegistry.RATLANTIS_PORTAL.func_176223_P());
                event.getWorld().func_175656_a(pos.func_177981_b(3), RatsBlockRegistry.MARBLED_CHEESE_RAW.func_176223_P());
            }
        }
        if (RatConfig.cheesemaking && event.getWorld().func_180495_p(event.getPos()).func_177230_c() == Blocks.field_150383_bp && RatUtils.isMilk(event.getItemStack()) && (Integer)event.getWorld().func_180495_p(event.getPos()).func_177229_b((IProperty)CauldronBlock.field_176591_a) == 0) {
            event.getWorld().func_175656_a(event.getPos(), RatsBlockRegistry.MILK_CAULDRON.func_176223_P());
            if (!event.getWorld().field_72995_K) {
                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)event.getEntityPlayer(), event.getPos(), new ItemStack((IItemProvider)RatsBlockRegistry.MILK_CAULDRON));
            }
            event.getEntityPlayer().func_184185_a(SoundEvents.field_187624_K, 1.0f, 1.0f);
            if (!event.getEntityPlayer().func_184812_l_()) {
                LazyOptional fluidHandler;
                if (event.getItemStack().func_77973_b() == Items.field_151117_aB) {
                    event.getItemStack().func_190918_g(1);
                    event.getEntityPlayer().func_191521_c(new ItemStack((IItemProvider)Items.field_151133_ar));
                } else if (RatUtils.isMilk(event.getItemStack()) && (fluidHandler = FluidUtil.getFluidHandler((ItemStack)event.getItemStack())).isPresent() && fluidHandler.orElse(null) != null) {
                    ((IFluidHandlerItem)fluidHandler.orElse(null)).drain(1000, IFluidHandler.FluidAction.EXECUTE);
                }
            }
            event.setCanceled(true);
        }
    }
}

