/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemGenericFood
extends Item {
    private int healAmount;
    private float saturation;

    public ItemGenericFood(int amount, float saturation, boolean isWolfFood, boolean eatFast, boolean alwaysEdible, String name) {
        super(new Item.Properties().func_221540_a(ItemGenericFood.createFood(amount, saturation, isWolfFood, eatFast, alwaysEdible, null)).func_200916_a(RatsMod.TAB));
        this.setRegistryName("rats", name);
        this.healAmount = amount;
        this.saturation = saturation;
    }

    public static final Food createFood(int amount, float saturation, boolean isWolfFood, boolean eatFast, boolean alwaysEdible, EffectInstance potion) {
        Food.Builder builder = new Food.Builder();
        builder.func_221456_a(amount);
        builder.func_221454_a(saturation);
        if (isWolfFood) {
            builder.func_221451_a();
        }
        if (eatFast) {
            builder.func_221457_c();
        }
        if (alwaysEdible) {
            builder.func_221455_b();
        }
        if (potion != null) {
            builder.func_221452_a(potion, 1.0f);
        }
        return builder.func_221453_d();
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, LivingEntity LivingEntity2) {
        if (this == RatsItemRegistry.CONFIT_BYALDI || this == RatsItemRegistry.POTATO_KNISHES) {
            if (LivingEntity2 instanceof PlayerEntity) {
                PlayerEntity PlayerEntity2 = (PlayerEntity)LivingEntity2;
                PlayerEntity2.func_71024_bL().func_75122_a(this.healAmount, this.saturation);
                worldIn.func_184148_a(null, PlayerEntity2.field_70165_t, PlayerEntity2.field_70163_u, PlayerEntity2.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
                this.onFoodEaten(stack, worldIn, PlayerEntity2);
                if (PlayerEntity2 instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_193138_y.func_193148_a((ServerPlayerEntity)PlayerEntity2, stack);
                }
            }
            if (!(LivingEntity2 instanceof PlayerEntity) || !((PlayerEntity)LivingEntity2).func_184812_l_()) {
                stack.func_190918_g(1);
            }
            return stack;
        }
        return super.func_77654_b(stack, worldIn, LivingEntity2);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (this == RatsItemRegistry.CONFIT_BYALDI || this == RatsItemRegistry.POTATO_KNISHES) {
            ItemStack itemstack = playerIn.func_184586_b(handIn);
            playerIn.func_184598_c(handIn);
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    protected void onFoodEaten(ItemStack stack, World worldIn, PlayerEntity player) {
        if (!worldIn.field_72995_K && this == RatsItemRegistry.CONTAMINATED_FOOD) {
            Random rand = new Random();
            if ((double)rand.nextFloat() < 0.3) {
                player.func_195064_c(new EffectInstance(RatsMod.PLAGUE_POTION, 2400));
            }
            if ((double)rand.nextFloat() < 0.3) {
                player.func_195064_c(new EffectInstance(Effects.field_76436_u, 2400));
            }
            if ((double)rand.nextFloat() < 0.3) {
                player.func_195064_c(new EffectInstance(Effects.field_76438_s, 2400));
            }
            if ((double)rand.nextFloat() < 0.3) {
                player.func_195064_c(new EffectInstance(Effects.field_76431_k, 2400));
            }
            if ((double)rand.nextFloat() < 0.3) {
                player.func_195064_c(new EffectInstance(Effects.field_76437_t, 2400));
            }
            if ((double)rand.nextFloat() < 0.3) {
                player.func_195064_c(new EffectInstance(Effects.field_82731_v, 2400));
            }
            if ((double)rand.nextFloat() < 0.3) {
                player.func_195064_c(new EffectInstance(Effects.field_76421_d, 2400));
            }
            player.func_195064_c(new EffectInstance(Effects.field_189112_A, 2400));
        }
        if (!(worldIn.field_72995_K || this != RatsItemRegistry.CONFIT_BYALDI && this != RatsItemRegistry.POTATO_KNISHES)) {
            player.func_195064_c(new EffectInstance(RatsMod.CONFIT_BYALDI_POTION, this == RatsItemRegistry.POTATO_KNISHES ? 1200 : 2400));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this == RatsItemRegistry.RAT_BURGER) {
            tooltip.add(new TranslationTextComponent("item.rats.rat_burger.desc", new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
        if (this == RatsItemRegistry.CONTAMINATED_FOOD) {
            tooltip.add(new TranslationTextComponent("item.rats.contaminated_food.desc0", new Object[0]).func_211708_a(TextFormatting.GRAY));
            tooltip.add(new TranslationTextComponent("item.rats.contaminated_food.desc1", new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
    }
}

