/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.world.structure;

import com.github.alexthe666.rats.server.world.gen.RatStructure;
import com.github.alexthe666.rats.server.world.gen.RatsStructureProcessor;
import com.github.alexthe666.rats.server.world.structure.RatlantisStructureRegistry;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class RatlantisRuinsPiece {
    private static final BlockPos STRUCTURE_OFFSET = new BlockPos(0, 0, 0);

    public static void func_204760_a(TemplateManager p_204760_0_, BlockPos p_204760_1_, Rotation p_204760_2_, List<StructurePiece> p_204760_3_, Random p_204760_4_) {
        RatStructure model;
        int chance = p_204760_4_.nextInt(100);
        if (chance < 10) {
            model = p_204760_4_.nextBoolean() ? RatStructure.CHEESE_STATUETTE : RatStructure.GIANT_CHEESE;
        } else if (chance < 50) {
            switch (p_204760_4_.nextInt(5)) {
                case 1: {
                    model = RatStructure.PILLAR;
                    break;
                }
                case 2: {
                    model = RatStructure.PILLAR_LEANING;
                    break;
                }
                case 3: {
                    model = RatStructure.PILLAR_COLLECTION;
                    break;
                }
                case 4: {
                    model = RatStructure.PILLAR_THIN;
                    break;
                }
                default: {
                    model = RatStructure.PILLAR_LEANING;
                    break;
                }
            }
        } else if (chance < 70) {
            switch (p_204760_4_.nextInt(5)) {
                case 1: {
                    model = RatStructure.TOWER;
                    break;
                }
                case 2: {
                    model = RatStructure.FORUM;
                    break;
                }
                case 3: {
                    model = RatStructure.HUT;
                    break;
                }
                case 4: {
                    model = RatStructure.PALACE;
                    break;
                }
                default: {
                    model = RatStructure.TEMPLE;
                    break;
                }
            }
        } else if (chance < 96) {
            switch (p_204760_4_.nextInt(4)) {
                case 1: {
                    model = RatStructure.SPHINX;
                    break;
                }
                case 2: {
                    model = RatStructure.LINCOLN;
                    break;
                }
                case 3: {
                    model = RatStructure.CHEESE_STATUETTE;
                    break;
                }
                default: {
                    model = RatStructure.HEAD;
                    break;
                }
            }
        } else {
            model = RatStructure.COLOSSUS;
        }
        p_204760_3_.add((StructurePiece)new Piece(p_204760_0_, model.structureLoc, p_204760_1_, p_204760_2_, p_204760_4_));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final Rotation rotation;
        private final ResourceLocation field_204756_e;
        private final Random random;

        public Piece(TemplateManager p_i48904_1_, ResourceLocation p_i48904_2_, BlockPos p_i48904_3_, Rotation p_i48904_4_, Random random) {
            super(RatlantisStructureRegistry.RAT_RUINS_TYPE, 0);
            this.field_186178_c = p_i48904_3_;
            this.rotation = p_i48904_4_;
            this.field_204756_e = p_i48904_2_;
            this.func_204754_a(p_i48904_1_);
            this.field_186176_a = p_i48904_1_.func_200219_b(p_i48904_2_);
            this.random = new Random();
        }

        public Piece(TemplateManager p_i50445_1_, CompoundNBT p_i50445_2_) {
            super(RatlantisStructureRegistry.RAT_RUINS_TYPE, p_i50445_2_);
            this.field_204756_e = new ResourceLocation(p_i50445_2_.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)p_i50445_2_.func_74779_i("Rot"));
            this.func_204754_a(p_i50445_1_);
            this.field_186176_a = p_i50445_1_.func_200219_b(RatStructure.PILLAR_LEANING.structureLoc);
            this.random = new Random();
        }

        protected void func_143011_b(CompoundNBT p_143011_1_) {
            super.func_143011_b(p_143011_1_);
            p_143011_1_.func_74778_a("Template", this.field_204756_e.toString());
            p_143011_1_.func_74778_a("Rot", this.rotation.name());
        }

        private void func_204754_a(TemplateManager p_204754_1_) {
            Template lvt_2_1_ = p_204754_1_.func_200220_a(this.field_204756_e);
            PlacementSettings lvt_3_1_ = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_207665_a(STRUCTURE_OFFSET).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c);
            this.func_186173_a(lvt_2_1_, this.field_186178_c, lvt_3_1_);
        }

        protected void func_186175_a(String p_186175_1_, BlockPos p_186175_2_, IWorld p_186175_3_, Random p_186175_4_, MutableBoundingBox p_186175_5_) {
        }

        public boolean func_74875_a(IWorld world, Random random, MutableBoundingBox bb, ChunkPos chunkCoords) {
            this.field_186177_b.func_215222_a((StructureProcessor)new RatsStructureProcessor(0.75f + random.nextFloat() * 0.75f));
            BlockPos inital = this.field_186178_c.func_177982_a(this.field_186176_a.func_186259_a().func_177958_n() / 2, 0, this.field_186176_a.func_186259_a().func_177952_p() / 2);
            int lvt_8_1_ = world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, inital.func_177958_n(), inital.func_177952_p()) - random.nextInt(4);
            BlockPos pos = new BlockPos(inital.func_177958_n(), lvt_8_1_, inital.func_177952_p());
            while (world.func_180495_p(pos.func_177977_b()).func_185904_a().func_76224_d() && pos.func_177956_o() > 3) {
                pos = pos.func_177977_b();
            }
            this.field_186178_c = new BlockPos(this.field_186178_c.func_177958_n(), pos.func_177956_o() - 3, this.field_186178_c.func_177952_p());
            return super.func_74875_a(world, random, bb, chunkCoords);
        }
    }
}

