/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.event;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.client.model.ModelStaticRat;
import com.github.alexthe666.rats.client.render.entity.RenderRatProtector;
import com.github.alexthe666.rats.client.render.type.RatsRenderType;
import com.github.alexthe666.rats.server.events.CommonEvents;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    public static final ResourceLocation PLAGUE_HEART_TEXTURE = new ResourceLocation("rats:textures/gui/plague_hearts.png");
    private static final ResourceLocation RADIUS_TEXTURE = new ResourceLocation("rats:textures/entity/rat/rat_radius.png");
    private static final ResourceLocation SYNESTHESIA = new ResourceLocation("rats:shaders/post/synesthesia.json");
    public static int left_height = 39;
    public static int right_height = 39;
    private int updateCounter = 0;
    private int playerHealth = 0;
    private int lastPlayerHealth = 0;
    private long healthUpdateCounter = 0L;
    private long lastSystemTime = 0L;
    private Random rand = new Random();
    private float synesthesiaProgress = 0.0f;
    private float prevSynesthesiaProgress = 0.0f;
    private float maxSynesthesiaProgress = 40.0f;
    private static final ModelStaticRat RAT_MODEL = new ModelStaticRat(0);

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderOverlay(RenderGameOverlayEvent.Pre event) {
        boolean highlight;
        if (event.getType() != RenderGameOverlayEvent.ElementType.HEALTH || event.isCanceled() || !Minecraft.func_71410_x().field_71439_g.func_70644_a(RatsMod.PLAGUE_POTION) || !RatConfig.plagueHearts) {
            return;
        }
        left_height = 39;
        int width = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
        int height = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
        GlStateManager.func_227740_m_();
        PlayerEntity player = (PlayerEntity)Minecraft.func_71410_x().func_175606_aa();
        int health = MathHelper.func_76123_f((float)player.func_110143_aJ());
        boolean bl = highlight = this.healthUpdateCounter > (long)this.updateCounter && (this.healthUpdateCounter - (long)this.updateCounter) / 3L % 2L == 1L;
        if (health < this.playerHealth && player.field_70172_ad > 0) {
            this.lastSystemTime = Util.func_211177_b();
            this.healthUpdateCounter = this.updateCounter + 20;
        } else if (health > this.playerHealth && player.field_70172_ad > 0) {
            this.lastSystemTime = Util.func_211177_b();
            this.healthUpdateCounter = this.updateCounter + 10;
        }
        if (Util.func_211177_b() - this.lastSystemTime > 1000L) {
            this.playerHealth = health;
            this.lastPlayerHealth = health;
            this.lastSystemTime = Util.func_211177_b();
        }
        this.playerHealth = health;
        int healthLast = this.lastPlayerHealth;
        IAttributeInstance attrMaxHealth = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        float healthMax = (float)attrMaxHealth.func_111126_e();
        float absorb = MathHelper.func_76123_f((float)player.func_110139_bj());
        int healthRows = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        this.rand.setSeed(this.updateCounter * 312871);
        int left = width / 2 - 91;
        int top = height - left_height;
        left_height += healthRows * rowHeight;
        if (rowHeight != 10) {
            left_height += 10 - rowHeight;
        }
        int regen = -1;
        if (player.func_70644_a(Effects.field_76428_l)) {
            regen = this.updateCounter % 25;
        }
        boolean TOP = false;
        int MARGIN = 0;
        int BACKGROUND = 9;
        float absorbRemaining = absorb;
        for (int i = MathHelper.func_76123_f((float)((healthMax + absorb) / 2.0f)) - 1; i >= 0; --i) {
            int row = MathHelper.func_76123_f((float)((float)(i + 1) / 10.0f)) - 1;
            int x = left + i % 10 * 8;
            int y = top - row * rowHeight;
            if (health <= 4) {
                y += this.rand.nextInt(2);
            }
            if (i == regen) {
                y -= 2;
            }
            this.drawTexturedModalRect(x, y, MARGIN, BACKGROUND, 9, 9);
            if (highlight) {
                if (i * 2 + 1 < healthLast) {
                    this.drawTexturedModalRect(x, y, MARGIN, 0, 9, 9);
                } else if (i * 2 + 1 == healthLast) {
                    this.drawTexturedModalRect(x, y, MARGIN + 9, 0, 9, 9);
                }
            }
            if (absorbRemaining > 0.0f) {
                if (absorbRemaining == absorb && absorb % 2.0f == 1.0f) {
                    this.drawTexturedModalRect(x, y, MARGIN, 0, 9, 9);
                    absorbRemaining -= 1.0f;
                    continue;
                }
                this.drawTexturedModalRect(x, y, MARGIN + 9, 0, 9, 9);
                absorbRemaining -= 2.0f;
                continue;
            }
            if (i * 2 + 1 < health) {
                this.drawTexturedModalRect(x, y, MARGIN, 0, 9, 9);
                continue;
            }
            if (i * 2 + 1 != health) continue;
            this.drawTexturedModalRect(x, y, MARGIN + 9, 0, 9, 9);
        }
        GlStateManager.func_227737_l_();
        Minecraft.func_71410_x().func_213239_aq().func_76319_b();
    }

    private void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(PLAGUE_HEART_TEXTURE);
        Minecraft.func_71410_x().field_71456_v.blit(x, y, textureX, textureY, width, height);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() == Minecraft.func_71410_x().field_71439_g) {
            GameRenderer renderer = Minecraft.func_71410_x().field_71460_t;
            EffectInstance active = event.getEntityLiving().func_70660_b(RatsMod.CONFIT_BYALDI_POTION);
            boolean synesthesia = active != null;
            try {
                if (synesthesia && renderer.func_147706_e() == null) {
                    renderer.func_175069_a(SYNESTHESIA);
                }
                if (!synesthesia && renderer != null && renderer.func_147706_e() != null && renderer.func_147706_e().func_148022_b() != null && SYNESTHESIA.toString().equals(renderer.func_147706_e().func_148022_b())) {
                    renderer.func_181022_b();
                }
            }
            catch (Exception e) {
                RatsMod.LOGGER.warn("Game tried to crash when applying shader");
            }
            if (this.prevSynesthesiaProgress == 2.0f && synesthesia) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)RatsSoundRegistry.POTION_EFFECT_BEGIN, (float)1.0f));
            }
            if (this.prevSynesthesiaProgress == 38.0f && !synesthesia) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)RatsSoundRegistry.POTION_EFFECT_END, (float)1.0f));
            }
            this.prevSynesthesiaProgress = this.synesthesiaProgress;
            if (synesthesia && this.synesthesiaProgress < this.maxSynesthesiaProgress) {
                this.synesthesiaProgress += 2.0f;
            } else if (!synesthesia && this.synesthesiaProgress > 0.0f) {
                this.synesthesiaProgress -= 2.0f;
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onGetFOVModifier(EntityViewRenderEvent.FOVModifier event) {
        if (this.prevSynesthesiaProgress > 0.0f) {
            float prog = this.prevSynesthesiaProgress + (this.synesthesiaProgress - this.prevSynesthesiaProgress) * Minecraft.func_71410_x().func_184121_ak();
            float renderProg = this.prevSynesthesiaProgress > this.synesthesiaProgress ? (float)Math.sin((double)(prog / this.maxSynesthesiaProgress) * Math.PI) * 40.0f : -((float)Math.sin((double)(prog / this.maxSynesthesiaProgress) * Math.PI)) * 40.0f;
            event.setFOV(event.getFOV() + (double)renderProg);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRenderWorld(RenderWorldLastEvent event) {
        if (Minecraft.func_71410_x().field_71439_g.func_184586_b(Hand.MAIN_HAND).func_77973_b() == RatsItemRegistry.RADIUS_STICK && RatsMod.PROXY.getRefrencedRat() != null) {
            Vec3d renderCenter = new Vec3d((Vec3i)RatsMod.PROXY.getRefrencedRat().getSearchCenter()).func_72441_c(0.5, 0.5, 0.5);
            double renderRadius = RatsMod.PROXY.getRefrencedRat().getSearchRadius();
            AxisAlignedBB aabb = new AxisAlignedBB(-renderRadius, -renderRadius, -renderRadius, renderRadius, renderRadius, renderRadius);
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_227740_m_();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(RADIUS_TEXTURE);
            GlStateManager.func_227605_A_();
            GlStateManager.func_227667_a_((boolean)false);
            ClientPlayerEntity viewEntity = Minecraft.func_71410_x().field_71439_g;
            ActiveRenderInfo activerenderinfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
            Vec3d viewPosition = activerenderinfo.func_216785_c();
            double px = viewPosition.field_72450_a;
            double py = viewPosition.field_72448_b;
            double pz = viewPosition.field_72449_c;
            MatrixStack stack = event.getMatrixStack();
            stack.func_227860_a_();
            stack.func_227861_a_(-px, -py, -pz);
            stack.func_227861_a_(renderCenter.field_72450_a, renderCenter.field_72448_b, renderCenter.field_72449_c);
            stack.func_227860_a_();
            ClientEvents.renderMovingAABB(aabb, event.getPartialTicks(), stack);
            stack.func_227865_b_();
            stack.func_227865_b_();
            GlStateManager.func_227667_a_((boolean)true);
            GlStateManager.func_227771_z_();
            GlStateManager.func_227737_l_();
        }
    }

    public static void renderMovingAABB(AxisAlignedBB boundingBox, float partialTicks, MatrixStack stack) {
        Tessellator tessellator = Tessellator.func_178181_a();
        IVertexBuilder vertexbuffer = tessellator.func_178180_c().getVertexBuilder();
        BufferBuilder buffer = tessellator.func_178180_c();
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f3 = (float)(System.currentTimeMillis() % 3000L) / 3000.0f;
        Matrix4f matrix4f = stack.func_227866_c_().func_227870_a_();
        float maxX = (float)boundingBox.field_72336_d * 0.125f;
        float minX = (float)boundingBox.field_72340_a * 0.125f;
        float maxY = (float)boundingBox.field_72337_e * 0.125f;
        float minY = (float)boundingBox.field_72338_b * 0.125f;
        float maxZ = (float)boundingBox.field_72334_f * 0.125f;
        float minZ = (float)boundingBox.field_72339_c * 0.125f;
        buffer.func_181668_a(7, DefaultVertexFormats.field_181712_l);
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72337_e, (float)boundingBox.field_72339_c).func_225583_a_(f3 + minX - maxX, f3 + maxY - minY).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72337_e, (float)boundingBox.field_72339_c).func_225583_a_(f3 + maxX - minX, f3 + maxY - minY).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72338_b, (float)boundingBox.field_72339_c).func_225583_a_(f3 + maxX - minX, f3 + minY - maxY).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72338_b, (float)boundingBox.field_72339_c).func_225583_a_(f3 + minX - maxX, f3 + minY - maxY).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, 0.0f, -1.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72338_b, (float)boundingBox.field_72334_f).func_225583_a_(f3 + minX - maxX, f3 + minY - maxY).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72338_b, (float)boundingBox.field_72334_f).func_225583_a_(f3 + maxX - minX, f3 + minY - maxY).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72337_e, (float)boundingBox.field_72334_f).func_225583_a_(f3 + maxX - minX, f3 + maxY - minY).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72337_e, (float)boundingBox.field_72334_f).func_225583_a_(f3 + minX - maxX, f3 + maxY - minY).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, 0.0f, 1.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72338_b, (float)boundingBox.field_72339_c).func_225583_a_(f3 + minX - maxX, f3 + minY - maxY).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72338_b, (float)boundingBox.field_72339_c).func_225583_a_(f3 + maxX - minX, f3 + minY - maxY).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72338_b, (float)boundingBox.field_72334_f).func_225583_a_(f3 + maxX - minX, f3 + maxZ - minZ).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72338_b, (float)boundingBox.field_72334_f).func_225583_a_(f3 + minX - maxX, f3 + maxZ - minZ).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, -1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72337_e, (float)boundingBox.field_72334_f).func_225583_a_(f3 + minX - maxX, f3 + minY - maxY).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72337_e, (float)boundingBox.field_72334_f).func_225583_a_(f3 + maxX - minX, f3 + minY - maxY).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72337_e, (float)boundingBox.field_72339_c).func_225583_a_(f3 + maxX - minX, f3 + maxZ - minZ).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72337_e, (float)boundingBox.field_72339_c).func_225583_a_(f3 + minX - maxX, f3 + maxZ - minZ).func_225586_a_(255, 255, 255, 255).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72338_b, (float)boundingBox.field_72334_f).func_225583_a_(f3 + minX - maxX, f3 + minY - maxY).func_225586_a_(255, 255, 255, 255).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72337_e, (float)boundingBox.field_72334_f).func_225583_a_(f3 + minX - maxX, f3 + maxY - minY).func_225586_a_(255, 255, 255, 255).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72337_e, (float)boundingBox.field_72339_c).func_225583_a_(f3 + maxX - minX, f3 + maxY - minY).func_225586_a_(255, 255, 255, 255).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72340_a, (float)boundingBox.field_72338_b, (float)boundingBox.field_72339_c).func_225583_a_(f3 + maxX - minX, f3 + minY - maxY).func_225586_a_(255, 255, 255, 255).func_225584_a_(-1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72338_b, (float)boundingBox.field_72339_c).func_225583_a_(f3 + minX - maxX, f3 + minY - maxY).func_225586_a_(255, 255, 255, 255).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72337_e, (float)boundingBox.field_72339_c).func_225583_a_(f3 + minX - maxX, f3 + maxY - minY).func_225586_a_(255, 255, 255, 255).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72337_e, (float)boundingBox.field_72334_f).func_225583_a_(f3 + maxX - minX, f3 + maxY - minY).func_225586_a_(255, 255, 255, 255).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
        vertexbuffer.func_227888_a_(matrix4f, (float)boundingBox.field_72336_d, (float)boundingBox.field_72338_b, (float)boundingBox.field_72334_f).func_225583_a_(f3 + maxX - minX, f3 + minY - maxY).func_225586_a_(255, 255, 255, 255).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onLivingRender(RenderLivingEvent.Post event) {
        MatrixStack matrixStackIn = event.getMatrixStack();
        int protectorCount = CommonEvents.getProtectorCount(event.getEntity());
        IVertexBuilder textureBuilder = event.getBuffers().getBuffer(RatsRenderType.getGlowingTranslucent(RenderRatProtector.BASE_TEXTURE));
        for (int i = 0; i < protectorCount; ++i) {
            float tick = (float)(event.getEntity().field_70173_aa - 1) + event.getPartialRenderTick();
            float offsetRot = 30.0f + 360.0f * ((float)i / (float)protectorCount);
            float bob = (float)((Math.sin(tick * 0.1f) * (double)0.2f + Math.cos(tick * 0.4f + (float)i)) * 0.2);
            float scale = 0.4f;
            float rotation = MathHelper.func_76142_g((float)(tick * 8.0f % 360.0f + offsetRot));
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotation));
            matrixStackIn.func_227861_a_(0.0, (double)event.getEntity().func_213302_cg() + 0.5 + (double)bob, (double)(event.getEntity().func_213311_cf() + 0.5f));
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(75.0f));
            matrixStackIn.func_227862_a_(scale, scale, scale);
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            float f = ((float)event.getEntity().field_70173_aa + event.getPartialRenderTick()) * 0.5f;
            float f1 = 1.0f;
            RAT_MODEL.func_225597_a_(event.getEntity(), f, f1, (float)event.getEntity().field_70173_aa + event.getPartialRenderTick(), event.getPartialRenderTick(), 0.0f);
            RAT_MODEL.func_225598_a_(event.getMatrixStack(), textureBuilder, event.getLight(), OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStackIn.func_227865_b_();
            matrixStackIn.func_227865_b_();
        }
    }
}

