/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.gui;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.client.ClientProxy;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.message.MessageCheeseStaffSync;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiCheeseStaff
extends Screen {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("rats:textures/gui/cheese_staff.png");
    private EntityRat rat;

    public GuiCheeseStaff(EntityRat rat) {
        super((ITextComponent)new TranslationTextComponent("cheese_staff", new Object[0]));
        this.rat = rat;
        this.init();
    }

    public void init() {
        super.init();
        this.buttons.clear();
        int i = this.width / 2;
        int j = (this.height - 166) / 2;
        String topText = I18n.func_135052_a((String)"entity.rats.rat.staff.mark_block_deposit", (Object[])new Object[]{this.getPosName()}) + " " + I18n.func_135052_a((String)("rats.direction." + ClientProxy.refrencedFacing.func_176610_l()), (Object[])new Object[0]);
        int maxLength = Math.max(150, Minecraft.func_71410_x().field_71466_p.func_78256_a(topText) + 20);
        this.addButton((Widget)new Button(i - maxLength / 2, j + 60, maxLength, 20, topText, p_214132_1_ -> {
            BlockPos pos = ClientProxy.refrencedPos;
            RatsMod.NETWORK_WRAPPER.sendToServer((Object)new MessageCheeseStaffSync(this.rat.func_145782_y(), pos, ClientProxy.refrencedFacing, 0));
            Minecraft.func_71410_x().func_147108_a(null);
            this.init();
        }));
        this.addButton((Widget)new Button(i - maxLength / 2, j + 85, maxLength, 20, I18n.func_135052_a((String)"entity.rats.rat.staff.mark_block_pickup", (Object[])new Object[]{this.getPosName()}), p_214132_1_ -> {
            BlockPos pos = ClientProxy.refrencedPos;
            RatsMod.NETWORK_WRAPPER.sendToServer((Object)new MessageCheeseStaffSync(this.rat.func_145782_y(), pos, Direction.UP, 1));
            Minecraft.func_71410_x().func_147108_a(null);
            this.init();
        }));
        this.addButton((Widget)new Button(i - maxLength / 2, j + 110, maxLength, 20, I18n.func_135052_a((String)"entity.rats.rat.staff.set_home_point", (Object[])new Object[]{this.getPosName()}), p_214132_1_ -> {
            BlockPos pos = ClientProxy.refrencedPos;
            this.rat.func_213390_a(pos, 32);
            RatsMod.NETWORK_WRAPPER.sendToServer((Object)new MessageCheeseStaffSync(this.rat.func_145782_y(), pos, Direction.UP, 2));
            this.init();
        }));
        this.addButton((Widget)new Button(i - maxLength / 2, j + 135, maxLength, 20, I18n.func_135052_a((String)"entity.rats.rat.staff.un_set_home_point", (Object[])new Object[0]), p_214132_1_ -> {
            BlockPos pos = ClientProxy.refrencedPos;
            this.rat.func_213394_dL();
            RatsMod.NETWORK_WRAPPER.sendToServer((Object)new MessageCheeseStaffSync(this.rat.func_145782_y(), pos, Direction.UP, 3));
            this.init();
        }));
        ((Widget)this.buttons.get((int)0)).active = !this.isNoInventoryAtPos();
        ((Widget)this.buttons.get((int)1)).active = !this.isNoInventoryAtPos();
        ((Widget)this.buttons.get((int)2)).active = !ClientProxy.refrencedPos.equals((Object)this.rat.func_213384_dI()) || !this.rat.func_213394_dL();
        ((Widget)this.buttons.get((int)3)).active = this.rat.func_213394_dL();
    }

    private String getPosName() {
        if (ClientProxy.refrencedPos != null) {
            BlockState state = this.rat.field_70170_p.func_180495_p(ClientProxy.refrencedPos);
            List namelist = null;
            ItemStack pick = state.func_177230_c().func_185473_a((IBlockReader)Minecraft.func_71410_x().field_71441_e, ClientProxy.refrencedPos, state);
            try {
                namelist = pick.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (namelist != null && !namelist.isEmpty()) {
                return ((ITextComponent)namelist.get(0)).func_150254_d();
            }
        }
        return "";
    }

    private boolean isNoInventoryAtPos() {
        BlockPos pos = ClientProxy.refrencedPos;
        if (pos != null) {
            World worldIn = this.rat.field_70170_p;
            return worldIn.func_175625_s(pos) == null;
        }
        return true;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.getMinecraft() != null) {
            try {
                this.renderBackground();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.render(mouseX, mouseY, partialTicks);
        int i = (this.width - 248) / 2 + 10;
        int j = (this.height - 166) / 2 + 8;
        GlStateManager.func_227626_N_();
        GlStateManager.func_227688_c_((float)0.0f, (float)0.0f, (float)10.0f);
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.rat != null) {
            GuiCheeseStaff.drawEntityOnScreen(i + 114, j + 40, 70, 0.0f, 0.0f, (LivingEntity)this.rat);
        }
        GlStateManager.func_227627_O_();
    }

    public static void drawEntityOnScreen(int x, int y, int scale, float yaw, float pitch, LivingEntity entity) {
        float f = (float)Math.atan(yaw / 40.0f);
        float f1 = (float)Math.atan(pitch / 40.0f);
        float rotate = (Minecraft.func_71410_x().func_184121_ak() + (float)Minecraft.func_71410_x().field_71439_g.field_70173_aa) * 2.0f;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixstack.func_227862_a_((float)scale, (float)scale, (float)scale);
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion quaternion1 = Vector3f.field_229179_b_.func_229187_a_(f1 * 20.0f);
        Quaternion quaternion2 = Vector3f.field_229181_d_.func_229187_a_(rotate);
        quaternion.func_195890_a(quaternion1);
        matrixstack.func_227863_a_(quaternion);
        matrixstack.func_227863_a_(quaternion2);
        float f2 = entity.field_70761_aq;
        float f3 = entity.field_70177_z;
        float f4 = entity.field_70125_A;
        float f5 = entity.field_70758_at;
        float f6 = entity.field_70759_as;
        entity.field_70761_aq = 180.0f + f * 20.0f;
        entity.field_70177_z = 180.0f + f * 40.0f;
        entity.field_70125_A = -f1 * 20.0f;
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70758_at = entity.field_70177_z;
        EntityRendererManager entityrenderermanager = Minecraft.func_71410_x().func_175598_ae();
        quaternion1.func_195892_e();
        entityrenderermanager.func_229089_a_(quaternion1);
        entityrenderermanager.func_178633_a(false);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        entityrenderermanager.func_229084_a_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0);
        irendertypebuffer$impl.func_228461_a_();
        entityrenderermanager.func_178633_a(true);
        entity.field_70761_aq = f2;
        entity.field_70177_z = f3;
        entity.field_70125_A = f4;
        entity.field_70758_at = f5;
        entity.field_70759_as = f6;
        RenderSystem.popMatrix();
    }

    public boolean isPauseScreen() {
        return false;
    }
}

