/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.gui;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.client.ClientProxy;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.message.MessageCheeseStaffSync;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.widget.Slider;

@OnlyIn(value=Dist.CLIENT)
public class GuiRadiusStaff
extends Screen {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("rats:textures/gui/cheese_staff.png");
    private final Slider.ISlider sliderResponder;
    private final EntityRat rat;
    private int sliderValue;
    private int prevSliderValue;

    public GuiRadiusStaff(EntityRat rat) {
        super((ITextComponent)new TranslationTextComponent("radius_staff", new Object[0]));
        this.prevSliderValue = this.sliderValue;
        this.rat = rat;
        this.prevSliderValue = this.sliderValue = rat.getSearchRadius();
        this.init();
        this.sliderResponder = new Slider.ISlider(){

            public void onChangeSliderValue(Slider slider) {
                GuiRadiusStaff.this.setSliderValue(0, (float)slider.sliderValue);
            }
        };
    }

    public static void drawEntityOnScreen(int x, int y, int scale, float yaw, float pitch, LivingEntity entity) {
        float f = (float)Math.atan(yaw / 40.0f);
        float f1 = (float)Math.atan(pitch / 40.0f);
        float rotate = (Minecraft.func_71410_x().func_184121_ak() + (float)Minecraft.func_71410_x().field_71439_g.field_70173_aa) * 2.0f;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixstack.func_227862_a_((float)scale, (float)scale, (float)scale);
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion quaternion1 = Vector3f.field_229179_b_.func_229187_a_(f1 * 20.0f);
        Quaternion quaternion2 = Vector3f.field_229181_d_.func_229187_a_(rotate);
        quaternion.func_195890_a(quaternion1);
        matrixstack.func_227863_a_(quaternion);
        matrixstack.func_227863_a_(quaternion2);
        float f2 = entity.field_70761_aq;
        float f3 = entity.field_70177_z;
        float f4 = entity.field_70125_A;
        float f5 = entity.field_70758_at;
        float f6 = entity.field_70759_as;
        entity.field_70761_aq = 180.0f + f * 20.0f;
        entity.field_70177_z = 180.0f + f * 40.0f;
        entity.field_70125_A = -f1 * 20.0f;
        EntityRendererManager entityrenderermanager = Minecraft.func_71410_x().func_175598_ae();
        quaternion1.func_195892_e();
        entityrenderermanager.func_229089_a_(quaternion1);
        entityrenderermanager.func_178633_a(false);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        entityrenderermanager.func_229084_a_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0);
        irendertypebuffer$impl.func_228461_a_();
        entityrenderermanager.func_178633_a(true);
        entity.field_70761_aq = f2;
        entity.field_70177_z = f3;
        entity.field_70125_A = f4;
        entity.field_70758_at = f5;
        entity.field_70759_as = f6;
        RenderSystem.popMatrix();
    }

    private void setSliderValue(int id, float value) {
        this.sliderValue = Math.round(value *= (float)RatConfig.maxRatRadius);
        if (this.prevSliderValue != this.sliderValue) {
            RatsMod.NETWORK_WRAPPER.sendToServer((Object)new MessageCheeseStaffSync(this.rat.func_145782_y(), BlockPos.field_177992_a, Direction.UP, 5, this.sliderValue));
            this.rat.setSearchRadius(Math.round(this.sliderValue));
        }
        this.prevSliderValue = this.sliderValue;
    }

    public void init() {
        super.init();
        this.buttons.clear();
        int i = this.width / 2;
        int j = (this.height - 166) / 2;
        String topText = I18n.func_135052_a((String)"entity.rat.staff.set_radius_loc", (Object[])new Object[]{this.getPosName()});
        String secondText = I18n.func_135052_a((String)"entity.rat.staff.reset_radius", (Object[])new Object[0]);
        int maxLength = Math.max(150, Minecraft.func_71410_x().field_71466_p.func_78256_a(topText) + 20);
        this.addButton((Widget)new Button(i - maxLength / 2, j + 60, maxLength, 20, topText, p_214132_1_ -> {
            BlockPos pos = ClientProxy.refrencedPos;
            RatsMod.NETWORK_WRAPPER.sendToServer((Object)new MessageCheeseStaffSync(this.rat.func_145782_y(), pos, Direction.UP, 4, 0));
            this.rat.setSearchRadiusCenter(pos);
        }));
        this.addButton((Widget)new Slider(i - 75, j + 85, 150, 20, I18n.func_135052_a((String)"entity.rat.staff.radius", (Object[])new Object[0]) + ": ", "", 1.0, RatConfig.maxRatRadius, this.sliderValue, false, true, p_214132_1_ -> {}, this.sliderResponder){});
        this.addButton((Widget)new Button(i - maxLength / 2, j + 110, maxLength, 20, secondText, p_214132_1_ -> {
            RatsMod.NETWORK_WRAPPER.sendToServer((Object)new MessageCheeseStaffSync(this.rat.func_145782_y(), BlockPos.field_177992_a, Direction.UP, 6, 0));
            this.rat.setSearchRadiusCenter(null);
            this.rat.setSearchRadius(RatConfig.defaultRatRadius);
        }));
    }

    private String getPosName() {
        return "(" + ClientProxy.refrencedPos.func_177958_n() + ", " + ClientProxy.refrencedPos.func_177956_o() + ", " + ClientProxy.refrencedPos.func_177952_p() + ")";
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (this.getMinecraft() != null) {
            try {
                this.renderBackground();
                super.render(mouseX, mouseY, partialTicks);
                int i = (this.width - 248) / 2 + 10;
                int j = (this.height - 166) / 2 + 8;
                GlStateManager.func_227626_N_();
                GlStateManager.func_227688_c_((float)0.0f, (float)0.0f, (float)10.0f);
                GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (this.rat != null) {
                    GuiRadiusStaff.drawEntityOnScreen(i + 114, j + 40, 70, 0.0f, 0.0f, (LivingEntity)this.rat);
                }
                GlStateManager.func_227627_O_();
            }
            catch (Exception e) {
                Minecraft.func_71410_x().func_147108_a(null);
            }
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

