/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.blocks;

import com.github.alexthe666.rats.server.entity.EntityRatBaron;
import com.github.alexthe666.rats.server.entity.RatsEntityRegistry;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockAirRaidSiren
extends Block {
    private static final VoxelShape AABB = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public BlockAirRaidSiren() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200948_a(5.0f, 1000.0f).func_208770_d());
        this.setRegistryName("rats", "air_raid_siren");
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return AABB;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        this.playSound(player, worldIn, pos);
        if (!worldIn.field_72995_K) {
            ((ServerWorld)worldIn).func_217468_a(new LightningBoltEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, true));
            worldIn.func_175656_a(pos, Blocks.field_180407_aO.func_176223_P());
            EntityRatBaron baron = new EntityRatBaron(RatsEntityRegistry.RAT_BARON, worldIn);
            baron.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 5.0, (double)pos.func_177952_p() + 0.5);
            baron.func_213386_a((IWorld)worldIn, worldIn.func_175649_E(pos), SpawnReason.MOB_SUMMONED, null, null);
            worldIn.func_217376_c((Entity)baron);
        }
        for (int i = 0; i < 2; ++i) {
            Random rand = worldIn.field_73012_v;
            worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n() + 0.5 + ((double)rand.nextFloat() - 0.5) * 3.0, (double)(pos.func_177956_o() - 1), (double)pos.func_177952_p() + 0.5 + ((double)rand.nextFloat() - 0.5) * 3.0, new ItemStack((IItemProvider)Items.field_151042_j)));
        }
        return ActionResultType.SUCCESS;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!worldIn.field_72995_K && (flag = worldIn.func_175640_z(pos))) {
            worldIn.func_184133_a(null, pos, RatsSoundRegistry.AIR_RAID_SIREN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!worldIn.field_72995_K) {
                ((ServerWorld)worldIn).func_217468_a(new LightningBoltEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, true));
                worldIn.func_175656_a(pos, Blocks.field_180407_aO.func_176223_P());
                EntityRatBaron baron = new EntityRatBaron(RatsEntityRegistry.RAT_BARON, worldIn);
                baron.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 5.0, (double)pos.func_177952_p() + 0.5);
                baron.func_213386_a((IWorld)worldIn, worldIn.func_175649_E(pos), SpawnReason.MOB_SUMMONED, null, null);
                worldIn.func_217376_c((Entity)baron);
            }
            for (int i = 0; i < 2; ++i) {
                Random rand = worldIn.field_73012_v;
                worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)pos.func_177958_n() + 0.5 + ((double)rand.nextFloat() - 0.5) * 3.0, (double)(pos.func_177956_o() - 1), (double)pos.func_177952_p() + 0.5 + ((double)rand.nextFloat() - 0.5) * 3.0, new ItemStack((IItemProvider)Items.field_151042_j)));
            }
        }
    }

    protected void playSound(@Nullable PlayerEntity player, World worldIn, BlockPos pos) {
        worldIn.func_184133_a(player, pos, RatsSoundRegistry.AIR_RAID_SIREN, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    public boolean isOpaqueCube(BlockState state) {
        return false;
    }

    public boolean isFullCube(BlockState state) {
        return false;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }
}

