/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.blocks;

import com.github.alexthe666.rats.server.blocks.IUsesTEISR;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatTrap;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockRatTrap
extends ContainerBlock
implements IUsesTEISR {
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    private static final VoxelShape NS_AABB = Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)4.0, (double)16.0);
    private static final VoxelShape EW_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)4.0, (double)13.0);

    protected BlockRatTrap() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200948_a(1.0f, 0.0f));
        this.setRegistryName("rats", "rat_trap");
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityRatTrap) {
            if (!worldIn.field_72995_K && !((TileEntityRatTrap)tileentity).getBait().func_190926_b()) {
                worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), ((TileEntityRatTrap)tileentity).getBait()));
            }
            worldIn.func_175666_e(pos, (Block)this);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return ((Direction)state.func_177229_b((IProperty)FACING)).func_176740_k() == Direction.Axis.Z ? NS_AABB : EW_AABB;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return this.isValidGround(worldIn.func_180495_p(blockpos), (IBlockReader)worldIn, blockpos);
    }

    protected boolean isValidGround(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_200015_d(worldIn, pos);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    public boolean isOpaqueCube(BlockState state) {
        return false;
    }

    public boolean isFullCube(BlockState state) {
        return false;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        ItemStack itemstack = playerIn.func_184586_b(hand);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityRatTrap) {
            TileEntityRatTrap ratTrap = (TileEntityRatTrap)tile;
            if (ratTrap.isShut) {
                ratTrap.isShut = false;
                worldIn.func_184133_a(null, pos, SoundEvents.field_187617_cK, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return ActionResultType.SUCCESS;
            }
            if (ratTrap.getBait().func_190926_b() && RatUtils.isRatFood(itemstack)) {
                ratTrap.setBaitStack(itemstack.func_77946_l());
                if (!playerIn.func_184812_l_()) {
                    itemstack.func_190920_e(0);
                }
                return ActionResultType.SUCCESS;
            }
            if (!ratTrap.getBait().func_190926_b()) {
                if (!RatUtils.isRatFood(itemstack)) {
                    // empty if block
                }
                if (!worldIn.field_72995_K) {
                    worldIn.func_217376_c((Entity)new ItemEntity(worldIn, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), ratTrap.getBait()));
                }
                ratTrap.setBaitStack(ItemStack.field_190927_a);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.FAIL;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        TileEntity tile = blockAccess.func_175625_s(pos);
        if (tile instanceof TileEntityRatTrap) {
            TileEntityRatTrap ratTrap = (TileEntityRatTrap)tile;
            return ratTrap.calculateRedstone();
        }
        return 0;
    }

    @Deprecated
    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return this.func_180656_a(blockState, blockAccess, pos, side);
    }

    @Deprecated
    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityRatTrap) {
            TileEntityRatTrap ratTrap = (TileEntityRatTrap)tile;
            return ratTrap.calculateRedstone();
        }
        return 0;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        TileEntity tile;
        if (worldIn.func_175640_z(pos) && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityRatTrap) {
            TileEntityRatTrap ratTrap = (TileEntityRatTrap)tile;
            ratTrap.onRedstonePulse();
        }
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityRatTrap();
    }
}

