/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.blocks;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.server.blocks.IUsesTEISR;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatlantisPortal;
import com.github.alexthe666.rats.server.world.RatsWorldRegistry;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockRatlantisPortal
extends ContainerBlock
implements IUsesTEISR {
    protected BlockRatlantisPortal() {
        super(Block.Properties.func_200945_a((Material)Material.field_151567_E).func_200947_a(SoundType.field_185849_b).func_200943_b(-1.0f).func_200951_a(15).func_200942_a());
        this.setRegistryName("rats", "ratlantis_portal");
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entity) {
        if (!RatConfig.disableRatlantis && !worldIn.field_72995_K) {
            MinecraftServer server = worldIn.func_73046_m();
            if (!entity.func_184207_aI() && entity.func_184188_bt().isEmpty()) {
                if (entity instanceof ServerPlayerEntity) {
                    ServerPlayerEntity thePlayer = (ServerPlayerEntity)entity;
                    if (thePlayer.field_71088_bW > 0) {
                        thePlayer.field_71088_bW = 10;
                    } else if (thePlayer.field_71093_bK != RatsWorldRegistry.RATLANTIS_DIMENSION_TYPE) {
                        thePlayer.field_71088_bW = 10;
                        ServerWorld dimWorld = server.func_71218_a(RatsWorldRegistry.RATLANTIS_DIMENSION_TYPE);
                        if (dimWorld != null) {
                            this.teleportEntity((Entity)thePlayer, dimWorld, pos);
                        }
                    } else {
                        thePlayer.field_71088_bW = 10;
                        ServerWorld dimWorld = server.func_71218_a(DimensionType.func_186069_a((int)RatConfig.ratlantisPortalExitDimension));
                        if (dimWorld != null) {
                            this.teleportEntity((Entity)thePlayer, dimWorld, pos);
                        }
                    }
                }
                if (!(entity instanceof PlayerEntity)) {
                    ServerWorld dimWorld;
                    if (entity.field_71093_bK.func_186068_a() != RatConfig.ratlantisDimensionId) {
                        entity.field_71088_bW = 10;
                        dimWorld = server.func_71218_a(RatsWorldRegistry.RATLANTIS_DIMENSION_TYPE);
                        if (dimWorld != null) {
                            this.teleportEntity(entity, dimWorld, pos);
                        }
                    } else {
                        dimWorld = server.func_71218_a(DimensionType.func_186069_a((int)RatConfig.ratlantisPortalExitDimension));
                        entity.field_71088_bW = 10;
                        if (dimWorld != null) {
                            this.teleportEntity(entity, dimWorld, pos);
                        }
                    }
                }
            }
        }
    }

    private Entity teleportEntity(Entity entity, ServerWorld endpointWorld, BlockPos endpoint) {
        if (endpointWorld.field_73011_w.func_186058_p() == RatsWorldRegistry.RATLANTIS_DIMENSION_TYPE) {
            endpoint = new BlockPos(0, 112, 0);
            this.placeInPortal(entity, endpointWorld);
        } else if (entity instanceof PlayerEntity && ((PlayerEntity)entity).getBedLocation(DimensionType.field_223227_a_) != null) {
            BlockPos bedPos;
            endpoint = bedPos = ((PlayerEntity)entity).getBedLocation(DimensionType.field_223227_a_);
            entity.func_70012_b((double)bedPos.func_177958_n() + 0.5, (double)bedPos.func_177956_o() + 1.5, (double)bedPos.func_177952_p() + 0.5, 0.0f, 0.0f);
        } else {
            BlockPos height;
            endpoint = height = entity.field_70170_p.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, entity.func_180425_c());
            entity.func_70012_b((double)height.func_177958_n() + 0.5, (double)height.func_177956_o() + 0.5, (double)height.func_177952_p() + 0.5, entity.field_70177_z, 0.0f);
        }
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            player.func_200619_a(endpointWorld, (double)endpoint.func_177958_n() + 0.5, (double)endpoint.func_177956_o() + 0.5, (double)endpoint.func_177952_p() + 0.5, entity.field_70177_z, entity.field_70125_A);
            return player;
        }
        entity.func_213319_R();
        entity.field_71093_bK = endpointWorld.field_73011_w.func_186058_p();
        Entity teleportedEntity = entity.func_200600_R().func_200721_a((World)endpointWorld);
        if (teleportedEntity == null) {
            return entity;
        }
        teleportedEntity.func_180432_n(entity);
        teleportedEntity.func_70012_b((double)endpoint.func_177958_n() + 0.5, (double)endpoint.func_177956_o() + 0.5, (double)endpoint.func_177952_p() + 0.5, entity.field_70177_z, entity.field_70125_A);
        teleportedEntity.func_70034_d(entity.field_70177_z);
        endpointWorld.func_217460_e(teleportedEntity);
        return teleportedEntity;
    }

    public void placeInPortal(Entity entity, ServerWorld serverWorld) {
        entity.func_70080_a(0.0, 110.0, 0.0, 0.0f, 0.0f);
        entity.func_213293_j(0.0, 0.0, 0.0);
        BlockPos portalBottom = new BlockPos(1, 111, 1);
        for (BlockPos pos : BlockPos.func_218281_b((BlockPos)portalBottom.func_177982_a(-2, 0, -2), (BlockPos)portalBottom.func_177982_a(2, 0, 2)).map(BlockPos::func_185334_h).collect(Collectors.toList())) {
            serverWorld.func_175656_a(pos, RatsBlockRegistry.MARBLED_CHEESE_TILE.func_176223_P());
            serverWorld.func_175656_a(pos.func_177981_b(4), RatsBlockRegistry.MARBLED_CHEESE_TILE.func_176223_P());
        }
        for (int i = 1; i < 4; ++i) {
            serverWorld.func_175656_a(portalBottom.func_177982_a(2, 0, 2).func_177981_b(i), (BlockState)RatsBlockRegistry.MARBLED_CHEESE_PILLAR.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y));
            serverWorld.func_175656_a(portalBottom.func_177982_a(2, 0, -2).func_177981_b(i), (BlockState)RatsBlockRegistry.MARBLED_CHEESE_PILLAR.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y));
            serverWorld.func_175656_a(portalBottom.func_177982_a(-2, 0, 2).func_177981_b(i), (BlockState)RatsBlockRegistry.MARBLED_CHEESE_PILLAR.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y));
            serverWorld.func_175656_a(portalBottom.func_177982_a(-2, 0, -2).func_177981_b(i), (BlockState)RatsBlockRegistry.MARBLED_CHEESE_PILLAR.func_176223_P().func_206870_a((IProperty)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Y));
        }
        serverWorld.func_175656_a(portalBottom, RatsBlockRegistry.MARBLED_CHEESE_RAW.func_176223_P());
        serverWorld.func_175656_a(portalBottom.func_177984_a(), RatsBlockRegistry.RATLANTIS_PORTAL.func_176223_P());
        serverWorld.func_175656_a(portalBottom.func_177981_b(2), RatsBlockRegistry.RATLANTIS_PORTAL.func_176223_P());
        serverWorld.func_175656_a(portalBottom.func_177981_b(3), RatsBlockRegistry.MARBLED_CHEESE_RAW.func_176223_P());
    }

    public void updateTick(World worldIn, BlockPos pos, BlockState state, Random rand) {
        if (!this.canSurviveAt(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.canSurviveAt(worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public boolean canSurviveAt(World world, BlockPos pos) {
        return !(world.func_180495_p(pos.func_177984_a()).func_177230_c() != RatsBlockRegistry.RATLANTIS_PORTAL && world.func_180495_p(pos.func_177984_a()).func_177230_c() != RatsBlockRegistry.MARBLED_CHEESE_RAW || world.func_180495_p(pos.func_177977_b()).func_177230_c() != RatsBlockRegistry.RATLANTIS_PORTAL && world.func_180495_p(pos.func_177977_b()).func_177230_c() != RatsBlockRegistry.MARBLED_CHEESE_RAW);
    }

    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        Block block = adjacentBlockState.func_177230_c();
        return block != RatsBlockRegistry.RATLANTIS_PORTAL;
    }

    public boolean isOpaqueCube(BlockState state) {
        return false;
    }

    public boolean isFullCube(BlockState state) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityRatlantisPortal) {
            int i = 4;
            for (int j = 0; j < i; ++j) {
                double d0 = (float)pos.func_177958_n() + rand.nextFloat();
                double d1 = (float)pos.func_177956_o() + rand.nextFloat();
                double d2 = (float)pos.func_177952_p() + rand.nextFloat();
                double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
                double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
                double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
                int k = rand.nextInt(2) * 2 - 1;
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197624_q, d0, d1, d2, d3, d4, d5);
            }
        }
    }

    public ItemStack getItem(World worldIn, BlockPos pos, BlockState state) {
        return ItemStack.field_190927_a;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityRatlantisPortal();
    }
}

