/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.server.entity.RatsEntityRegistry;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityGolemBeam
extends AbstractArrowEntity {
    private IntOpenHashSet piercedEntities;
    private List<Entity> hitEntities;
    private int knockbackStrength;

    public EntityGolemBeam(EntityType type, World worldIn) {
        super(type, worldIn);
        this.func_70239_b(8.0);
    }

    public EntityGolemBeam(EntityType type, World worldIn, double x, double y, double z) {
        this(type, worldIn);
        this.func_70107_b(x, y, z);
        this.func_70239_b(8.0);
    }

    public EntityGolemBeam(EntityType type, World worldIn, LivingEntity shooter) {
        super(type, shooter, worldIn);
        this.func_70239_b(RatConfig.ratlanteanAutomatonAttack * 0.5f + 0.5f);
    }

    public EntityGolemBeam(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(RatsEntityRegistry.RATLANTEAN_AUTOMATON_BEAM, world);
    }

    public boolean func_70090_H() {
        return false;
    }

    public void func_70071_h_() {
        float sqrt = (float)this.func_213322_ci().func_72433_c();
        if (sqrt < 0.2f || this.field_70254_i || this.field_70123_F) {
            this.func_70106_y();
            Explosion.Mode mode = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b) ? Explosion.Mode.NONE : Explosion.Mode.DESTROY;
            Explosion explosion = this.field_70170_p.func_217385_a(this.func_212360_k(), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, mode);
            explosion.func_77278_a();
            explosion.func_77279_a(true);
        }
        super.func_70071_h_();
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        if (!this.func_174814_R() && soundIn != SoundEvents.field_187731_t && soundIn != SoundEvents.field_187734_u) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), soundIn, this.func_184176_by(), volume, pitch);
        }
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        if (raytraceResultIn instanceof EntityRayTraceResult && this.func_212360_k() != null && this.func_212360_k().func_184191_r(((EntityRayTraceResult)raytraceResultIn).func_216348_a())) {
            return;
        }
        if (raytraceResultIn instanceof EntityRayTraceResult && ((EntityRayTraceResult)raytraceResultIn).func_216348_a() instanceof PlayerEntity) {
            this.damageShield((PlayerEntity)((EntityRayTraceResult)raytraceResultIn).func_216348_a(), (float)this.func_70242_d());
        }
        super.func_184549_a(raytraceResultIn);
    }

    protected void damageShield(PlayerEntity player, float damage) {
        if (damage >= 3.0f && player.func_184607_cu().func_77973_b().isShield(player.func_184607_cu(), (LivingEntity)player)) {
            ItemStack copyBeforeUse = player.func_184607_cu().func_77946_l();
            int i = 1 + MathHelper.func_76141_d((float)damage);
            player.func_184607_cu().func_222118_a(i, (LivingEntity)player, p_220048_0_ -> p_220048_0_.func_213361_c(EquipmentSlotType.MAINHAND));
            if (player.func_184607_cu().func_190926_b()) {
                Hand Hand2 = player.func_184600_cs();
                ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)copyBeforeUse, (Hand)Hand2);
                if (Hand2 == Hand.MAIN_HAND) {
                    this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                } else {
                    this.func_184201_a(EquipmentSlotType.OFFHAND, ItemStack.field_190927_a);
                }
                player.func_184602_cy();
                this.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBrightnessForRender() {
        return 0xF000F0;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public boolean func_189652_ae() {
        return true;
    }

    protected ItemStack func_184550_j() {
        return ItemStack.field_190927_a;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70240_a(int knockbackStrengthIn) {
        this.knockbackStrength = knockbackStrengthIn;
    }

    protected void func_213868_a(EntityRayTraceResult p_213868_1_) {
        DamageSource damagesource;
        Entity entity1;
        Entity entity = p_213868_1_.func_216348_a();
        float f = (float)this.func_213322_ci().func_72433_c();
        int i = MathHelper.func_76143_f((double)Math.max((double)f * this.func_70242_d(), 0.0));
        if (this.func_213874_s() > 0) {
            if (this.piercedEntities == null) {
                this.piercedEntities = new IntOpenHashSet(5);
            }
            if (this.hitEntities == null) {
                this.hitEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercedEntities.size() >= this.func_213874_s() + 1) {
                this.func_70106_y();
                return;
            }
            this.piercedEntities.add(entity.func_145782_y());
        }
        if (this.func_70241_g()) {
            i += this.field_70146_Z.nextInt(i / 2 + 2);
        }
        if ((entity1 = this.func_212360_k()) == null) {
            damagesource = DamageSource.func_76353_a((AbstractArrowEntity)this, (Entity)this);
        } else {
            damagesource = DamageSource.func_76353_a((AbstractArrowEntity)this, (Entity)entity1);
            if (entity1 instanceof LivingEntity) {
                ((LivingEntity)entity1).func_130011_c(entity);
            }
        }
        boolean flag = entity.func_200600_R() == EntityType.field_200803_q;
        int j = entity.func_223314_ad();
        if (this.func_70027_ad() && !flag) {
            entity.func_70015_d(5);
        }
        if (entity.func_70097_a(damagesource, (float)i)) {
            if (flag) {
                return;
            }
            if (entity instanceof LivingEntity) {
                Vec3d vec3d;
                LivingEntity livingentity = (LivingEntity)entity;
                if (this.field_70170_p.field_72995_K || this.func_213874_s() <= 0) {
                    // empty if block
                }
                if (this.knockbackStrength > 0 && (vec3d = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)this.knockbackStrength * 0.6)).func_189985_c() > 0.0) {
                    livingentity.func_70024_g(vec3d.field_72450_a, 0.1, vec3d.field_72449_c);
                }
                if (!this.field_70170_p.field_72995_K && entity1 instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a((LivingEntity)livingentity, (Entity)entity1);
                    EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)entity1), (Entity)livingentity);
                }
                this.func_184548_a(livingentity);
                if (entity1 != null && livingentity != entity1 && livingentity instanceof PlayerEntity && entity1 instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)entity1).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(6, 0.0f));
                }
                if (!entity.func_70089_S() && this.hitEntities != null) {
                    this.hitEntities.add((Entity)livingentity);
                }
                if (!this.field_70170_p.field_72995_K && entity1 instanceof ServerPlayerEntity) {
                    ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)entity1;
                    if (this.hitEntities != null && this.func_213873_r()) {
                        CriteriaTriggers.field_215100_G.func_215105_a(serverplayerentity, this.hitEntities, this.hitEntities.size());
                    } else if (!entity.func_70089_S() && this.func_213873_r()) {
                        CriteriaTriggers.field_215100_G.func_215105_a(serverplayerentity, Arrays.asList(entity), 0);
                    }
                }
            }
            this.func_184185_a(this.func_203050_i(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            if (this.func_213874_s() <= 0) {
                this.func_70106_y();
            }
        } else {
            entity.func_223308_g(j);
            this.func_213317_d(this.func_213322_ci().func_186678_a(-0.1));
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
            if (!this.field_70170_p.field_72995_K && this.func_213322_ci().func_189985_c() < 1.0E-7) {
                if (this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            }
        }
    }
}

