/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.rats.server.entity.EntityLaserBeam;
import com.github.alexthe666.rats.server.entity.IRatlantean;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.entity.RatsEntityRegistry;
import com.github.alexthe666.rats.server.entity.ai.RatbotAIStrife;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class EntityRatlanteanRatbot
extends MonsterEntity
implements IAnimatedEntity,
IRatlantean {
    public static final Animation ANIMATION_SHOOT = Animation.create((int)15);
    private static final Predicate<LivingEntity> NOT_RATLANTEAN = new Predicate<LivingEntity>(){

        public boolean apply(@Nullable LivingEntity entity) {
            return entity.func_70089_S() && !(entity instanceof IRatlantean);
        }
    };
    private int animationTick;
    private Animation currentAnimation;
    public int walkTick;
    public int prevWalkTick;
    private int rangedAttackCooldownLaser = 0;

    public EntityRatlanteanRatbot(EntityType type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RatbotAIStrife(this, 1.0, 20, 15.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{EntityRatlanteanRatbot.class}));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, LivingEntity.class, 0, false, false, NOT_RATLANTEAN));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(7.0);
        this.func_110148_a(SWIM_SPEED).func_111128_a(1.0);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SHOOT);
        }
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.prevWalkTick = this.walkTick;
        if (this.rangedAttackCooldownLaser == 0 && this.func_70638_az() != null && this.func_70685_l((Entity)this.func_70638_az())) {
            this.rangedAttackCooldownLaser = 40;
            float radius = 1.1f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + this.func_226277_ct_();
            double extraZ = (double)(radius * MathHelper.func_76134_b((float)angle)) + this.func_226281_cx_();
            double extraY = 0.4 + this.func_226278_cu_();
            double targetRelativeX = this.func_70638_az().func_226277_ct_() - extraX;
            double targetRelativeY = this.func_70638_az().func_226278_cu_() + (double)(this.func_70638_az().func_213302_cg() / 2.0f) - extraY;
            double targetRelativeZ = this.func_70638_az().func_226281_cx_() - extraZ;
            this.func_184185_a(RatsSoundRegistry.LASER, 1.0f, 0.75f + this.field_70146_Z.nextFloat() * 0.5f);
            EntityLaserBeam beam = new EntityLaserBeam(RatsEntityRegistry.LASER_BEAM, this.field_70170_p, (LivingEntity)this);
            beam.setRGB(1.0f, 0.0f, 0.0f);
            beam.func_70239_b(2.0);
            beam.func_70107_b(extraX, extraY, extraZ);
            beam.func_70186_c(targetRelativeX, targetRelativeY, targetRelativeZ, 2.0f, 0.4f);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_217376_c((Entity)beam);
            }
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.field_70721_aZ > 0.1f) {
            ++this.walkTick;
        }
        if (this.rangedAttackCooldownLaser > 0) {
            --this.rangedAttackCooldownLaser;
        }
    }

    public boolean doExtraEffect(LivingEntity target) {
        return false;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        return spawnDataIn;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_SHOOT};
    }

    protected SoundEvent func_184639_G() {
        return RatsSoundRegistry.RATLANTEAN_RATBOT_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187602_cF;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    public static boolean canSpawn(EntityType<? extends MobEntity> entityType, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        return rand.nextInt(8) == 0 && EntityRatlanteanRatbot.canSpawnAtPos(world, pos) && MobEntity.func_223315_a(entityType, (IWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)rand);
    }

    private static boolean canSpawnAtPos(IWorld world, BlockPos pos) {
        BlockState down = world.func_180495_p(pos.func_177977_b());
        return !BlockTags.func_199896_a().func_199915_b(RatUtils.PIRAT_ONLY_BLOCKS).func_199685_a_((Object)down.func_177230_c());
    }
}

