/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class RatAIDepositEnergy
extends Goal {
    private static final int RADIUS = 16;
    private final EntityRat entity;
    private BlockPos targetBlock = null;
    private int feedingTicks;
    private int breakingTime;
    private int previousBreakProgress;

    public RatAIDepositEnergy(EntityRat entity) {
        this.entity = entity;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (!this.entity.canMove() || this.entity.getRFTransferRate() == 0 || !this.entity.func_70909_n() || this.entity.getCommand() != RatCommand.TRANSPORT && this.entity.getCommand() != RatCommand.GATHER && this.entity.getCommand() != RatCommand.HUNT_ANIMALS && this.entity.getCommand() != RatCommand.HARVEST || this.entity.func_70638_az() != null) {
            return false;
        }
        if (this.entity.getHeldRF() <= 0) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    private void resetTarget() {
        this.targetBlock = this.entity.depositPos;
    }

    public boolean func_75253_b() {
        return this.targetBlock != null && this.entity.getHeldRF() > 0;
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
    }

    public boolean canSeeChest() {
        RayTraceResult rayTrace = RatUtils.rayTraceBlocksIgnoreRatholes(this.entity.field_70170_p, this.entity.func_174791_d(), new Vec3d((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o() + 0.5, (double)this.targetBlock.func_177952_p() + 0.5), false, (Entity)this.entity);
        if (rayTrace instanceof BlockRayTraceResult) {
            BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTrace;
            BlockPos pos = blockRayTraceResult.func_216350_a();
            BlockPos sidePos = blockRayTraceResult.func_216350_a().func_177972_a(blockRayTraceResult.func_216354_b());
            return this.entity.field_70170_p.func_175623_d(sidePos) || this.entity.field_70170_p.func_175623_d(pos) || this.entity.field_70170_p.func_175625_s(pos) == this.entity.field_70170_p.func_175625_s(this.targetBlock);
        }
        return true;
    }

    private Vec3d getMovePos() {
        BlockPos minusVec = this.targetBlock.func_177972_a(this.entity.depositFacing).func_177973_b((Vec3i)this.targetBlock);
        return new Vec3d((Vec3i)this.targetBlock).func_72441_c((double)minusVec.func_177958_n() * 0.25, (double)minusVec.func_177956_o() * 0.25, (double)minusVec.func_177952_p() * 0.25);
    }

    public void func_75246_d() {
        if (this.targetBlock != null && this.entity.field_70170_p.func_175625_s(this.targetBlock) != null) {
            TileEntity te = this.entity.field_70170_p.func_175625_s(this.targetBlock);
            if (this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MINER) && !this.entity.func_70605_aq().func_75640_a() && this.entity.field_70122_E && !this.entity.func_70661_as().func_75492_a(this.getMovePos().func_82615_a() + 0.5, this.getMovePos().func_82617_b(), this.getMovePos().func_82616_c() + 0.5, 1.25)) {
                BlockPos rayPos = this.entity.rayTraceBlockPos(this.targetBlock.func_177984_a());
                if (rayPos != null && !rayPos.equals((Object)this.targetBlock)) {
                    BlockState block = this.entity.field_70170_p.func_180495_p(rayPos);
                    if (RatUtils.canRatBreakBlock(this.entity.field_70170_p, rayPos, this.entity) && block.func_185904_a().func_76230_c() && block.func_185904_a() != Material.field_151579_a) {
                        double distance = this.entity.func_70092_e(rayPos.func_177958_n(), rayPos.func_177956_o(), rayPos.func_177952_p());
                        SoundType soundType = block.func_177230_c().getSoundType(block, (IWorldReader)this.entity.field_70170_p, rayPos, null);
                        if (distance < 6.0 * this.entity.getRatDistanceModifier()) {
                            this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)85);
                            this.entity.crafting = true;
                            if (distance < (double)0.6f * this.entity.getRatDistanceModifier()) {
                                this.entity.func_213293_j(0.0, 0.0, 0.0);
                                this.entity.func_70661_as().func_75499_g();
                            }
                            ++this.breakingTime;
                            int hardness = (int)(block.func_185887_b((IBlockReader)this.entity.field_70170_p, rayPos) * 100.0f);
                            int i = (int)((float)this.breakingTime / (float)hardness * 10.0f);
                            if (this.breakingTime % 10 == 0) {
                                this.entity.func_184185_a(soundType.func_185846_f(), soundType.field_185860_m, soundType.field_185861_n);
                                this.entity.func_184185_a(SoundEvents.field_187730_dW, 1.0f, 0.5f);
                            }
                            if (i != this.previousBreakProgress) {
                                this.entity.field_70170_p.func_175715_c(this.entity.func_145782_y(), rayPos, i);
                                this.previousBreakProgress = i;
                            }
                            if (this.breakingTime == hardness) {
                                this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)86);
                                this.entity.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 1.0f);
                                this.entity.func_184185_a(soundType.func_185845_c(), soundType.field_185860_m, soundType.field_185861_n);
                                this.breakingTime = 0;
                                this.previousBreakProgress = -1;
                                this.destroyBlock(rayPos, block);
                                this.entity.fleePos = rayPos;
                                this.targetBlock = null;
                                this.entity.crafting = false;
                                this.func_75251_c();
                            }
                        }
                    }
                }
            } else {
                this.entity.func_70661_as().func_75492_a(this.getMovePos().func_82615_a() + 0.5, this.getMovePos().func_82617_b(), this.getMovePos().func_82616_c() + 0.5, 1.25);
                double distance = this.entity.func_70092_e((double)this.targetBlock.func_177958_n() + 0.5, this.targetBlock.func_177956_o() + 1, (double)this.targetBlock.func_177952_p() + 0.5);
                if (distance < 3.4 && this.canSeeChest() && te != null) {
                    LazyOptional handler = te.getCapability(CapabilityEnergy.ENERGY, this.entity.depositFacing);
                    if (handler.orElse(null) == null) {
                        this.targetBlock = null;
                        this.func_75251_c();
                        return;
                    }
                    int howMuchWeHave = this.entity.getHeldRF();
                    int inputtedEnergy = 0;
                    try {
                        if (((IEnergyStorage)handler.orElse(null)).canReceive() && ((IEnergyStorage)handler.orElse(null)).receiveEnergy(howMuchWeHave, true) > 0) {
                            inputtedEnergy = ((IEnergyStorage)handler.orElse(null)).receiveEnergy(howMuchWeHave, false);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (inputtedEnergy <= 0) {
                        this.targetBlock = null;
                        this.func_75251_c();
                    } else {
                        this.entity.setHeldRF(Math.max(0, this.entity.getHeldRF() - inputtedEnergy));
                        this.targetBlock = null;
                        this.func_75251_c();
                    }
                }
            }
        }
    }

    private void destroyBlock(BlockPos pos, BlockState state) {
        if (this.entity.field_70170_p instanceof ServerWorld) {
            LootContext.Builder loot = new LootContext.Builder((ServerWorld)this.entity.field_70170_p).func_216015_a(LootParameters.field_216286_f, (Object)new BlockPos((Vec3i)pos)).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216023_a(this.entity.func_70681_au()).func_186469_a(1.0f);
            List drops = state.func_177230_c().func_220076_a(state, loot);
            if (!drops.isEmpty() && this.entity.canRatPickupItem((ItemStack)drops.get(0))) {
                for (ItemStack drop : drops) {
                    this.entity.func_70099_a(drop, 0.0f);
                }
                this.entity.field_70170_p.func_175655_b(pos, false);
                this.entity.fleePos = pos;
            }
        }
    }
}

