/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.AttachedStemBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.StemBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;

public class RatAIHarvestCrops
extends Goal {
    private final EntityRat entity;
    private final BlockSorter targetSorter;
    private BlockPos targetBlock = null;
    private int feedingTicks;

    public RatAIHarvestCrops(EntityRat entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (!this.entity.canMove() || !this.entity.func_70909_n() || this.entity.getCommand() != RatCommand.HARVEST || this.entity.isInCage()) {
            return false;
        }
        if (!this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    private void resetTarget() {
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        int RADIUS = this.entity.getSearchRadius();
        for (BlockPos pos : BlockPos.func_218281_b((BlockPos)this.entity.getSearchCenter().func_177982_a(-RADIUS, -RADIUS, -RADIUS), (BlockPos)this.entity.getSearchCenter().func_177982_a(RADIUS, RADIUS, RADIUS)).map(BlockPos::func_185334_h).collect(Collectors.toList())) {
            BlockState block = this.entity.field_70170_p.func_180495_p(pos);
            if (!(block.func_177230_c() instanceof CropsBlock && ((CropsBlock)block.func_177230_c()).func_185525_y(block) || !(block.func_177230_c() instanceof CropsBlock) && block.func_177230_c() instanceof BushBlock) && block.func_185904_a() != Material.field_151572_C || block.func_177230_c() instanceof StemBlock || block.func_177230_c() instanceof AttachedStemBlock) continue;
            LootContext.Builder loot = new LootContext.Builder((ServerWorld)this.entity.field_70170_p).func_216015_a(LootParameters.field_216286_f, (Object)new BlockPos((Vec3i)pos)).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216023_a(this.entity.func_70681_au()).func_186469_a(1.0f);
            List items = block.func_177230_c().func_220076_a(block, loot);
            for (ItemStack stack : items) {
                if (!this.entity.canRatPickupItem(stack)) continue;
                allBlocks.add(pos);
            }
        }
        if (!allBlocks.isEmpty()) {
            allBlocks.sort(this.targetSorter);
            this.targetBlock = (BlockPos)allBlocks.get(0);
        }
    }

    public boolean func_75253_b() {
        return this.targetBlock != null && this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b() && (this.entity.field_70170_p.func_180495_p(this.targetBlock).func_177230_c() instanceof BushBlock || this.entity.field_70170_p.func_180495_p(this.targetBlock).func_185904_a() == Material.field_151572_C);
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.resetTarget();
    }

    public void func_75246_d() {
        if (this.targetBlock != null) {
            BlockState block = this.entity.field_70170_p.func_180495_p(this.targetBlock);
            this.entity.func_70661_as().func_75492_a((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p() + 0.5, 1.25);
            if (block.func_177230_c() instanceof BushBlock || block.func_185904_a() == Material.field_151572_C) {
                if (block.func_177230_c() instanceof CropsBlock && !((CropsBlock)block.func_177230_c()).func_185525_y(block)) {
                    this.targetBlock = null;
                    this.func_75251_c();
                    return;
                }
                double distance = this.entity.func_70092_e(this.targetBlock.func_177958_n(), this.targetBlock.func_177956_o(), this.targetBlock.func_177952_p());
                if (distance < 4.25 * this.entity.getRatDistanceModifier()) {
                    LootContext.Builder loot = new LootContext.Builder((ServerWorld)this.entity.field_70170_p).func_216015_a(LootParameters.field_216286_f, (Object)new BlockPos((Vec3i)this.targetBlock)).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216023_a(this.entity.func_70681_au()).func_186469_a(1.0f);
                    List drops = block.func_177230_c().func_220076_a(block, loot);
                    if (!drops.isEmpty() && this.entity.canRatPickupItem((ItemStack)drops.get(0))) {
                        ItemStack duplicate = ((ItemStack)drops.get(0)).func_77946_l();
                        try {
                            drops.remove(0);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b() && !this.entity.field_70170_p.field_72995_K) {
                            this.entity.func_70099_a(this.entity.func_184586_b(Hand.MAIN_HAND), 0.0f);
                        }
                        this.entity.func_184611_a(Hand.MAIN_HAND, duplicate);
                        for (ItemStack drop : drops) {
                            this.entity.func_70099_a(drop, 0.0f);
                        }
                    }
                    this.entity.fleePos = this.targetBlock;
                    if (!RatConfig.ratsBreakBlockOnHarvest || this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_REPLANTER)) {
                        if (block.func_185904_a() == Material.field_151572_C) {
                            this.entity.field_70170_p.func_175655_b(this.targetBlock, false);
                        } else if (block.func_177230_c() instanceof IGrowable) {
                            this.entity.field_70170_p.func_175656_a(this.targetBlock, block.func_177230_c().func_176223_P());
                        }
                    } else {
                        this.entity.field_70170_p.func_175655_b(this.targetBlock, false);
                    }
                    this.targetBlock = null;
                    this.func_75251_c();
                }
            }
        }
    }

    public class BlockSorter
    implements Comparator<BlockPos> {
        private final Entity entity;

        public BlockSorter(Entity entity) {
            this.entity = entity;
        }

        @Override
        public int compare(BlockPos pos1, BlockPos pos2) {
            double distance1 = this.getDistance(pos1);
            double distance2 = this.getDistance(pos2);
            return Double.compare(distance1, distance2);
        }

        private double getDistance(BlockPos pos) {
            double deltaX = this.entity.func_226277_ct_() - ((double)pos.func_177958_n() + 0.5);
            double deltaY = this.entity.func_226278_cu_() + (double)this.entity.func_70047_e() - ((double)pos.func_177956_o() + 0.5);
            double deltaZ = this.entity.func_226281_cx_() - ((double)pos.func_177952_p() + 0.5);
            return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        }
    }
}

