/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.stream.Collectors;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class RatAIHarvestTrees
extends Goal {
    private final EntityRat entity;
    private final BlockSorter targetSorter;
    private BlockPos targetBlock = null;
    private int destroyedLeaves;
    private int breakingTime;
    private int previousBreakProgress;

    public RatAIHarvestTrees(EntityRat entity) {
        this.entity = entity;
        this.targetSorter = new BlockSorter((Entity)entity);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public static final boolean isBlockLog(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_203425_a(BlockTags.field_200031_h);
    }

    public static final boolean isBlockLeaf(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof LeavesBlock;
    }

    public boolean func_75250_a() {
        if (!this.entity.canMove() || !this.entity.func_70909_n() || this.entity.getCommand() != RatCommand.HARVEST || this.entity.isInCage() || !this.entity.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_LUMBERJACK)) {
            return false;
        }
        if (!this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
            return false;
        }
        this.resetTarget();
        return this.targetBlock != null;
    }

    private void resetTarget() {
        World world = this.entity.field_70170_p;
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        int RADIUS = this.entity.getSearchRadius();
        for (BlockPos pos : BlockPos.func_218281_b((BlockPos)this.entity.getSearchCenter().func_177982_a(-RADIUS, -RADIUS, -RADIUS), (BlockPos)this.entity.getSearchCenter().func_177982_a(RADIUS, RADIUS, RADIUS)).map(BlockPos::func_185334_h).collect(Collectors.toList())) {
            if (!RatAIHarvestTrees.isBlockLog(world, pos)) continue;
            BlockPos topOfLog = new BlockPos((Vec3i)pos);
            while (!world.func_175623_d(topOfLog.func_177984_a()) && topOfLog.func_177956_o() < world.func_217301_I()) {
                topOfLog = topOfLog.func_177984_a();
            }
            if (!RatAIHarvestTrees.isBlockLeaf(world, topOfLog)) continue;
            BlockPos logPos = this.getStump(topOfLog);
            allBlocks.add(logPos);
        }
        if (!allBlocks.isEmpty()) {
            allBlocks.sort(this.targetSorter);
            this.targetBlock = (BlockPos)allBlocks.get(0);
        }
    }

    private BlockPos getStump(BlockPos log) {
        if (log.func_177956_o() > 0) {
            for (BlockPos pos : BlockPos.func_218281_b((BlockPos)log.func_177982_a(-4, -4, -4), (BlockPos)log.func_177982_a(4, 0, 4)).map(BlockPos::func_185334_h).collect(Collectors.toList())) {
                if (!RatAIHarvestTrees.isBlockLog(this.entity.field_70170_p, pos.func_177977_b()) && !RatAIHarvestTrees.isBlockLeaf(this.entity.field_70170_p, pos.func_177977_b())) continue;
                return this.getStump(pos.func_177977_b());
            }
        }
        return log;
    }

    public boolean func_75253_b() {
        return this.targetBlock != null && this.entity.func_184586_b(Hand.MAIN_HAND).func_190926_b();
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
        this.destroyedLeaves = 0;
        this.entity.crafting = false;
        this.resetTarget();
    }

    public void func_75246_d() {
        if (this.targetBlock != null) {
            RayTraceResult rayTrace;
            if (!this.entity.func_70661_as().func_75492_a((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o(), (double)this.targetBlock.func_177952_p() + 0.5, 1.25) && (rayTrace = RatUtils.rayTraceBlocksIgnoreRatholes(this.entity.field_70170_p, this.entity.func_174791_d(), new Vec3d((double)this.targetBlock.func_177958_n() + 0.5, (double)this.targetBlock.func_177956_o() + 0.5, (double)this.targetBlock.func_177952_p() + 0.5), false, (Entity)this.entity)) instanceof BlockRayTraceResult) {
                BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTrace;
                BlockPos pos = blockRayTraceResult.func_216350_a();
                BlockPos sidePos = blockRayTraceResult.func_216350_a().func_177972_a(blockRayTraceResult.func_216354_b());
                this.entity.func_70661_as().func_75492_a((double)sidePos.func_177958_n() + 0.5, (double)sidePos.func_177956_o() + 0.5, (double)sidePos.func_177952_p() + 0.5, 1.25);
            }
            if (RatAIHarvestTrees.isBlockLog(this.entity.field_70170_p, this.targetBlock)) {
                double distance = this.entity.func_70092_e(this.targetBlock.func_177958_n(), this.targetBlock.func_177956_o(), this.targetBlock.func_177952_p());
                if (distance < 2.5) {
                    this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)85);
                    this.entity.crafting = true;
                    if (distance < (double)0.6f * this.entity.getRatDistanceModifier()) {
                        this.entity.func_213293_j(0.0, 0.0, 0.0);
                        this.entity.func_70661_as().func_75499_g();
                    }
                    ++this.breakingTime;
                    int i = (int)((float)this.breakingTime / 160.0f * 10.0f);
                    if (this.breakingTime % 10 == 0) {
                        this.entity.func_184185_a(SoundEvents.field_187889_gU, 1.0f, 1.0f);
                        this.entity.func_184185_a(SoundEvents.field_187730_dW, 1.0f, 0.5f);
                    }
                    if (i != this.previousBreakProgress) {
                        this.entity.field_70170_p.func_175715_c(this.entity.func_145782_y(), this.targetBlock, i);
                        this.previousBreakProgress = i;
                    }
                    if (this.breakingTime == 160) {
                        this.entity.field_70170_p.func_72960_a((Entity)this.entity, (byte)86);
                        this.entity.func_184185_a(SoundEvents.field_187881_gQ, 1.0f, 1.0f);
                        this.breakingTime = 0;
                        this.previousBreakProgress = -1;
                        this.fellTree();
                        this.entity.fleePos = this.targetBlock;
                        this.targetBlock = null;
                        this.entity.crafting = false;
                        this.func_75251_c();
                    }
                }
            } else {
                this.entity.fleePos = this.targetBlock;
                this.targetBlock = null;
                this.func_75251_c();
            }
        }
    }

    private void fellTree() {
        World world = this.entity.field_70170_p;
        BlockPos base = new BlockPos((Vec3i)this.targetBlock);
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        while (RatAIHarvestTrees.isBlockLog(world, base)) {
            if (!queue.contains(base)) {
                queue.add(base);
            }
            for (BlockPos pos : BlockPos.func_218281_b((BlockPos)base.func_177982_a(-8, 0, -8), (BlockPos)base.func_177982_a(8, 2, 8)).map(BlockPos::func_185334_h).collect(Collectors.toList())) {
                if (!RatAIHarvestTrees.isBlockLog(world, pos) || queue.contains(pos)) continue;
                if (RatAIHarvestTrees.isBlockLog(world, pos.func_177984_a()) && !RatAIHarvestTrees.isBlockLog(world, base.func_177984_a())) {
                    base = pos;
                }
                queue.add(pos);
            }
            base = base.func_177984_a();
        }
        while (!queue.isEmpty()) {
            BlockPos pop = (BlockPos)queue.remove();
            world.func_175655_b(pop, true);
        }
    }

    public class BlockSorter
    implements Comparator<BlockPos> {
        private final Entity entity;

        public BlockSorter(Entity entity) {
            this.entity = entity;
        }

        @Override
        public int compare(BlockPos pos1, BlockPos pos2) {
            double yDist2;
            double yDist1 = Math.abs((double)pos1.func_177956_o() + 0.5 - this.entity.func_226278_cu_());
            if (yDist1 == (yDist2 = Math.abs((double)pos2.func_177956_o() + 0.5 - this.entity.func_226278_cu_()))) {
                double distance1 = this.getDistance(pos1);
                double distance2 = this.getDistance(pos2);
                return Double.compare(distance1, distance2);
            }
            return Double.compare(yDist1, yDist2);
        }

        private double getDistance(BlockPos pos) {
            double deltaX = this.entity.func_226277_ct_() - ((double)pos.func_177958_n() + 0.5);
            double deltaY = this.entity.func_226278_cu_() + (double)this.entity.func_70047_e() - ((double)pos.func_177956_o() + 0.5);
            double deltaZ = this.entity.func_226281_cx_() - ((double)pos.func_177952_p() + 0.5);
            return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        }
    }
}

