/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatUtils;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class RatAIWander
extends WaterAvoidingRandomWalkingGoal {
    private EntityRat rat;

    public RatAIWander(EntityRat creatureIn, double speedIn) {
        super((CreatureEntity)creatureIn, speedIn);
        this.rat = creatureIn;
        this.field_179481_f = 200;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    @Nullable
    protected Vec3d func_190864_f() {
        if (this.rat.func_70090_H()) {
            Vec3d vec3d = RandomPositionGenerator.func_191377_b((CreatureEntity)this.rat, (int)15, (int)7);
            return vec3d == null ? this.generateRatPosition() : vec3d;
        }
        return this.rat.func_70681_au().nextFloat() >= this.field_190865_h && !this.rat.isInCage() ? RandomPositionGenerator.func_191377_b((CreatureEntity)this.rat, (int)10, (int)7) : this.generateRatPosition();
    }

    private Vec3d generateRatPosition() {
        boolean inCage;
        Vec3d vec3d = null;
        boolean bl = inCage = this.rat.isInCage() || this.rat.inTube();
        if (inCage) {
            if (this.rat.inTube()) {
                vec3d = RatUtils.generateRandomCagePos(this.rat, 30, 10, new Vec3d(-this.rat.func_226277_ct_(), -this.rat.func_226278_cu_(), -this.rat.func_226281_cx_()), this.rat.waterBased);
                if (vec3d == null) {
                    vec3d = RatUtils.generateRandomCageOrTubePos(this.rat, 20, 20, null, false);
                }
            } else {
                vec3d = RatUtils.generateRandomTubePos(this.rat, 15, 3, new Vec3d(-this.rat.func_226277_ct_(), -this.rat.func_226278_cu_(), -this.rat.func_226281_cx_()), this.rat.waterBased);
                if (vec3d == null) {
                    vec3d = RatUtils.findRandomCageOrTubeTarget(this.rat, 15, 2);
                }
            }
            if (vec3d != null) {
                vec3d = new Vec3d((Vec3i)RatUtils.findLowestRatCage(new BlockPos(vec3d), (CreatureEntity)this.rat));
            }
        }
        if (!inCage || vec3d == null) {
            vec3d = this.rat.waterBased ? RatUtils.generateRandomWaterPos((CreatureEntity)this.rat, this.rat.func_70909_n() ? 5 : 10, 7, null, true) : RandomPositionGenerator.func_75463_a((CreatureEntity)this.rat, (int)(this.rat.func_70909_n() ? 5 : 10), (int)7);
        }
        return vec3d == null ? super.func_190864_f() : vec3d;
    }

    public boolean func_75250_a() {
        this.field_179481_f = this.rat.isInCage() ? 15 : 200;
        return this.shouldRatAIExecute() && super.func_75250_a();
    }

    private boolean shouldRatAIExecute() {
        return this.rat.canMove() && !this.rat.hasFlightUpgrade() && !this.rat.isDancing() && !this.rat.isFleeing && this.rat.shouldWander();
    }
}

