/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.blocks.BlockRatCage;
import com.github.alexthe666.rats.server.blocks.BlockRatCageDecorated;
import com.github.alexthe666.rats.server.items.IRatCageDecoration;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemRatDecoration
extends Item
implements IRatCageDecoration {
    public ItemRatDecoration(String name) {
        super(new Item.Properties().func_200916_a(RatsMod.TAB));
        this.setRegistryName("rats", name);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(new TranslationTextComponent("item.rats.cage_decoration.desc", new Object[0]).func_211708_a(TextFormatting.GRAY));
    }

    @Override
    public boolean canStay(World world, BlockPos pos, BlockRatCage cageBlock) {
        if (this == RatsItemRegistry.RAT_WATER_BOTTLE) {
            if (cageBlock instanceof BlockRatCageDecorated && world.func_180495_p(pos).func_177230_c() instanceof BlockRatCageDecorated) {
                Direction facing = (Direction)world.func_180495_p(pos).func_177229_b((IProperty)BlockRatCageDecorated.FACING);
                return cageBlock.canFenceConnectTo(world.func_180495_p(pos.func_177972_a(facing)), false, facing) == 0;
            }
            return true;
        }
        if (this == RatsItemRegistry.RAT_SEED_BOWL) {
            return cageBlock.canFenceConnectTo(world.func_180495_p(pos.func_177977_b()), false, Direction.DOWN) != 1;
        }
        if (this == RatsItemRegistry.RAT_BREEDING_LANTERN) {
            return cageBlock.canFenceConnectTo(world.func_180495_p(pos.func_177984_a()), false, Direction.UP) == 0;
        }
        return false;
    }
}

