/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.inventory.ContainerRatUpgrade;
import com.github.alexthe666.rats.server.inventory.InventoryRatUpgrade;
import com.github.alexthe666.rats.server.items.ItemRatUpgrade;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.items.RatsUpgradeConflictRegistry;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class ItemRatUpgradeCombined
extends ItemRatUpgrade {
    public ItemRatUpgradeCombined(String name) {
        super(name, 1, 1, 1);
    }

    public static boolean canCombineWithUpgrade(ItemStack combiner, ItemStack stack) {
        CompoundNBT tag = combiner.func_77978_p();
        if (tag != null && tag.func_150297_b("Items", 9)) {
            NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)tag, (NonNullList)nonnulllist);
            for (ItemStack contained : nonnulllist) {
                if (stack.func_77973_b() instanceof ItemRatUpgrade && stack.func_77973_b() != contained.func_77973_b() && !RatsUpgradeConflictRegistry.doesConflict(contained.func_77973_b(), stack.func_77973_b())) continue;
                return false;
            }
        }
        return combiner.func_77973_b() == RatsItemRegistry.RAT_UPGRADE_JURY_RIGGED || combiner.func_77973_b() == RatsItemRegistry.RAT_UPGRADE_COMBINED || combiner.func_77973_b() == RatsItemRegistry.RAT_UPGRADE_COMBINED_CREATIVE;
    }

    public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new CompoundNBT());
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77973_b() == RatsItemRegistry.RAT_UPGRADE_COMBINED_CREATIVE) {
            tooltip.add(new TranslationTextComponent("item.rats.rat_upgrade_combined_creative.desc", new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
        tooltip.add(new TranslationTextComponent("item.rats.rat_upgrade_combined.desc", new Object[0]).func_211708_a(TextFormatting.GRAY));
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b("Items", 9)) {
            NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)tag, (NonNullList)nonnulllist);
            int i = 0;
            int j = 0;
            for (ItemStack itemstack : nonnulllist) {
                if (itemstack.func_190926_b()) continue;
                ++j;
                if (i > 4) continue;
                ++i;
                tooltip.add((ITextComponent)new StringTextComponent(String.format("%s", itemstack.func_200301_q().func_150254_d())));
            }
            if (j - i > 0) {
                // empty if block
            }
        }
    }

    @Override
    public boolean func_77636_d(ItemStack stack) {
        if (stack.func_77973_b() == RatsItemRegistry.RAT_UPGRADE_COMBINED_CREATIVE) {
            return true;
        }
        CompoundNBT tag = stack.func_77978_p();
        boolean flag = false;
        if (tag != null && tag.func_150297_b("Items", 9)) {
            NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)tag, (NonNullList)nonnulllist);
            flag = !nonnulllist.isEmpty();
        }
        return flag;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand hand) {
        if (this == RatsItemRegistry.RAT_UPGRADE_COMBINED_CREATIVE) {
            final ItemStack itemStackIn = player.func_184586_b(hand);
            if (!player.func_225608_bj_()) {
                RatsMod.PROXY.setRefrencedItem(itemStackIn);
                if (!worldIn.field_72995_K) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                        public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
                            return new ContainerRatUpgrade(p_createMenu_1_, (IInventory)new InventoryRatUpgrade(itemStackIn), p_createMenu_2_);
                        }

                        public ITextComponent func_145748_c_() {
                            return ItemRatUpgradeCombined.this.func_200295_i(itemStackIn);
                        }
                    });
                }
                return new ActionResult(ActionResultType.SUCCESS, (Object)itemStackIn);
            }
            return new ActionResult(ActionResultType.PASS, (Object)itemStackIn);
        }
        return super.func_77659_a(worldIn, player, hand);
    }
}

