/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.world;

import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.world.ChunkProviderRatlantis;
import com.github.alexthe666.rats.server.world.RatsWorldRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.SingleBiomeProvider;
import net.minecraft.world.biome.provider.SingleBiomeProviderSettings;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RatlantisDimension
extends Dimension {
    public static final BlockPos SPAWN = new BlockPos(0, 110, 0);

    public RatlantisDimension(World worldIn, DimensionType dimension) {
        super(worldIn, dimension, 0.0f);
    }

    public ChunkGenerator<?> func_186060_c() {
        OverworldGenSettings settings = (OverworldGenSettings)ChunkGeneratorType.field_206911_b.func_205483_a();
        settings.func_214969_a(RatsBlockRegistry.MARBLED_CHEESE.func_176223_P());
        SingleBiomeProviderSettings providerSettings = new SingleBiomeProviderSettings(null);
        providerSettings.func_205436_a(RatsWorldRegistry.RATLANTIS_BIOME);
        return new ChunkProviderRatlantis((IWorld)this.field_76579_a, (BiomeProvider)new SingleBiomeProvider(providerSettings), settings);
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        double d0 = MathHelper.func_181162_h((double)((double)worldTime / 24000.0 - 0.25));
        double d1 = 0.5 - Math.cos(d0 * Math.PI) / 2.0;
        return (float)(d0 * 2.0 + d1) / 3.0f;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public float[] func_76560_a(float celestialAngle, float partialTicks) {
        return super.func_76560_a(celestialAngle, partialTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d func_76562_b(float p_76562_1_, float p_76562_2_) {
        float f = MathHelper.func_76131_a((float)(MathHelper.func_76134_b((float)(p_76562_1_ * ((float)Math.PI * 2))) * 2.0f + 0.5f), (float)0.0f, (float)1.0f);
        float bright = 1.15f * f;
        float f1 = 1.0f;
        float f2 = 0.98f;
        float f3 = 0.79f;
        return new Vec3d((double)f1 * (double)bright, (double)f2 * (double)bright, (double)f3 * (double)bright);
    }

    public boolean func_191066_m() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_76561_g() {
        return true;
    }

    public boolean func_76567_e() {
        return false;
    }

    public boolean func_76569_d() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_76571_f() {
        return super.func_76571_f() + 20.0f;
    }

    @Nullable
    public BlockPos func_206920_a(ChunkPos p_206920_1_, boolean p_206920_2_) {
        Random random = new Random(this.field_76579_a.func_72905_C());
        BlockPos blockpos = new BlockPos(p_206920_1_.func_180334_c() + random.nextInt(15), 0, p_206920_1_.func_180330_f() + random.nextInt(15));
        return this.field_76579_a.func_184141_c(blockpos).func_185904_a().func_76230_c() ? blockpos : null;
    }

    public BlockPos func_177496_h() {
        return SPAWN;
    }

    @Nullable
    public BlockPos func_206921_a(int p_206921_1_, int p_206921_2_, boolean p_206921_3_) {
        return this.func_206920_a(new ChunkPos(p_206921_1_ >> 4, p_206921_2_ >> 4), p_206921_3_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_76568_b(int p_76568_1_, int p_76568_2_) {
        return false;
    }
}

