/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xreliquary.blocks.BaseBlock;
import xreliquary.blocks.tile.PassivePedestalTileEntity;
import xreliquary.util.InventoryHelper;
import xreliquary.util.WorldHelper;

@Mod.EventBusSubscriber(modid="xreliquary")
public class PassivePedestalBlock
extends BaseBlock {
    static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    private static final VoxelShape SHAPE = PassivePedestalBlock.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0);
    public static final Set<Block> ALL_PEDESTAL_BLOCKS = new HashSet<Block>();

    public PassivePedestalBlock(DyeColor dyeColor) {
        this("pedestals/passive/" + dyeColor.func_176610_l() + "_" + "passive_pedestal");
        ALL_PEDESTAL_BLOCKS.add(this);
    }

    public PassivePedestalBlock(String name) {
        super(name, Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestTool(ToolType.PICKAXE).func_200948_a(1.5f, 2.0f));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        if (context.func_195999_j() == null) {
            return this.func_176223_P();
        }
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195999_j().func_174811_aO());
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return !heldItem.func_190926_b() || player.func_70093_af();
        }
        if (!(world.func_175625_s(pos) instanceof PassivePedestalTileEntity)) {
            return false;
        }
        Optional<PassivePedestalTileEntity> pedestal = WorldHelper.getTile((IBlockReader)world, pos, PassivePedestalTileEntity.class);
        if (heldItem.func_190926_b()) {
            if (player.func_70093_af() && pedestal.isPresent()) {
                pedestal.get().removeAndSpawnItem();
                return true;
            }
            return false;
        }
        return pedestal.map(ped -> (Boolean)InventoryHelper.getItemHandlerFrom(ped).map(itemHandler -> InventoryHelper.tryAddingPlayerCurrentItem(player, itemHandler, Hand.MAIN_HAND)).orElse((Object)false)).orElse(false);
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        WorldHelper.getTile((IBlockReader)world, pos, PassivePedestalTileEntity.class).ifPresent(PassivePedestalTileEntity::dropPedestalInventory);
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PassivePedestalTileEntity();
    }

    @SubscribeEvent
    public static void onRightClicked(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getEntityPlayer();
        if (!(player.func_70093_af() && player.func_184614_ca().func_190926_b() && player.func_184592_cb().func_190926_b())) {
            return;
        }
        Block block = player.field_70170_p.func_180495_p(event.getPos()).func_177230_c();
        if (!(block instanceof PassivePedestalBlock)) {
            return;
        }
        PassivePedestalTileEntity pedestal = (PassivePedestalTileEntity)player.field_70170_p.func_175625_s(event.getPos());
        if (pedestal != null) {
            pedestal.removeAndSpawnItem();
        }
        event.setCanceled(true);
    }
}

