/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks.tile;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import xreliquary.blocks.tile.PedestalTileEntity;

public class PedestalFluidHandler
implements IFluidHandler {
    private PedestalTileEntity pedestal;

    PedestalFluidHandler(PedestalTileEntity pedestal) {
        this.pedestal = pedestal;
    }

    public int getTanks() {
        return this.getFluidHandlerValue(IFluidHandler::getTanks).orElse(0);
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getFluidHandlerValue(fh -> fh.getFluidInTank(tank)).orElse(FluidStack.EMPTY);
    }

    public int getTankCapacity(int tank) {
        return this.getFluidHandlerValue(fh -> fh.getTankCapacity(tank)).orElse(0);
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.getFluidHandlerValue(fh -> fh.isFluidValid(tank, stack)).orElse(false);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.getFluidHandlerValue(fh -> this.executeAndUpdateItem((IFluidHandler)fh, f -> f.fill(resource, action))).orElse(0);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.getFluidHandlerValue(fh -> this.executeAndUpdateItem((IFluidHandler)fh, f -> f.drain(resource, action))).orElse(FluidStack.EMPTY);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.getFluidHandlerValue(fh -> this.executeAndUpdateItem((IFluidHandler)fh, f -> f.drain(maxDrain, action))).orElse(FluidStack.EMPTY);
    }

    private <T> T executeAndUpdateItem(IFluidHandler fh, Function<IFluidHandler, T> execute) {
        IFluidHandlerItem fhi;
        T ret = execute.apply(fh);
        if (fh instanceof IFluidHandlerItem && (fhi = (IFluidHandlerItem)fh).getContainer() != this.pedestal.getItem()) {
            this.pedestal.setItem(fhi.getContainer());
        }
        return ret;
    }

    private <T> Optional<T> getFluidHandlerValue(Function<IFluidHandler, T> mapValue) {
        ItemStack fluidContainer = this.pedestal.getFluidContainer();
        if (fluidContainer.func_190926_b()) {
            return Optional.empty();
        }
        LazyOptional cap = fluidContainer.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
        if (cap.isPresent()) {
            return (Optional)cap.map(fh -> Optional.of(mapValue.apply((IFluidHandler)fh))).orElse(Optional.empty());
        }
        return (Optional)fluidContainer.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).map(fh -> Optional.of(mapValue.apply((IFluidHandler)fh))).orElse(Optional.empty());
    }
}

