/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import xreliquary.api.client.IPedestalItemRenderer;
import xreliquary.blocks.tile.PedestalTileEntity;
import xreliquary.client.render.PedestalRenderer;

public class PedestalFishHookRenderer
implements IPedestalItemRenderer {
    private static final ResourceLocation FISH_PARTICLES = new ResourceLocation("textures/entity/fishing_hook.png");
    private static EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();

    @Override
    public void doRender(PedestalRenderer tesr, PedestalTileEntity te, ItemStack stack, double x, double y, double z, float partialTicks, int destroyStage) {
        ((Optional)te.getItemData()).ifPresent(itemData -> this.renderHook(te, x, y, z, itemData));
    }

    private void renderHook(PedestalTileEntity te, double x, double y, double z, Object itemData) {
        if (!(itemData instanceof HookRenderingData)) {
            return;
        }
        HookRenderingData hookData = (HookRenderingData)itemData;
        double translateX = hookData.hookX - (double)te.func_174877_v().func_177958_n() + x;
        double translateY = hookData.hookY - (double)te.func_174877_v().func_177956_o() + y;
        double translateZ = hookData.hookZ - (double)te.func_174877_v().func_177952_p() + z;
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)translateX, (double)translateY, (double)translateZ);
        GlStateManager.enableRescaleNormal();
        GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
        PedestalFishHookRenderer.renderManager.field_78724_e.func_110577_a(FISH_PARTICLES);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.rotatef((float)(180.0f - PedestalFishHookRenderer.renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)((float)(PedestalFishHookRenderer.renderManager.field_78733_k.field_74320_O == 2 ? -1 : 1) * -PedestalFishHookRenderer.renderManager.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        bufferbuilder.func_181662_b(-0.5, -0.5, 0.0).func_187315_a(0.0, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(0.5, -0.5, 0.0).func_187315_a(1.0, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(0.5, 0.5, 0.0).func_187315_a(1.0, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_181662_b(-0.5, 0.5, 0.0).func_187315_a(0.0, 0.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.disableRescaleNormal();
        GlStateManager.popMatrix();
        double pedestalX = (double)te.func_174877_v().func_177958_n() + 0.5;
        double pedestalY = (double)te.func_174877_v().func_177956_o() + 0.7;
        double pedestalZ = (double)te.func_174877_v().func_177952_p() + 0.5;
        double hookX = hookData.hookX;
        double hookY = hookData.hookY + 0.25;
        double hookZ = hookData.hookZ;
        double xDiff = (float)(hookX - pedestalX);
        double yDiff = (float)(hookY - pedestalY);
        double zDiff = (float)(hookZ - pedestalZ);
        GlStateManager.disableTexture();
        GlStateManager.disableLighting();
        bufferbuilder.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (int k = 0; k <= 16; ++k) {
            float f6 = (float)k / 16.0f;
            bufferbuilder.func_181662_b(x + 0.5 + xDiff * (double)f6, y + 0.5 + yDiff * (double)(f6 * f6 + f6) * 0.5 + 0.25, z + 0.5 + zDiff * (double)f6).func_181669_b(0, 0, 0, 255).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.enableLighting();
        GlStateManager.enableTexture();
    }

    public static class HookRenderingData {
        final double hookX;
        final double hookY;
        final double hookZ;

        public HookRenderingData(double hookX, double hookY, double hookZ) {
            this.hookX = hookX;
            this.hookY = hookY;
            this.hookZ = hookZ;
        }
    }
}

