/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.compat.jei;

import java.util.Collections;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import xreliquary.Reliquary;
import xreliquary.compat.jei.alkahestry.AlkahestryChargingRecipeCategory;
import xreliquary.compat.jei.alkahestry.AlkahestryCraftingRecipeCategory;
import xreliquary.compat.jei.cauldron.CauldronRecipeCategory;
import xreliquary.compat.jei.cauldron.CauldronRecipeMaker;
import xreliquary.compat.jei.descriptions.DescriptionEntry;
import xreliquary.compat.jei.descriptions.JEIDescriptionRegistry;
import xreliquary.compat.jei.lingering.ArrowShotRecipeMaker;
import xreliquary.compat.jei.magazines.MagazineRecipeMaker;
import xreliquary.compat.jei.mortar.MortarRecipeCategory;
import xreliquary.compat.jei.mortar.MortarRecipeMaker;
import xreliquary.crafting.AlkahestryRecipeRegistry;
import xreliquary.init.ModBlocks;
import xreliquary.init.ModItems;

@JeiPlugin
public class ReliquaryPlugin
implements IModPlugin {
    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.useNbtForSubtypes(new Item[]{ModItems.MOB_CHARM_FRAGMENT, ModItems.MOB_CHARM, ModItems.POTION_ESSENCE, ModItems.POTION, ModItems.SPLASH_POTION, ModItems.LINGERING_POTION, ModItems.TIPPED_ARROW, ModItems.NEUTRAL_BULLET, ModItems.NEUTRAL_MAGAZINE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new AlkahestryCraftingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new AlkahestryChargingRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new MortarRecipeCategory(guiHelper)});
        registration.addRecipeCategories(new IRecipeCategory[]{new CauldronRecipeCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)Blocks.field_150462_ai), new ResourceLocation[]{AlkahestryChargingRecipeCategory.UID, AlkahestryCraftingRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.APOTHECARY_MORTAR), new ResourceLocation[]{MortarRecipeCategory.UID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModBlocks.APOTHECARY_CAULDRON), new ResourceLocation[]{CauldronRecipeCategory.UID});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(AlkahestryRecipeRegistry.getCraftingRecipes(), AlkahestryCraftingRecipeCategory.UID);
        registration.addRecipes(AlkahestryRecipeRegistry.getChargingRecipes(), AlkahestryChargingRecipeCategory.UID);
        registration.addRecipes(MortarRecipeMaker.getRecipes(), MortarRecipeCategory.UID);
        registration.addRecipes(CauldronRecipeMaker.getRecipes(), CauldronRecipeCategory.UID);
        registration.addRecipes(ArrowShotRecipeMaker.getRecipes(new ItemStack((IItemProvider)ModItems.NEUTRAL_BULLET), "bullet"), VanillaRecipeCategoryUid.CRAFTING);
        registration.addRecipes(ArrowShotRecipeMaker.getRecipes(new ItemStack((IItemProvider)ModItems.TIPPED_ARROW), new ItemStack((IItemProvider)Items.field_151032_g), 0.125f, "arrow"), VanillaRecipeCategoryUid.CRAFTING);
        registration.addRecipes(MagazineRecipeMaker.getRecipes(), VanillaRecipeCategoryUid.CRAFTING);
        this.registerMobCharmBeltRecipe(registration);
        for (DescriptionEntry entry : JEIDescriptionRegistry.getEntries()) {
            List<ItemStack> itemStacks = entry.getItemStacks();
            if (itemStacks.isEmpty()) continue;
            registration.addIngredientInfo(itemStacks, VanillaTypes.ITEM, entry.langKeys());
        }
    }

    private void registerMobCharmBeltRecipe(IRecipeRegistration registration) {
        NonNullList fragments = NonNullList.func_191196_a();
        ModItems.MOB_CHARM_FRAGMENT.func_150895_a(Reliquary.ITEM_GROUP, (NonNullList<ItemStack>)fragments);
        ItemStack[] fragmentStacks = (ItemStack[])fragments.toArray((Object[])new ItemStack[0]);
        registration.addRecipes(Collections.singleton(new ShapedRecipe(new ResourceLocation("xreliquary", "items/mob_charm_belt"), "", 3, 3, NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{() -> Items.field_151116_aA}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{() -> Items.field_151116_aA}), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{() -> Items.field_151116_aA}), Ingredient.func_193369_a((ItemStack[])fragmentStacks), Ingredient.field_193370_a, Ingredient.func_193369_a((ItemStack[])fragmentStacks), Ingredient.func_193369_a((ItemStack[])fragmentStacks), Ingredient.func_193369_a((ItemStack[])fragmentStacks), Ingredient.func_193369_a((ItemStack[])fragmentStacks)}), new ItemStack((IItemProvider)ModItems.MOB_CHARM_BELT))), VanillaRecipeCategoryUid.CRAFTING);
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("xreliquary", "default");
    }
}

