/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.compat.jei.magazines;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import xreliquary.init.ModItems;
import xreliquary.items.BulletItem;
import xreliquary.util.potions.PotionEssence;
import xreliquary.util.potions.PotionMap;
import xreliquary.util.potions.XRPotionHelper;

public class MagazineRecipeMaker {
    private MagazineRecipeMaker() {
    }

    public static List<ShapedRecipe> getRecipes() {
        ArrayList<ShapedRecipe> recipes = new ArrayList<ShapedRecipe>();
        MagazineRecipeMaker.addRegularMagazines(recipes);
        MagazineRecipeMaker.addPotionMagazines(recipes);
        return recipes;
    }

    private static void addRegularMagazines(ArrayList<ShapedRecipe> recipes) {
        ImmutableMap bulletMagazines = new ImmutableMap.Builder().put((Object)ModItems.NEUTRAL_BULLET, (Object)ModItems.NEUTRAL_MAGAZINE).put((Object)ModItems.EXORCISM_BULLET, (Object)ModItems.EXORCISM_MAGAZINE).put((Object)ModItems.BLAZE_BULLET, (Object)ModItems.BLAZE_MAGAZINE).put((Object)ModItems.ENDER_BULLET, (Object)ModItems.ENDER_MAGAZINE).put((Object)ModItems.CONCUSSIVE_BULLET, (Object)ModItems.CONCUSSIVE_MAGAZINE).put((Object)ModItems.BUSTER_BULLET, (Object)ModItems.BUSTER_MAGAZINE).put((Object)ModItems.SEEKER_BULLET, (Object)ModItems.SEEKER_MAGAZINE).put((Object)ModItems.SAND_BULLET, (Object)ModItems.SAND_MAGAZINE).put((Object)ModItems.STORM_BULLET, (Object)ModItems.STORM_MAGAZINE).build();
        for (Map.Entry bulletMagazine : bulletMagazines.entrySet()) {
            NonNullList inputs = NonNullList.func_191196_a();
            MagazineRecipeMaker.addShots((List<Ingredient>)inputs, (BulletItem)bulletMagazine.getKey());
            inputs.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)ModItems.EMPTY_MAGAZINE)}));
            MagazineRecipeMaker.addShots((List<Ingredient>)inputs, (BulletItem)bulletMagazine.getKey());
            ItemStack output = new ItemStack((IItemProvider)bulletMagazine.getValue());
            ResourceLocation id = new ResourceLocation("xreliquary", "xreliquary.magazine." + output.func_77977_a());
            recipes.add(new ShapedRecipe(id, "xreliquary.magazine", 3, 3, inputs, output));
        }
    }

    private static void addPotionMagazines(ArrayList<ShapedRecipe> recipes) {
        for (PotionEssence essence : PotionMap.uniquePotions) {
            List<EffectInstance> effects = XRPotionHelper.changePotionEffectsDuration(essence.getEffects(), 0.2f);
            NonNullList inputs = NonNullList.func_191196_a();
            MagazineRecipeMaker.addShots((List<Ingredient>)inputs, effects);
            inputs.add((Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)ModItems.EMPTY_MAGAZINE)}));
            MagazineRecipeMaker.addShots((List<Ingredient>)inputs, effects);
            ItemStack output = new ItemStack((IItemProvider)ModItems.NEUTRAL_MAGAZINE);
            XRPotionHelper.addPotionEffectsToStack(output, effects);
            ResourceLocation id = new ResourceLocation("xreliquary", output.func_77977_a());
            recipes.add(new ShapedRecipe(id, "xreliquary.potion.magazine", 3, 3, inputs, output));
        }
    }

    private static void addShots(List<Ingredient> inputs, List<EffectInstance> effects) {
        MagazineRecipeMaker.addShots(inputs, effects, ModItems.NEUTRAL_BULLET);
    }

    private static void addShots(List<Ingredient> inputs, BulletItem shotType) {
        MagazineRecipeMaker.addShots(inputs, Collections.emptyList(), shotType);
    }

    private static void addShots(List<Ingredient> inputs, List<EffectInstance> effects, BulletItem shotType) {
        ItemStack shot = new ItemStack((IItemProvider)shotType);
        if (!effects.isEmpty()) {
            XRPotionHelper.addPotionEffectsToStack(shot, effects);
        }
        for (int i = 0; i < 4; ++i) {
            inputs.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{shot}));
        }
    }
}

