/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.crafting;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import xreliquary.crafting.AlkahestryRecipeRegistry;
import xreliquary.init.ModItems;
import xreliquary.items.AlkahestryTomeItem;
import xreliquary.reference.Settings;

public class AlkahestryDrainRecipe
implements ICraftingRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final int chargeToDrain;
    private final ItemStack result;
    private final ResourceLocation id;
    private final Ingredient tomeIngredient;

    private AlkahestryDrainRecipe(ResourceLocation id, int chargeToDrain, ItemStack result) {
        this.chargeToDrain = chargeToDrain;
        this.result = result;
        this.id = id;
        this.tomeIngredient = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{AlkahestryTomeItem.setCharge(new ItemStack((IItemProvider)ModItems.ALKAHESTRY_TOME), (Integer)Settings.COMMON.items.alkahestryTome.chargeLimit.get())});
        AlkahestryRecipeRegistry.setDrainRecipe(this);
    }

    public boolean func_192399_d() {
        return true;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        boolean hasTome = false;
        ItemStack tome = ItemStack.field_190927_a;
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack stack = inv.func_70301_a(slot);
            if (stack.func_190926_b()) continue;
            if (!hasTome && stack.func_77973_b() == ModItems.ALKAHESTRY_TOME) {
                hasTome = true;
                tome = stack;
                continue;
            }
            return false;
        }
        return hasTome && AlkahestryTomeItem.getCharge(tome) > 0;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.tomeIngredient});
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack tome = this.getTome(inv).func_77946_l();
        int charge = AlkahestryTomeItem.getCharge(tome);
        ItemStack ret = this.result.func_77946_l();
        ret.func_190920_e(Math.min(ret.func_77976_d(), charge / this.chargeToDrain));
        return ret;
    }

    private ItemStack getTome(CraftingInventory inv) {
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack stack = inv.func_70301_a(slot);
            if (stack.func_77973_b() != ModItems.ALKAHESTRY_TOME) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 1;
    }

    public ItemStack func_77571_b() {
        return this.result;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList ret = super.func_179532_b((IInventory)inv);
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack stack = inv.func_70301_a(slot);
            if (stack.func_77973_b() != ModItems.ALKAHESTRY_TOME) continue;
            ItemStack tome = stack.func_77946_l();
            int charge = AlkahestryTomeItem.getCharge(tome);
            int itemCount = Math.min(this.result.func_77976_d(), charge / this.chargeToDrain);
            ModItems.ALKAHESTRY_TOME.useCharge(tome, itemCount * this.chargeToDrain);
            ret.set(slot, (Object)tome);
        }
        return ret;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<AlkahestryDrainRecipe> {
        public AlkahestryDrainRecipe read(ResourceLocation recipeId, JsonObject json) {
            if (Boolean.TRUE.equals(Settings.COMMON.disable.disableAlkahestry.get())) {
                return null;
            }
            int chargeToDrain = JSONUtils.func_151203_m((JsonObject)json, (String)"charge");
            ItemStack result = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"), (boolean)true);
            return new AlkahestryDrainRecipe(recipeId, chargeToDrain, result);
        }

        @Nullable
        public AlkahestryDrainRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new AlkahestryDrainRecipe(recipeId, buffer.readInt(), buffer.func_150791_c());
        }

        public void write(PacketBuffer buffer, AlkahestryDrainRecipe recipe) {
            buffer.writeInt(recipe.chargeToDrain);
            buffer.func_150788_a(recipe.result);
        }
    }
}

