/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.crafting;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import xreliquary.items.IPotionItem;
import xreliquary.util.potions.XRPotionHelper;

public class PotionEffectsRecipe
implements ICraftingRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final ShapedRecipe compose;
    private final float potionDurationFactor;

    private PotionEffectsRecipe(ShapedRecipe compose, float potionDurationFactor) {
        this.compose = compose;
        this.potionDurationFactor = potionDurationFactor;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack newOutput = this.compose.func_77571_b().func_77946_l();
        this.findMatchAndUpdateEffects(inv).ifPresent(targetEffects -> XRPotionHelper.addPotionEffectsToStack(newOutput, targetEffects));
        return newOutput;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= this.compose.getRecipeWidth() && height >= this.compose.getRecipeHeight();
    }

    private Optional<List<EffectInstance>> findMatchAndUpdateEffects(CraftingInventory inv) {
        for (int startX = 0; startX <= inv.func_174922_i() - this.compose.getRecipeWidth(); ++startX) {
            for (int startY = 0; startY <= inv.func_174923_h() - this.compose.getRecipeHeight(); ++startY) {
                ArrayList<Object> targetEffects = new ArrayList<EffectInstance>();
                if (this.checkMatchAndUpdateEffects(inv, targetEffects, startX, startY, false)) {
                    return Optional.of(targetEffects);
                }
                targetEffects = new ArrayList();
                if (!this.checkMatchAndUpdateEffects(inv, targetEffects, startX, startY, true)) continue;
                return Optional.of(targetEffects);
            }
        }
        return Optional.empty();
    }

    private boolean checkMatchAndUpdateEffects(CraftingInventory inv, List<EffectInstance> targetEffects, int startX, int startY, boolean mirror) {
        for (int x = 0; x < this.compose.getRecipeWidth(); ++x) {
            for (int y = 0; y < this.compose.getRecipeHeight(); ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Ingredient target = this.getTarget(subX, subY, mirror);
                if (!target.test(inv.func_70301_a(x + y * inv.func_174922_i()))) {
                    return false;
                }
                this.updateTargetEffects(inv, targetEffects, x, y);
            }
        }
        return true;
    }

    public boolean matches(CraftingInventory inv, World world) {
        for (int x = 0; x <= inv.func_174922_i() - this.compose.getRecipeWidth(); ++x) {
            for (int y = 0; y <= inv.func_174923_h() - this.compose.getRecipeHeight(); ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(CraftingInventory inv, int startX, int startY, boolean mirror) {
        ArrayList<EffectInstance> targetEffects = new ArrayList<EffectInstance>();
        for (int x = 0; x < this.compose.getRecipeWidth(); ++x) {
            for (int y = 0; y < this.compose.getRecipeHeight(); ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Ingredient target = this.getTarget(subX, subY, mirror);
                if (!target.test(inv.func_70301_a(x + y * inv.func_174922_i()))) {
                    return false;
                }
                if (this.updateTargetEffects(inv, targetEffects, x, y)) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack func_77571_b() {
        return this.compose.func_77571_b();
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.compose.func_192400_c();
    }

    public ResourceLocation func_199560_c() {
        return this.compose.func_199560_c();
    }

    private Ingredient getTarget(int subX, int subY, boolean mirror) {
        if (subX >= 0 && subY >= 0 && subX < this.compose.getRecipeWidth() && subY < this.compose.getRecipeHeight()) {
            if (mirror) {
                return (Ingredient)this.compose.func_192400_c().get(this.compose.getRecipeWidth() - subX - 1 + subY * this.compose.getRecipeWidth());
            }
            return (Ingredient)this.compose.func_192400_c().get(subX + subY * this.compose.getRecipeWidth());
        }
        return Ingredient.field_193370_a;
    }

    private boolean updateTargetEffects(CraftingInventory inv, List<EffectInstance> targetEffects, int x, int y) {
        ItemStack invStack = inv.func_70301_a(x + y * inv.func_174922_i());
        if (invStack.func_77973_b() instanceof IPotionItem) {
            List<EffectInstance> effects = ((IPotionItem)invStack.func_77973_b()).getEffects(invStack);
            if (effects.isEmpty()) {
                return true;
            }
            if (targetEffects.isEmpty()) {
                targetEffects.addAll(XRPotionHelper.changePotionEffectsDuration(effects, this.potionDurationFactor));
            } else {
                return XRPotionHelper.changePotionEffectsDuration(effects, this.potionDurationFactor).equals(targetEffects);
            }
        }
        return true;
    }

    public boolean func_192399_d() {
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<PotionEffectsRecipe> {
        public PotionEffectsRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new PotionEffectsRecipe((ShapedRecipe)IRecipeSerializer.field_222157_a.func_199425_a_(recipeId, json), JSONUtils.func_151221_a((JsonObject)json, (String)"duration_factor", (float)1.0f));
        }

        @Nullable
        public PotionEffectsRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new PotionEffectsRecipe((ShapedRecipe)IRecipeSerializer.field_222157_a.func_199426_a_(recipeId, buffer), buffer.readFloat());
        }

        public void write(PacketBuffer buffer, PotionEffectsRecipe recipe) {
            IRecipeSerializer.field_222157_a.func_199427_a_(buffer, (IRecipe)recipe.compose);
            buffer.writeFloat(recipe.potionDurationFactor);
        }
    }
}

