/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities;

import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;
import xreliquary.init.ModEntities;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class EnderStaffProjectileEntity
extends ThrowableEntity
implements IRendersAsItem {
    private int ticksInAir;
    private Entity ignoreEntity;
    private int ignoreTime;
    private boolean normalGravity = false;

    public EnderStaffProjectileEntity(EntityType<EnderStaffProjectileEntity> entityType, World world) {
        super(entityType, world);
    }

    public EnderStaffProjectileEntity(World world, PlayerEntity entityPlayer, boolean shortRange) {
        super(ModEntities.ENDER_STAFF_PROJECTILE, (LivingEntity)entityPlayer, world);
        this.normalGravity = shortRange;
    }

    protected float func_70185_h() {
        if (this.normalGravity) {
            return super.func_70185_h();
        }
        return 0.005f;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        this.func_70030_z();
        if (this.field_70191_b > 0) {
            --this.field_70191_b;
        }
        if (this.ticksInAir % 4 == this.field_70170_p.field_73012_v.nextInt(5)) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 1.0);
        }
        if (this.field_174854_a) {
            this.field_174854_a = false;
            this.func_213293_j(0.0, 0.0, 0.0);
            this.ticksInAir = 0;
        } else {
            ++this.ticksInAir;
        }
        AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0);
        for (Entity entity : this.field_70170_p.func_175674_a((Entity)this, axisalignedbb, e -> !e.func_175149_v() && e.func_70067_L())) {
            if (entity == this.ignoreEntity) {
                ++this.ignoreTime;
                break;
            }
            if (this.field_70192_c == null || this.field_70173_aa >= 2 || this.ignoreEntity != null) continue;
            this.ignoreEntity = entity;
            this.ignoreTime = 3;
            break;
        }
        RayTraceResult raytraceresult = ProjectileHelper.func_221267_a((Entity)this, (AxisAlignedBB)axisalignedbb, e -> !e.func_175149_v() && e.func_70067_L() && e != this.ignoreEntity, (RayTraceContext.BlockMode)RayTraceContext.BlockMode.OUTLINE, (boolean)true);
        if (this.ignoreEntity != null && this.ignoreTime-- <= 0) {
            this.ignoreEntity = null;
        }
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(((BlockRayTraceResult)raytraceresult).func_216350_a()).func_177230_c() == Blocks.field_150427_aO) {
                this.func_181015_d(((BlockRayTraceResult)raytraceresult).func_216350_a());
            } else if (!ForgeEventFactory.onProjectileImpact((ThrowableEntity)this, (RayTraceResult)raytraceresult)) {
                this.func_70184_a(raytraceresult);
            }
        }
        Vec3d vec3d = this.func_213322_ci();
        this.field_70165_t += vec3d.field_72450_a;
        this.field_70163_u += vec3d.field_72448_b;
        this.field_70161_v += vec3d.field_72449_c;
        float f = MathHelper.func_76133_a((double)EnderStaffProjectileEntity.func_213296_b((Vec3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
        float var18 = 0.99f;
        float var19 = this.func_70185_h();
        if (this.func_70090_H()) {
            this.onThrowableCollision((RayTraceResult)new BlockRayTraceResult(this.func_213303_ch(), Direction.UP, this.func_180425_c(), true));
        }
        this.func_213317_d(this.func_213322_ci().func_216372_d((double)var18, (double)var18, (double)var18).func_72441_c(0.0, (double)(-var19), 0.0));
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected void func_70184_a(RayTraceResult result) {
        this.onThrowableCollision(result);
    }

    private void onThrowableCollision(RayTraceResult result) {
        if (!(this.func_85052_h() instanceof PlayerEntity) || (int)this.field_70163_u <= 0) {
            this.func_70106_y();
            return;
        }
        for (int i = 0; i < 32; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.field_70165_t, this.field_70163_u + this.field_70146_Z.nextDouble() * 2.0, this.field_70161_v, this.field_70146_Z.nextGaussian(), 0.0, this.field_70146_Z.nextGaussian());
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_85052_h().field_70143_R = 0.0f;
            int x = (int)Math.round(this.field_70165_t);
            int y = (int)Math.round(this.field_70163_u);
            int z = (int)Math.round(this.field_70161_v);
            if (result.func_216346_c() != RayTraceResult.Type.MISS) {
                BlockPos pos;
                if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    Entity entityHit = ((EntityRayTraceResult)result).func_216348_a();
                    entityHit.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), 0.0f);
                    pos = entityHit.func_180425_c();
                } else {
                    BlockRayTraceResult blockResult = (BlockRayTraceResult)result;
                    pos = blockResult.func_216350_a().func_177972_a(blockResult.func_216354_b());
                }
                y = pos.func_177956_o();
                x = pos.func_177958_n();
                z = pos.func_177952_p();
            }
            this.func_85052_h().func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            this.func_85052_h().func_70634_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f));
        }
        this.func_70106_y();
    }

    public ItemStack func_184543_l() {
        return new ItemStack((IItemProvider)Items.field_151079_bi);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

