/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.fluid.IFluidState;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import xreliquary.init.ModEntities;
import xreliquary.init.ModItems;
import xreliquary.reference.Settings;
import xreliquary.util.LogHelper;
import xreliquary.util.RandHelper;

public class LyssaBobberEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> DATA_HOOKED_ENTITY = EntityDataManager.func_187226_a(FishingBobberEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private boolean inGround;
    private int ticksInGround = 0;
    private PlayerEntity angler;
    private int ticksInAir;
    private int ticksCatchable;
    private int ticksCaughtDelay;
    private int ticksCatchableDelay;
    private float fishApproachAngle;
    private Entity caughtEntity;
    private State currentState = State.FLYING;
    private int lureSpeed;
    private int luck;
    private static final Field HANDS_CHANCES = ObfuscationReflectionHelper.findField(MobEntity.class, (String)"field_82174_bp");
    private static final Field ARMOR_CHANCES = ObfuscationReflectionHelper.findField(MobEntity.class, (String)"field_184655_bs");

    public LyssaBobberEntity(EntityType<LyssaBobberEntity> entityType, World world) {
        super(entityType, world);
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
    }

    public LyssaBobberEntity(World world, PlayerEntity fishingPlayer, int lureSpeed, int luck) {
        super(ModEntities.LYSSA_HOOK, world);
        this.lureSpeed = lureSpeed;
        this.luck = luck;
        this.init(fishingPlayer);
        this.shoot();
        this.speedUp();
    }

    private void init(PlayerEntity player) {
        this.field_70158_ak = true;
        this.angler = player;
    }

    private void shoot() {
        float f = this.angler.field_70125_A;
        float f1 = this.angler.field_70177_z;
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        double d0 = this.angler.field_70165_t - (double)f3 * 0.3;
        double d1 = this.angler.field_70163_u + (double)this.angler.func_70047_e();
        double d2 = this.angler.field_70161_v - (double)f2 * 0.3;
        this.func_70012_b(d0, d1, d2, f1, f);
        Vec3d vec3d = new Vec3d((double)(-f3), (double)MathHelper.func_76131_a((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f), (double)(-f2));
        double d3 = vec3d.func_72433_c();
        vec3d = vec3d.func_216372_d(0.6 / d3 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045, 0.6 / d3 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045, 0.6 / d3 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045);
        this.func_213317_d(vec3d);
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)MathHelper.func_76133_a((double)LyssaBobberEntity.func_213296_b((Vec3d)vec3d))) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(DATA_HOOKED_ENTITY, (Object)0);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (DATA_HOOKED_ENTITY.equals(key)) {
            int i = (Integer)this.func_184212_Q().func_187225_a(DATA_HOOKED_ENTITY);
            this.caughtEntity = i > 0 ? this.field_70170_p.func_73045_a(i - 1) : null;
        }
        super.func_184206_a(key);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    private void tickOriginal() {
        super.func_70071_h_();
        if (this.angler == null) {
            this.func_70106_y();
        } else if (this.field_70170_p.field_72995_K || !this.shouldStopFishing()) {
            if (this.inGround) {
                ++this.ticksInGround;
                if (this.ticksInGround >= 1200) {
                    this.func_70106_y();
                    return;
                }
            }
            float f = 0.0f;
            BlockPos blockpos = new BlockPos((Entity)this);
            IFluidState ifluidstate = this.field_70170_p.func_204610_c(blockpos);
            if (ifluidstate.func_206884_a(FluidTags.field_206959_a)) {
                f = ifluidstate.func_215679_a((IBlockReader)this.field_70170_p, blockpos);
            }
            if (this.currentState == State.FLYING) {
                if (this.caughtEntity != null) {
                    this.func_213317_d(Vec3d.field_186680_a);
                    this.currentState = State.HOOKED_IN_ENTITY;
                    return;
                }
                if (f > 0.0f) {
                    this.func_213317_d(this.func_213322_ci().func_216372_d(0.3, 0.2, 0.3));
                    this.currentState = State.BOBBING;
                    return;
                }
                if (!this.field_70170_p.field_72995_K) {
                    this.checkCollision();
                }
                if (!(this.inGround || this.field_70122_E || this.field_70123_F)) {
                    ++this.ticksInAir;
                } else {
                    this.ticksInAir = 0;
                    this.func_213317_d(Vec3d.field_186680_a);
                }
            } else {
                if (this.currentState == State.HOOKED_IN_ENTITY) {
                    if (this.caughtEntity != null) {
                        if (!this.caughtEntity.func_70089_S()) {
                            this.caughtEntity = null;
                            this.currentState = State.FLYING;
                        } else {
                            this.field_70165_t = this.caughtEntity.field_70165_t;
                            this.field_70163_u = this.caughtEntity.func_174813_aQ().field_72338_b + (double)this.caughtEntity.func_213302_cg() * 0.8;
                            this.field_70161_v = this.caughtEntity.field_70161_v;
                            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                        }
                    }
                    return;
                }
                if (this.currentState == State.BOBBING) {
                    Vec3d vec3d = this.func_213322_ci();
                    double d0 = this.field_70163_u + vec3d.field_72448_b - (double)blockpos.func_177956_o() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.func_213293_j(vec3d.field_72450_a * 0.9, vec3d.field_72448_b - d0 * (double)this.field_70146_Z.nextFloat() * 0.2, vec3d.field_72449_c * 0.9);
                    if (!this.field_70170_p.field_72995_K && f > 0.0f) {
                        this.catchingFish(blockpos);
                    }
                }
            }
            if (!ifluidstate.func_206884_a(FluidTags.field_206959_a)) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.03, 0.0));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.updateRotation();
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.92));
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    private void updateRotation() {
        Vec3d vec3d = this.func_213322_ci();
        float f = MathHelper.func_76133_a((double)LyssaBobberEntity.func_213296_b((Vec3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g((float)0.2f, (float)this.field_70127_C, (float)this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g((float)0.2f, (float)this.field_70126_B, (float)this.field_70177_z);
    }

    private void checkCollision() {
        RayTraceResult raytraceresult = ProjectileHelper.func_221267_a((Entity)this, (AxisAlignedBB)this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), e -> !(e.func_175149_v() || !e.func_70067_L() && !(e instanceof ItemEntity) || e == this.angler && this.ticksInAir < 5), (RayTraceContext.BlockMode)RayTraceContext.BlockMode.COLLIDER, (boolean)true);
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            if (raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                this.caughtEntity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
                this.setHookedEntity();
            } else {
                this.inGround = true;
            }
        }
    }

    private void setHookedEntity() {
        this.func_184212_Q().func_187227_b(DATA_HOOKED_ENTITY, (Object)(this.caughtEntity.func_145782_y() + 1));
    }

    private void catchingFish(BlockPos pos) {
        ServerWorld serverworld = (ServerWorld)this.field_70170_p;
        int i = 1;
        BlockPos blockpos = pos.func_177984_a();
        if (this.field_70146_Z.nextFloat() < 0.25f && this.field_70170_p.func_175727_C(blockpos)) {
            ++i;
        }
        if (this.field_70146_Z.nextFloat() < 0.5f && !this.field_70170_p.func_217337_f(blockpos)) {
            --i;
        }
        if (this.ticksCatchable > 0) {
            --this.ticksCatchable;
            if (this.ticksCatchable <= 0) {
                this.ticksCaughtDelay = 0;
                this.ticksCatchableDelay = 0;
            } else {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.2 * (double)this.field_70146_Z.nextFloat() * (double)this.field_70146_Z.nextFloat(), 0.0));
            }
        } else if (this.ticksCatchableDelay > 0) {
            this.ticksCatchableDelay -= i;
            if (this.ticksCatchableDelay > 0) {
                double d2;
                this.fishApproachAngle = (float)((double)this.fishApproachAngle + this.field_70146_Z.nextGaussian() * 4.0);
                float f = this.fishApproachAngle * ((float)Math.PI / 180);
                float f1 = MathHelper.func_76126_a((float)f);
                float f2 = MathHelper.func_76134_b((float)f);
                double d0 = this.field_70165_t + (double)(f1 * (float)this.ticksCatchableDelay * 0.1f);
                double d1 = (float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f;
                if (serverworld.func_180495_p(new BlockPos((int)d0, (int)d1 - 1, (int)(d2 = this.field_70161_v + (double)(f2 * (float)this.ticksCatchableDelay * 0.1f)))).func_185904_a() == Material.field_151586_h) {
                    if (this.field_70146_Z.nextFloat() < 0.15f) {
                        serverworld.func_195598_a((IParticleData)ParticleTypes.field_197612_e, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    serverworld.func_195598_a((IParticleData)ParticleTypes.field_197630_w, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    serverworld.func_195598_a((IParticleData)ParticleTypes.field_197630_w, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                }
            } else {
                Vec3d vec3d = this.func_213322_ci();
                this.func_213293_j(vec3d.field_72450_a, -0.4f * MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.6f, (float)1.0f), vec3d.field_72449_c);
                this.func_184185_a(SoundEvents.field_187609_F, 0.25f, 1.0f + RandHelper.getRandomMinusOneToOne(this.field_70146_Z) * 0.4f);
                double d3 = this.func_174813_aQ().field_72338_b + 0.5;
                serverworld.func_195598_a((IParticleData)ParticleTypes.field_197612_e, this.field_70165_t, d3, this.field_70161_v, (int)(1.0f + this.func_213311_cf() * 20.0f), (double)this.func_213311_cf(), 0.0, (double)this.func_213311_cf(), (double)0.2f);
                serverworld.func_195598_a((IParticleData)ParticleTypes.field_197630_w, this.field_70165_t, d3, this.field_70161_v, (int)(1.0f + this.func_213311_cf() * 20.0f), (double)this.func_213311_cf(), 0.0, (double)this.func_213311_cf(), (double)0.2f);
                this.ticksCatchable = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)40);
            }
        } else if (this.ticksCaughtDelay > 0) {
            this.ticksCaughtDelay -= i;
            float f5 = 0.15f;
            if (this.ticksCaughtDelay < 20) {
                f5 = (float)((double)f5 + (double)(20 - this.ticksCaughtDelay) * 0.05);
            } else if (this.ticksCaughtDelay < 40) {
                f5 = (float)((double)f5 + (double)(40 - this.ticksCaughtDelay) * 0.02);
            } else if (this.ticksCaughtDelay < 60) {
                f5 = (float)((double)f5 + (double)(60 - this.ticksCaughtDelay) * 0.01);
            }
            if (this.field_70146_Z.nextFloat() < f5) {
                double d6;
                double d5;
                float f6 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)25.0f, (float)60.0f);
                double d4 = this.field_70165_t + (double)(MathHelper.func_76126_a((float)f6) * f7 * 0.1f);
                if (serverworld.func_180495_p(new BlockPos(d4, (d5 = (double)((float)MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) + 1.0f)) - 1.0, d6 = this.field_70161_v + (double)(MathHelper.func_76134_b((float)f6) * f7 * 0.1f))).func_185904_a() == Material.field_151586_h) {
                    serverworld.func_195598_a((IParticleData)ParticleTypes.field_218422_X, d4, d5, d6, 2 + this.field_70146_Z.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.ticksCaughtDelay <= 0) {
                this.fishApproachAngle = MathHelper.func_151240_a((Random)this.field_70146_Z, (float)0.0f, (float)360.0f);
                this.ticksCatchableDelay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)20, (int)80);
            }
        } else {
            this.ticksCaughtDelay = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)100, (int)600);
            this.ticksCaughtDelay -= this.lureSpeed * 20 * 5;
        }
    }

    public void func_213281_b(CompoundNBT compound) {
    }

    public void func_70037_a(CompoundNBT compound) {
    }

    private int handleHookRetractionOriginal(ItemStack stack) {
        if (!this.field_70170_p.field_72995_K && this.angler != null) {
            int i = 0;
            if (this.caughtEntity != null) {
                this.bringInHookedEntity();
                this.field_70170_p.func_72960_a((Entity)this, (byte)31);
                i = this.caughtEntity instanceof ItemEntity ? 3 : 5;
            } else if (this.ticksCatchable > 0) {
                LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216015_a(LootParameters.field_216286_f, (Object)new BlockPos((Entity)this)).func_216015_a(LootParameters.field_216289_i, (Object)stack).func_216023_a(this.field_70146_Z).func_186469_a((float)this.luck + this.angler.func_184817_da());
                builder.func_216015_a(LootParameters.field_216284_d, (Object)this.angler).func_216015_a(LootParameters.field_216281_a, (Object)this);
                LootTable loottable = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(LootTables.field_186387_al);
                List list = loottable.func_216113_a(builder.func_216022_a(LootParameterSets.field_216262_c));
                for (ItemStack itemstack : list) {
                    ItemEntity itementity = new ItemEntity(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, itemstack);
                    double d0 = this.angler.field_70165_t - this.field_70165_t;
                    double d1 = this.angler.field_70163_u - this.field_70163_u;
                    double d2 = this.angler.field_70161_v - this.field_70161_v;
                    itementity.func_213293_j(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                    this.field_70170_p.func_217376_c((Entity)itementity);
                    this.angler.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.angler.field_70170_p, this.angler.field_70165_t, this.angler.field_70163_u + 0.5, this.angler.field_70161_v + 0.5, this.field_70146_Z.nextInt(6) + 1));
                    if (!itemstack.func_77973_b().func_206844_a(ItemTags.field_206964_G)) continue;
                    this.angler.func_195067_a(Stats.field_188071_E, 1);
                }
                i = 1;
            }
            if (this.inGround) {
                i = 2;
            }
            this.func_70106_y();
            return i;
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 31 && this.field_70170_p.field_72995_K && this.caughtEntity instanceof PlayerEntity && ((PlayerEntity)this.caughtEntity).func_175144_cb()) {
            this.bringInHookedEntity();
        }
        super.func_70103_a(id);
    }

    private void bringInHookedEntityOriginal() {
        if (this.angler != null) {
            Vec3d vec3d = new Vec3d(this.angler.field_70165_t - this.field_70165_t, this.angler.field_70163_u - this.field_70163_u, this.angler.field_70161_v - this.field_70161_v).func_186678_a(0.1);
            this.caughtEntity.func_213317_d(this.caughtEntity.func_213322_ci().func_178787_e(vec3d));
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void remove(boolean keepData) {
        super.remove(keepData);
        if (this.angler != null) {
            this.angler.field_71104_cf = null;
        }
    }

    public PlayerEntity getAngler() {
        return this.angler;
    }

    private void speedUp() {
        if (this.func_213322_ci().func_82617_b() >= 0.0) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(2.0, 2.0, 2.0));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 16384.0;
    }

    public void func_70071_h_() {
        this.tickOriginal();
        this.pullItemEntitiesTowardsHook();
    }

    private boolean shouldStopFishing() {
        boolean flag1;
        ItemStack itemstack = this.angler.func_184614_ca();
        ItemStack itemstack1 = this.angler.func_184592_cb();
        boolean flag = itemstack.func_77973_b() == ModItems.ROD_OF_LYSSA;
        boolean bl = flag1 = itemstack1.func_77973_b() == ModItems.ROD_OF_LYSSA;
        if (this.angler.func_70089_S() && (flag || flag1) && this.func_70068_e((Entity)this.angler) <= 1024.0) {
            return false;
        }
        this.func_70106_y();
        return true;
    }

    private void pullItemEntitiesTowardsHook() {
        if (this.func_70089_S() && this.caughtEntity == null) {
            float f = 0.0f;
            BlockPos blockpos = new BlockPos((Entity)this);
            IFluidState ifluidstate = this.field_70170_p.func_204610_c(blockpos);
            if (ifluidstate.func_206884_a(FluidTags.field_206959_a)) {
                f = ifluidstate.func_215679_a((IBlockReader)this.field_70170_p, blockpos);
            }
            if (f <= 0.0f) {
                List list = this.field_70170_p.func_217357_a(ItemEntity.class, this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(3.0));
                for (Entity e : list) {
                    Vec3d pullVector = new Vec3d(this.field_70165_t - e.field_70165_t, this.field_70163_u - e.field_70163_u, this.field_70161_v - e.field_70161_v).func_72432_b();
                    e.func_213317_d(pullVector.func_216372_d(0.4, 0.4, 0.4));
                }
            }
        }
    }

    private void bringInHookedEntity() {
        this.bringInHookedEntityOriginal();
        if (this.caughtEntity instanceof ItemEntity) {
            this.caughtEntity.func_213317_d(this.caughtEntity.func_213322_ci().func_216372_d(4.0, 4.0, 4.0));
        } else if (this.caughtEntity instanceof LivingEntity) {
            this.caughtEntity.func_213317_d(this.caughtEntity.func_213322_ci().func_216372_d(1.0, 1.5, 1.0));
        }
    }

    public void handleHookRetraction(ItemStack stack) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.caughtEntity != null && this.getAngler().func_70093_af() && this.canStealFromEntity()) {
                this.stealFromLivingEntity();
                this.func_70106_y();
            } else {
                this.handleHookRetractionOriginal(stack);
            }
            this.pullItemEntitiesWithHook();
        }
    }

    private boolean canStealFromEntity() {
        return this.caughtEntity instanceof LivingEntity && ((Boolean)Settings.COMMON.items.rodOfLyssa.stealFromPlayers.get() != false || !(this.caughtEntity instanceof PlayerEntity));
    }

    private void pullItemEntitiesWithHook() {
        List pullingItemsList = this.field_70170_p.func_217357_a(ItemEntity.class, this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_72314_b(1.0, 1.0, 1.0));
        for (ItemEntity e : pullingItemsList) {
            double d1 = this.getAngler().field_70165_t - this.field_70165_t;
            double d3 = this.getAngler().field_70163_u - this.field_70163_u;
            double d5 = this.getAngler().field_70161_v - this.field_70161_v;
            double d7 = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3 + d5 * d5));
            double d9 = 0.1;
            e.func_213293_j(d1 * d9, d3 * d9 + (double)MathHelper.func_76133_a((double)d7) * 0.08, d5 * d9);
        }
    }

    private void stealFromLivingEntity() {
        LivingEntity livingEntity = (LivingEntity)this.caughtEntity;
        EquipmentSlotType slotBeingStolenFrom = EquipmentSlotType.values()[this.field_70170_p.field_73012_v.nextInt(EquipmentSlotType.values().length)];
        ItemStack stolenStack = livingEntity.func_184582_a(slotBeingStolenFrom);
        if (stolenStack.func_190926_b() && Boolean.TRUE.equals(Settings.COMMON.items.rodOfLyssa.stealFromVacantSlots.get())) {
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                stolenStack = livingEntity.func_184582_a(slot);
                if (stolenStack.func_190926_b() || !this.canDropFromSlot(livingEntity, slot)) continue;
                slotBeingStolenFrom = slot;
                break;
            }
        }
        float failProbabilityFactor = Boolean.TRUE.equals(Settings.COMMON.items.rodOfLyssa.useLeveledFailureRate.get()) ? 1.0f / ((float)Math.sqrt(Math.max(1, Math.min(this.getAngler().field_71068_ca, (Integer)Settings.COMMON.items.rodOfLyssa.levelCapForLeveledFormula.get()))) * 2.0f) : (float)((Integer)Settings.COMMON.items.rodOfLyssa.flatStealFailurePercentRate.get()).intValue() / 100.0f;
        if ((this.field_70146_Z.nextFloat() <= failProbabilityFactor || stolenStack.func_190926_b() && ((Boolean)Settings.COMMON.items.rodOfLyssa.failStealFromVacantSlots.get()).booleanValue()) && Boolean.TRUE.equals(Settings.COMMON.items.rodOfLyssa.angerOnStealFailure.get())) {
            livingEntity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)this.getAngler()), 0.0f);
        }
        if (!stolenStack.func_190926_b()) {
            int randomItemDamage = this.field_70170_p.field_73012_v.nextInt(3);
            stolenStack.func_222118_a(randomItemDamage, livingEntity, e -> {});
            ItemEntity entityitem = new ItemEntity(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, stolenStack);
            entityitem.func_174867_a(5);
            double d1 = this.getAngler().field_70165_t - this.field_70165_t;
            double d3 = this.getAngler().field_70163_u - this.field_70163_u;
            double d5 = this.getAngler().field_70161_v - this.field_70161_v;
            double d7 = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3 + d5 * d5));
            double d9 = 0.1;
            entityitem.func_213293_j(d1 * d9, d3 * d9 + (double)MathHelper.func_76133_a((double)d7) * 0.08, d5 * d9);
            this.field_70170_p.func_217376_c((Entity)entityitem);
            livingEntity.func_184201_a(slotBeingStolenFrom, ItemStack.field_190927_a);
        }
    }

    private boolean canDropFromSlot(LivingEntity entity, EquipmentSlotType slot) {
        if (!(entity instanceof MobEntity)) {
            return true;
        }
        MobEntity livingEntity = (MobEntity)entity;
        try {
            if (slot.func_188453_a() == EquipmentSlotType.Group.HAND) {
                return ((float[])HANDS_CHANCES.get(livingEntity))[slot.func_188454_b()] > -1.0f;
            }
            return ((float[])ARMOR_CHANCES.get(livingEntity))[slot.func_188454_b()] > -1.0f;
        }
        catch (IllegalAccessException e) {
            LogHelper.error(e);
            return false;
        }
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.angler.func_145782_y());
    }

    public void readSpawnData(PacketBuffer additionalData) {
        Entity entity = this.field_70170_p.func_73045_a(additionalData.readInt());
        if (entity instanceof PlayerEntity) {
            this.angler = (PlayerEntity)entity;
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }
}

