/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities;

import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import xreliquary.init.ModEntities;
import xreliquary.reference.Settings;
import xreliquary.util.RandHelper;

public class SpecialSnowballEntity
extends ProjectileItemEntity {
    private int ticksInAir;
    private boolean fromGlacialStaff;

    public SpecialSnowballEntity(EntityType<SpecialSnowballEntity> entityType, World world) {
        super(entityType, world);
    }

    public SpecialSnowballEntity(World world, LivingEntity entity, boolean b) {
        super(ModEntities.SPECIAL_SNOWBALL, entity, world);
        this.fromGlacialStaff = b;
    }

    private int getSnowballDamage() {
        return this.fromGlacialStaff ? ((Integer)Settings.COMMON.items.glacialStaff.snowballDamage.get()).intValue() : ((Integer)Settings.COMMON.items.iceMagusRod.snowballDamage.get()).intValue();
    }

    private int getSnowballDamageFireImmuneBonus() {
        return this.fromGlacialStaff ? ((Integer)Settings.COMMON.items.glacialStaff.snowballDamageBonusFireImmune.get()).intValue() : ((Integer)Settings.COMMON.items.iceMagusRod.snowballDamageBonusFireImmune.get()).intValue();
    }

    private int getSnowballDamageBlazeBonus() {
        return this.fromGlacialStaff ? ((Integer)Settings.COMMON.items.glacialStaff.snowballDamageBonusBlaze.get()).intValue() : ((Integer)Settings.COMMON.items.iceMagusRod.snowballDamageBonusBlaze.get()).intValue();
    }

    protected void func_70184_a(RayTraceResult result) {
        for (int var3 = 0; var3 < 8; ++var3) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197593_D, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K) {
            BlockPos pos;
            if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                Entity entityHit = ((EntityRayTraceResult)result).func_216348_a();
                int damage = this.getSnowballDamage();
                if (entityHit.func_70045_F()) {
                    damage += this.getSnowballDamageFireImmuneBonus();
                }
                if (entityHit instanceof BlazeEntity) {
                    damage += this.getSnowballDamageBlazeBonus();
                }
                entityHit.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), (float)damage);
            } else if (result.func_216346_c() == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p((pos = ((BlockRayTraceResult)result).func_216350_a()).func_177984_a()).func_177230_c() == Blocks.field_150480_ab) {
                this.field_70170_p.func_184133_a(null, pos.func_177984_a(), SoundEvents.field_187658_bx, SoundCategory.NEUTRAL, 0.5f, RandHelper.getRandomMinusOneToOne(this.field_70170_p.field_73012_v) * 0.8f);
                this.field_70170_p.func_175656_a(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()), Blocks.field_150350_a.func_176223_P());
            }
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        this.ticksInAir = this.field_174854_a ? 0 : ++this.ticksInAir;
        super.func_70071_h_();
        if (this.ticksInAir % 4 == this.field_70170_p.field_73012_v.nextInt(5)) {
            this.field_70170_p.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, this.field_70165_t, this.field_70163_u, this.field_70161_v, 5.0, 5.0, 1.0);
        }
    }

    protected float func_70185_h() {
        return 0.01f;
    }

    protected Item func_213885_i() {
        return Items.field_151126_ay;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 3) {
            ItemStack stack = this.func_213882_k();
            BasicParticleType particleData = stack.func_190926_b() ? ParticleTypes.field_197593_D : new ItemParticleData(ParticleTypes.field_197591_B, stack);
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)particleData, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
            }
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = 4.0;
        return distance < (d0 *= 64.0) * d0;
    }
}

