/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities.potion;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;
import xreliquary.network.PacketFXThrownPotionImpact;
import xreliquary.network.PacketHandler;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public abstract class ThrownPotionEntity
extends ThrowableEntity
implements IRendersAsItem {
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(ThrownPotionEntity.class, (IDataSerializer)DataSerializers.field_187196_f);

    <T extends ThrownPotionEntity> ThrownPotionEntity(EntityType<T> entityType, World world, ItemStack thrownStack) {
        super(entityType, world);
        this.setItem(thrownStack);
    }

    <T extends ThrownPotionEntity> ThrownPotionEntity(EntityType<T> entityType, World world, PlayerEntity player, ItemStack thrownStack) {
        super(entityType, (LivingEntity)player, world);
        this.setItem(thrownStack);
    }

    <T extends ThrownPotionEntity> ThrownPotionEntity(EntityType<T> entityType, World world, double x, double y, double z, ItemStack thrownStack) {
        super(entityType, x, y, z, world);
        this.setItem(thrownStack);
    }

    private void setItem(ItemStack thrownStack) {
        this.field_70180_af.func_187227_b(ITEM, (Object)thrownStack);
    }

    protected float func_70185_h() {
        return 0.05f;
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            this.spawnParticles();
            this.doSplashEffect();
            this.func_70106_y();
        }
    }

    abstract boolean hasLivingEntityEffect();

    private void doSplashEffect() {
        this.doGroundSplashEffect();
        if (!this.hasLivingEntityEffect()) {
            return;
        }
        AxisAlignedBB bb = this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
        List eList = this.field_70170_p.func_217357_a(LivingEntity.class, bb);
        eList.forEach(this::doLivingSplashEffect);
    }

    abstract void doGroundSplashEffect();

    private void spawnParticles() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        Random rand = this.field_70146_Z;
        for (int i = 0; i < 8; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, this.func_184543_l()), this.field_70165_t, this.field_70163_u, this.field_70161_v, rand.nextGaussian() * 0.15, rand.nextDouble() * 0.2, rand.nextGaussian() * 0.15);
        }
        this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundEvents.field_187561_bM, SoundCategory.BLOCKS, 1.0f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
        PacketHandler.sendToAllAround(new PacketFXThrownPotionImpact(this.getColor(), this.field_70165_t, this.field_70163_u, this.field_70161_v), new PacketDistributor.TargetPoint(this.field_70165_t, this.field_70163_u, this.field_70161_v, 32.0, this.field_70170_p.func_201675_m().func_186058_p()));
    }

    abstract void doLivingSplashEffect(LivingEntity var1);

    abstract int getColor();

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
    }

    public ItemStack func_184543_l() {
        ItemStack stack = (ItemStack)this.func_184212_Q().func_187225_a(ITEM);
        if (stack.func_77973_b() != Items.field_185155_bH && stack.func_77973_b() != Items.field_185156_bI) {
            if (this.field_70170_p != null) {
                field_184243_a.error("EntityThrownPotion entity {} has no item?!", (Object)this.func_145782_y());
            }
            return new ItemStack((IItemProvider)Items.field_185155_bH);
        }
        return stack;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

