/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities.shot;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import xreliquary.entities.shot.ShotEntityBase;
import xreliquary.init.ModEntities;
import xreliquary.reference.ClientReference;

public class EnderShotEntity
extends ShotEntityBase {
    public EnderShotEntity(EntityType<EnderShotEntity> entityType, World world) {
        super(entityType, world);
    }

    public EnderShotEntity(World world, PlayerEntity player, Hand hand) {
        super(ModEntities.ENDER_SHOT, world, player, hand);
    }

    private void doPortalExplosion() {
        for (int particles = 0; particles < 3; ++particles) {
            this.spawnMotionBasedParticle((IParticleData)ParticleTypes.field_197599_J, this.field_70163_u - 1.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
        }
        this.func_70106_y();
    }

    @Override
    void doBurstEffect(Direction sideHit) {
    }

    @Override
    void doFiringEffects() {
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197608_a, this.field_70165_t + this.smallGauss(0.1), this.field_70163_u + this.smallGauss(0.1), this.field_70161_v + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        this.spawnMotionBasedParticle((IParticleData)ParticleTypes.field_197631_x);
    }

    @Override
    protected void onImpact(RayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity entityHit = ((EntityRayTraceResult)result).func_216348_a();
            if (entityHit == this.shootingEntity || !(entityHit instanceof LivingEntity)) {
                return;
            }
            this.onImpact((LivingEntity)entityHit);
        }
    }

    @Override
    protected void onImpact(LivingEntity mop) {
        if (mop != this.shootingEntity || this.ticksInAir > 3) {
            this.doDamage(mop);
        }
        this.spawnHitParticles(8);
    }

    @Override
    protected void groundImpact(Direction sideHit) {
    }

    @Override
    void doFlightEffects() {
        if (this.ticksInAir % 3 == 0) {
            this.spawnMotionBasedParticle((IParticleData)ParticleTypes.field_197599_J, this.field_70163_u - 1.0);
        }
        this.seekTarget();
        if (this.ticksInAir > 100) {
            this.doPortalExplosion();
        }
    }

    @Override
    void spawnHitParticles(int i) {
        for (int particles = 0; particles < i; ++particles) {
            this.spawnMotionBasedParticle((IParticleData)ParticleTypes.field_197607_R);
        }
    }

    @Override
    int getRicochetMax() {
        return 0;
    }

    @Override
    int getDamageOfShot(LivingEntity mop) {
        return 16 + this.d12();
    }

    @Override
    public ResourceLocation getShotTexture() {
        return ClientReference.ENDER;
    }
}

