/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities.shot;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import xreliquary.entities.shot.ShotEntityBase;
import xreliquary.init.ModEntities;
import xreliquary.reference.ClientReference;

public class SeekerShotEntity
extends ShotEntityBase {
    public SeekerShotEntity(EntityType<SeekerShotEntity> entityType, World world) {
        super(entityType, world);
    }

    public SeekerShotEntity(World world, PlayerEntity player, Hand hand) {
        super(ModEntities.SEEKER_SHOT, world, player, hand);
    }

    @Override
    void doFlightEffects() {
        if (this.ticksInAir % 3 == 0) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197608_a, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, this.gaussian(1.0), this.gaussian(1.0));
        }
        this.seekTarget();
    }

    @Override
    void doFiringEffects() {
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197608_a, this.field_70165_t + this.smallGauss(0.1), this.field_70163_u + this.smallGauss(0.1), this.field_70161_v + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        this.spawnMotionBasedParticle((IParticleData)ParticleTypes.field_197631_x);
    }

    @Override
    void doBurstEffect(Direction sideHit) {
    }

    @Override
    void spawnHitParticles(int i) {
        for (int particles = 0; particles < i; ++particles) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197608_a, this.field_70165_t + this.smallGauss(0.1), this.field_70163_u + this.smallGauss(0.1), this.field_70161_v + this.smallGauss(0.1), (double)0.1f, 1.0, 1.0);
        }
    }

    @Override
    int getRicochetMax() {
        return 3;
    }

    @Override
    int getDamageOfShot(LivingEntity mop) {
        return 10 + this.d12();
    }

    @Override
    public ResourceLocation getShotTexture() {
        return ClientReference.SEEKER;
    }
}

