/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.entities.shot;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import xreliquary.reference.Settings;
import xreliquary.util.potions.XRPotionHelper;

public abstract class ShotEntityBase
extends Entity
implements IProjectile {
    private static final DataParameter<Byte> CRITICAL = EntityDataManager.func_187226_a(ShotEntityBase.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(ShotEntityBase.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private boolean inGround = false;
    private List<EffectInstance> potionEffects = Collections.emptyList();
    PlayerEntity shootingEntity;
    protected int ticksInAir = 0;
    private int ricochetCounter = 0;
    private boolean scheduledForDeath = false;

    public <T extends ShotEntityBase> ShotEntityBase(EntityType<T> entityType, World world) {
        super(entityType, world);
    }

    public <T extends ShotEntityBase> ShotEntityBase(EntityType<T> entityType, World world, double x, double y, double z) {
        this(entityType, world);
        this.func_70107_b(x, y, z);
    }

    public <T extends ShotEntityBase> ShotEntityBase(EntityType<T> entityType, World world, PlayerEntity player, Hand hand) {
        this(entityType, world);
        this.shootingEntity = player;
        this.func_70012_b(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v, player.field_70177_z, player.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * (float)(hand == Hand.MAIN_HAND ? 1 : -1) * 0.16f);
        this.field_70163_u -= 0.2;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * (float)(hand == Hand.MAIN_HAND ? 1 : -1) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(CRITICAL, (Object)0);
        this.field_70180_af.func_187214_a(COLOR, (Object)0);
    }

    public ShotEntityBase addPotionEffects(List<EffectInstance> effects) {
        if (!effects.isEmpty()) {
            this.potionEffects = effects;
            this.field_70180_af.func_187227_b(COLOR, (Object)PotionUtils.func_185181_a(effects));
        }
        return this;
    }

    public void func_70186_c(double motionX, double motionY, double motionZ, float velocity, float inaccuracy) {
        float var9 = MathHelper.func_76133_a((double)(motionX * motionX + motionY * motionY + motionZ * motionZ));
        motionX /= (double)var9;
        motionY /= (double)var9;
        motionZ /= (double)var9;
        motionX += this.field_70146_Z.nextGaussian() * 0.0075 * (double)inaccuracy;
        motionY += this.field_70146_Z.nextGaussian() * 0.0075 * (double)inaccuracy;
        motionZ += this.field_70146_Z.nextGaussian() * 0.0075 * (double)inaccuracy;
        this.func_213293_j(motionX *= (double)velocity, motionY *= (double)velocity, motionZ *= (double)velocity);
        float var10 = MathHelper.func_76133_a((double)(motionX * motionX + motionZ * motionZ));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(motionX, motionZ) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(motionY, var10) * 180.0 / Math.PI);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70016_h(double motionX, double motionY, double motionZ) {
        this.func_213293_j(motionX, motionY, motionZ);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float var7 = MathHelper.func_76133_a((double)(motionX * motionX + motionZ * motionZ));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(motionX, motionZ) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(motionY, var7) * 180.0 / Math.PI);
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_70071_h_() {
        BlockPos pos;
        VoxelShape voxelshape;
        BlockState blockState;
        Block block;
        super.func_70071_h_();
        if (this.ticksInAir > 200) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K) {
            this.spawnPotionParticles();
        }
        Vec3d motionVec = this.func_213322_ci();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float pythingy = MathHelper.func_76133_a((double)(motionVec.func_82615_a() * motionVec.func_82615_a() + motionVec.func_82616_c() * motionVec.func_82616_c()));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(motionVec.func_82615_a(), motionVec.func_82616_c()) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(motionVec.func_82617_b(), pythingy) * 180.0 / Math.PI);
        }
        if ((block = (blockState = this.field_70170_p.func_180495_p(new BlockPos(this.xTile, this.yTile, this.zTile))).func_177230_c()) != Blocks.field_150350_a && !(voxelshape = blockState.func_196952_d((IBlockReader)this.field_70170_p, pos = new BlockPos(this.xTile, this.yTile, this.zTile))).func_197766_b()) {
            for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(pos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) continue;
                this.inGround = true;
                break;
            }
        }
        if (!this.inGround) {
            ++this.ticksInAir;
            if (this.ticksInAir == 2) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.field_70165_t + this.smallGauss(0.1), this.field_70163_u + this.smallGauss(0.1), this.field_70161_v + this.smallGauss(0.1), 0.0, 0.0, 0.0);
                for (int particles = 0; particles < 3; ++particles) {
                    this.doFiringEffects();
                }
            } else {
                this.doFlightEffects();
            }
            Vec3d posVector = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d approachVector = new Vec3d(this.field_70165_t + motionVec.func_82615_a(), this.field_70163_u + motionVec.func_82617_b(), this.field_70161_v + motionVec.func_82616_c());
            BlockRayTraceResult objectStruckByVector = this.field_70170_p.func_217299_a(new RayTraceContext(posVector, approachVector, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
            Entity hitEntity = null;
            List struckEntitiesInAABB = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_216361_a(motionVec).func_72314_b(1.0, 1.0, 1.0));
            double var7 = 0.0;
            for (Entity struckEntity : struckEntitiesInAABB) {
                double var14;
                if (!struckEntity.func_70067_L() || struckEntity == this.shootingEntity && this.ticksInAir < 5) continue;
                float var11 = 0.5f;
                AxisAlignedBB var12 = struckEntity.func_174813_aQ().func_72314_b((double)var11, (double)var11, (double)var11);
                Optional hitResult = var12.func_216365_b(posVector, approachVector);
                if (!hitResult.isPresent() || !((var14 = posVector.func_72438_d((Vec3d)hitResult.get())) < var7) && var7 != 0.0) continue;
                hitEntity = struckEntity;
                var7 = var14;
            }
            if (hitEntity != null) {
                objectStruckByVector = new EntityRayTraceResult(hitEntity);
            }
            if (objectStruckByVector != null) {
                this.applyPotionEffects((RayTraceResult)objectStruckByVector);
                this.onImpact((RayTraceResult)objectStruckByVector);
            }
            if (this.scheduledForDeath) {
                this.func_70106_y();
            }
            Vec3d newPos = this.func_213303_ch().func_178787_e(this.func_213322_ci());
            this.func_70107_b(newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c);
        }
    }

    private void spawnPotionParticles() {
        int color = this.getColor();
        if (color != 0) {
            double d0 = (double)(color >> 16 & 0xFF) / 255.0;
            double d1 = (double)(color >> 8 & 0xFF) / 255.0;
            double d2 = (double)(color & 0xFF) / 255.0;
            for (int j = 0; j < 2; ++j) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg(), this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf(), d0, d1, d2);
            }
        }
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    private void applyPotionEffects(RayTraceResult objectStruckByVector) {
        EntityRayTraceResult entityStruckResult;
        if (objectStruckByVector.func_216346_c() == RayTraceResult.Type.ENTITY && (entityStruckResult = (EntityRayTraceResult)objectStruckByVector).func_216348_a() instanceof LivingEntity && this.potionEffects != null && !this.potionEffects.isEmpty()) {
            LivingEntity living = (LivingEntity)entityStruckResult.func_216348_a();
            XRPotionHelper.applyEffectsToEntity(this.potionEffects, this, (Entity)this.shootingEntity, living);
        }
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.xTile = compound.func_74765_d("xTile");
        this.yTile = compound.func_74765_d("yTile");
        this.zTile = compound.func_74765_d("zTile");
        this.inGround = compound.func_74771_c("inGround") == 1;
        this.potionEffects = XRPotionHelper.getPotionEffectsFromCompoundTag(compound);
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74777_a("xTile", (short)this.xTile);
        compound.func_74777_a("yTile", (short)this.yTile);
        compound.func_74777_a("zTile", (short)this.zTile);
        compound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        XRPotionHelper.addPotionEffectsToCompoundTag(compound, this.potionEffects);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = 64.0;
        return distance < d0 * d0;
    }

    public boolean func_70075_an() {
        return false;
    }

    int d3() {
        return this.field_70146_Z.nextInt(3) + 1;
    }

    int d6() {
        return this.field_70146_Z.nextInt(6) + 1;
    }

    int d12() {
        return this.field_70146_Z.nextInt(12) + 1;
    }

    void doDamage(LivingEntity e) {
        e.func_70097_a(this.getDamageSource(), (e instanceof PlayerEntity ? 0.5f : 1.0f) * this.adjustDamageForPotionShots(this.getDamageOfShot(e)));
    }

    private float adjustDamageForPotionShots(int damageOfShot) {
        return this.potionEffects != null && !this.potionEffects.isEmpty() ? 4.0f : (float)damageOfShot;
    }

    protected void spawnMotionBasedParticle(IParticleData particleData) {
        this.spawnMotionBasedParticle(particleData, this.field_70163_u);
    }

    protected void spawnMotionBasedParticle(IParticleData particleData, double y) {
        Vec3d motion = this.func_213322_ci();
        this.field_70170_p.func_195594_a(particleData, this.field_70165_t, y, this.field_70161_v, this.gaussian(motion.func_82615_a()), this.gaussian(motion.func_82617_b()), this.gaussian(motion.func_82616_c()));
    }

    protected DamageSource getDamageSource() {
        return DamageSource.func_76365_a((PlayerEntity)this.shootingEntity);
    }

    protected void groundImpact(Direction sideHit) {
        this.ricochet(sideHit);
    }

    protected double smallGauss(double d) {
        return ((double)this.field_70170_p.field_73012_v.nextFloat() - 0.5) * d;
    }

    double posGauss(double d) {
        return (double)this.field_70146_Z.nextFloat() * 0.5 * d;
    }

    double gaussian(double d) {
        return d + d * (((double)this.field_70146_Z.nextFloat() - 0.5) / 4.0);
    }

    double lowGauss(double d) {
        return d - d * ((double)(this.field_70146_Z.nextFloat() / 4.0f) + 0.5);
    }

    private void ricochet(Direction sideHit) {
        switch (sideHit) {
            case DOWN: 
            case UP: {
                this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, -1.0, 1.0));
                break;
            }
            case WEST: 
            case EAST: {
                this.func_213317_d(this.func_213322_ci().func_216372_d(-1.0, 1.0, 1.0));
                break;
            }
            case SOUTH: 
            case NORTH: {
                this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 1.0, -1.0));
            }
        }
        ++this.ricochetCounter;
        if (this.ricochetCounter > this.getRicochetMax()) {
            this.doBurstEffect(sideHit);
            this.scheduledForDeath = true;
            block13: for (int particles = 0; particles < 4; ++particles) {
                switch (sideHit) {
                    case DOWN: {
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.gaussian(0.1), -this.gaussian(0.1), this.gaussian(0.1));
                        continue block13;
                    }
                    case UP: {
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.gaussian(0.1), this.gaussian(0.1), this.gaussian(0.1));
                        continue block13;
                    }
                    case NORTH: {
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.gaussian(0.1), this.gaussian(0.1), -this.gaussian(0.1));
                        continue block13;
                    }
                    case SOUTH: {
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.gaussian(0.1), this.gaussian(0.1), this.gaussian(0.1));
                        continue block13;
                    }
                    case WEST: {
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.field_70165_t, this.field_70163_u, this.field_70161_v, -this.gaussian(0.1), this.gaussian(0.1), this.gaussian(0.1));
                        continue block13;
                    }
                    case EAST: {
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.gaussian(0.1), this.gaussian(0.1), this.gaussian(0.1));
                    }
                }
            }
        }
    }

    void seekTarget() {
        Entity closestTarget = null;
        List huntableEntitiesBlacklist = (List)Settings.COMMON.items.seekerShot.huntableEntitiesBlacklist.get();
        List targetsList = this.field_70170_p.func_175674_a((Entity)this, new AxisAlignedBB(this.field_70165_t - 5.0, this.field_70163_u - 5.0, this.field_70161_v - 5.0, this.field_70165_t + 5.0, this.field_70163_u + 5.0, this.field_70161_v + 5.0), e -> e instanceof MobEntity);
        Iterator iTarget = targetsList.iterator();
        double closestDistance = Double.MAX_VALUE;
        while (iTarget.hasNext()) {
            Entity currentTarget = (Entity)iTarget.next();
            String entityName = currentTarget.func_200600_R().getRegistryName().toString();
            if (huntableEntitiesBlacklist.contains(entityName) || currentTarget == this.shootingEntity || !currentTarget.func_70089_S() || currentTarget instanceof LivingEntity && ((LivingEntity)currentTarget).func_110143_aJ() <= 0.0f || !((double)this.func_70032_d(currentTarget) < closestDistance)) continue;
            closestDistance = this.func_70032_d(currentTarget);
            closestTarget = currentTarget;
        }
        if (closestTarget != null && this.shootingEntity != null) {
            double x = closestTarget.func_174813_aQ().field_72340_a + closestTarget.func_174813_aQ().field_72336_d;
            x /= 2.0;
            double y = closestTarget.func_174813_aQ().field_72338_b + Math.max(closestTarget.func_70033_W(), (double)closestTarget.func_213302_cg());
            double z = closestTarget.func_174813_aQ().field_72339_c + closestTarget.func_174813_aQ().field_72334_f;
            double trueX = this.func_174813_aQ().field_72340_a + this.func_174813_aQ().field_72336_d;
            double trueY = this.func_174813_aQ().field_72338_b + this.func_70033_W();
            double trueZ = this.func_174813_aQ().field_72339_c + this.func_174813_aQ().field_72334_f;
            Vec3d seekVector = new Vec3d(x - (trueX /= 2.0), (y -= (double)closestTarget.func_213302_cg() / 2.0) - (trueY -= (double)this.func_213302_cg() / 2.0), (z /= 2.0) - (trueZ /= 2.0));
            seekVector = seekVector.func_72432_b();
            this.func_213317_d(seekVector.func_216372_d(0.4, 0.4, 0.4));
            if (this.field_70170_p.field_72995_K) {
                this.func_70016_h(this.func_213322_ci().func_82615_a(), this.func_213322_ci().func_82617_b(), this.func_213322_ci().func_82616_c());
            }
        }
    }

    abstract int getRicochetMax();

    abstract int getDamageOfShot(LivingEntity var1);

    protected void onImpact(LivingEntity entityLiving) {
        if (!this.field_70170_p.field_72995_K) {
            if (entityLiving != this.shootingEntity || this.ticksInAir > 3) {
                this.doDamage(entityLiving);
            }
            this.spawnHitParticles(8);
            this.scheduledForDeath = true;
        }
    }

    protected void onImpact(RayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity entity = ((EntityRayTraceResult)result).func_216348_a();
            if (entity == this.shootingEntity || !(entity instanceof LivingEntity)) {
                return;
            }
            this.onImpact((LivingEntity)entity);
        } else if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            this.groundImpact(((BlockRayTraceResult)result).func_216354_b());
        }
    }

    abstract void doBurstEffect(Direction var1);

    abstract void doFiringEffects();

    abstract void doFlightEffects();

    abstract void spawnHitParticles(int var1);

    public abstract ResourceLocation getShotTexture();

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

