/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xreliquary.items.ToggleableItem;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.RandHelper;

public class DestructionCatalystItem
extends ToggleableItem {
    private static final String GUNPOWDER_TAG = "gunpowder";

    public DestructionCatalystItem() {
        super("destruction_catalyst", new Item.Properties().func_200917_a(1).setNoRepair());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack catalyst, @Nullable World world, List<ITextComponent> tooltip) {
        LanguageHelper.formatTooltip(this.func_77658_a() + ".tooltip2", (ImmutableMap<String, String>)ImmutableMap.of((Object)"charge", (Object)String.valueOf(NBTHelper.getInt(GUNPOWDER_TAG, catalyst))), tooltip);
        if (this.isEnabled(catalyst)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)Items.field_151016_H.func_200295_i(new ItemStack((IItemProvider)Items.field_151016_H)).getString()), tooltip);
        } else {
            LanguageHelper.formatTooltip("tooltip.absorb", tooltip);
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public ActionResultType func_195939_a(ItemUseContext itemUseContext) {
        PlayerEntity player = itemUseContext.func_195999_j();
        ItemStack stack = itemUseContext.func_195996_i();
        if (NBTHelper.getInt(GUNPOWDER_TAG, stack) > this.gunpowderCost() || player != null && player.func_184812_l_()) {
            if (this.doExplosion(itemUseContext.func_195991_k(), itemUseContext.func_195995_a(), itemUseContext.func_196000_l()) && player != null && !player.func_184812_l_()) {
                NBTHelper.putInt(GUNPOWDER_TAG, stack, NBTHelper.getInt(GUNPOWDER_TAG, stack) - this.gunpowderCost());
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public void func_77663_a(ItemStack catalyst, World world, Entity e, int itemSlot, boolean isSelected) {
        if (world.field_72995_K) {
            return;
        }
        PlayerEntity player = null;
        if (e instanceof PlayerEntity) {
            player = (PlayerEntity)e;
        }
        if (player == null) {
            return;
        }
        if (this.isEnabled(catalyst) && NBTHelper.getInt(GUNPOWDER_TAG, catalyst) + this.gunpowderWorth() < this.gunpowderLimit() && InventoryHelper.consumeItem(new ItemStack((IItemProvider)Items.field_151016_H), player)) {
            NBTHelper.putInt(GUNPOWDER_TAG, catalyst, NBTHelper.getInt(GUNPOWDER_TAG, catalyst) + this.gunpowderWorth());
        }
    }

    private int getExplosionRadius() {
        return (Integer)Settings.COMMON.items.destructionCatalyst.explosionRadius.get();
    }

    private boolean perfectCube() {
        return (Boolean)Settings.COMMON.items.destructionCatalyst.perfectCube.get();
    }

    private boolean doExplosion(World world, BlockPos pos, Direction direction) {
        boolean destroyedSomething = false;
        boolean playOnce = true;
        BlockPos origin = pos;
        if (Boolean.FALSE.equals(Settings.COMMON.items.destructionCatalyst.centeredExplosion.get())) {
            origin = pos.func_177967_a(direction.func_176734_d(), this.getExplosionRadius());
        }
        for (BlockPos target : BlockPos.func_218278_a((BlockPos)origin.func_177982_a(-this.getExplosionRadius(), -this.getExplosionRadius(), -this.getExplosionRadius()), (BlockPos)origin.func_177982_a(this.getExplosionRadius(), this.getExplosionRadius(), this.getExplosionRadius()))) {
            double distance;
            if (!this.perfectCube() && (distance = origin.func_177951_i((Vec3i)target)) >= (double)this.getExplosionRadius() || !this.isBreakable(world.func_180495_p(target).func_177230_c().getRegistryName().toString())) continue;
            world.func_175656_a(target, Blocks.field_150350_a.func_176223_P());
            if (world.field_73012_v.nextInt(2) == 0) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197627_t, (double)((float)target.func_177958_n() + (world.field_73012_v.nextFloat() - 0.5f)), (double)((float)target.func_177956_o() + (world.field_73012_v.nextFloat() - 0.5f)), (double)((float)target.func_177952_p() + (world.field_73012_v.nextFloat() - 0.5f)), 0.0, 0.0, 0.0);
            }
            destroyedSomething = true;
            if (!playOnce) continue;
            world.func_184133_a(null, target, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + RandHelper.getRandomMinusOneToOne(world.field_73012_v) * 0.2f) * 0.7f);
            playOnce = false;
        }
        return destroyedSomething;
    }

    private boolean isBreakable(String id) {
        return ((List)Settings.COMMON.items.destructionCatalyst.mundaneBlocks.get()).contains(id);
    }

    private int gunpowderCost() {
        return (Integer)Settings.COMMON.items.destructionCatalyst.gunpowderCost.get();
    }

    private int gunpowderWorth() {
        return (Integer)Settings.COMMON.items.destructionCatalyst.gunpowderWorth.get();
    }

    private int gunpowderLimit() {
        return (Integer)Settings.COMMON.items.destructionCatalyst.gunpowderLimit.get();
    }
}

