/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import xreliquary.items.ToggleableItem;
import xreliquary.items.util.fluid.FluidHandlerEmperorChalice;
import xreliquary.reference.Settings;
import xreliquary.util.LanguageHelper;
import xreliquary.util.RandHelper;

public class EmperorChaliceItem
extends ToggleableItem {
    public EmperorChaliceItem() {
        super("emperor_chalice", new Item.Properties().func_200917_a(1).setNoRepair().func_208103_a(Rarity.EPIC));
        MinecraftForge.EVENT_BUS.addListener(this::onBlockRightClick);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip) {
        LanguageHelper.formatTooltip(this.func_77658_a() + ".tooltip2", tooltip);
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public int func_77626_a(ItemStack stack) {
        return 16;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluidHandlerEmperorChalice(stack);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.DRINK;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entityLiving) {
        if (world.field_72995_K) {
            return stack;
        }
        if (!(entityLiving instanceof PlayerEntity)) {
            return stack;
        }
        PlayerEntity player = (PlayerEntity)entityLiving;
        int multiplier = (Integer)Settings.COMMON.items.emperorChalice.hungerSatiationMultiplier.get();
        player.func_71024_bL().func_75122_a(1, (float)multiplier / 2.0f);
        player.func_70097_a(DamageSource.field_76369_e, (float)multiplier);
        return stack;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            return super.func_77659_a(world, player, hand);
        }
        boolean isInDrainMode = this.isEnabled(stack);
        RayTraceResult result = EmperorChaliceItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)(isInDrainMode ? RayTraceContext.FluidMode.SOURCE_ONLY : RayTraceContext.FluidMode.NONE));
        if (result == null) {
            if (!this.isEnabled(stack)) {
                player.func_184598_c(hand);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)result;
            if (!world.func_175660_a(player, blockRayTraceResult.func_216350_a()) || !player.func_175151_a(blockRayTraceResult.func_216350_a(), blockRayTraceResult.func_216354_b(), stack)) {
                return new ActionResult(ActionResultType.FAIL, (Object)stack);
            }
            if (!this.isEnabled(stack)) {
                BlockPos waterPlacementPos = blockRayTraceResult.func_216350_a().func_177972_a(blockRayTraceResult.func_216354_b());
                if (!player.func_175151_a(waterPlacementPos, blockRayTraceResult.func_216354_b(), stack)) {
                    return new ActionResult(ActionResultType.FAIL, (Object)stack);
                }
                if (this.tryPlaceContainedLiquid(world, stack, waterPlacementPos)) {
                    return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
                }
            } else if (world.func_180495_p(blockRayTraceResult.func_216350_a()).func_177230_c() == Blocks.field_150355_j && (Integer)world.func_180495_p(blockRayTraceResult.func_216350_a()).func_177229_b((IProperty)FlowingFluidBlock.field_176367_b) == 0) {
                world.func_175656_a(blockRayTraceResult.func_216350_a(), Blocks.field_150350_a.func_176223_P());
                return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
            }
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    private void onBlockRightClick(PlayerInteractEvent.RightClickBlock evt) {
        World world;
        BlockState state;
        if (evt.getItemStack().func_77973_b() == this && (state = (world = evt.getWorld()).func_180495_p(evt.getPos())).func_177230_c() == Blocks.field_150383_bp) {
            if (!this.isEnabled(evt.getItemStack()) && (Integer)state.func_177229_b((IProperty)CauldronBlock.field_176591_a) == 0) {
                this.fillCauldron(evt, world, state);
            } else if (this.isEnabled(evt.getItemStack()) && (Integer)state.func_177229_b((IProperty)CauldronBlock.field_176591_a) == 3) {
                this.emptyCauldron(evt, world, state);
            }
        }
    }

    private void emptyCauldron(PlayerInteractEvent.RightClickBlock evt, World world, BlockState state) {
        int level = 0;
        this.setCauldronLevel(evt, world, state, level);
    }

    private void fillCauldron(PlayerInteractEvent.RightClickBlock evt, World world, BlockState state) {
        this.setCauldronLevel(evt, world, state, 3);
    }

    private void setCauldronLevel(PlayerInteractEvent.RightClickBlock evt, World world, BlockState state, int level) {
        ((CauldronBlock)Blocks.field_150383_bp).func_176590_a(world, evt.getPos(), state, level);
        evt.setUseItem(Event.Result.DENY);
        evt.setCanceled(true);
        evt.setCancellationResult(ActionResultType.SUCCESS);
    }

    private boolean tryPlaceContainedLiquid(World world, ItemStack stack, BlockPos pos) {
        BlockState blockState = world.func_180495_p(pos);
        Material material = blockState.func_185904_a();
        if (this.isEnabled(stack)) {
            return false;
        }
        if (!world.func_175623_d(pos) && material.func_76220_a()) {
            return false;
        }
        if (world.func_201675_m().func_177500_n()) {
            world.func_184133_a(null, pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + RandHelper.getRandomMinusOneToOne(world.field_73012_v) * 0.8f);
            for (int var11 = 0; var11 < 8; ++var11) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)pos.func_177958_n() + field_77697_d.nextDouble(), (double)pos.func_177956_o() + field_77697_d.nextDouble(), (double)pos.func_177952_p() + field_77697_d.nextDouble(), 0.0, 0.0, 0.0);
            }
        } else {
            world.func_180501_a(pos, Blocks.field_150355_j.func_176223_P(), 3);
        }
        return true;
    }
}

