/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xreliquary.Reliquary;
import xreliquary.util.LanguageHelper;

public class ItemBase
extends Item {
    public ItemBase(String registryName, Item.Properties properties) {
        super(properties.func_200916_a(Reliquary.ITEM_GROUP));
        this.setRegistryName("xreliquary", registryName);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (LanguageHelper.localizationExists(this.func_77658_a() + ".tooltip")) {
            LanguageHelper.formatTooltip(this.func_77658_a() + ".tooltip", tooltip);
        }
        if (this.hasMoreInformation(stack)) {
            if (Screen.hasShiftDown()) {
                ArrayList detailTooltip = Lists.newArrayList();
                this.addMoreInformation(stack, world, detailTooltip);
                if (!detailTooltip.isEmpty()) {
                    tooltip.add((ITextComponent)new StringTextComponent(""));
                    tooltip.addAll(detailTooltip);
                }
            } else {
                tooltip.add(new TranslationTextComponent("tooltip.xreliquary.shift_for_more_info", new Object[0]).func_211708_a(TextFormatting.WHITE).func_211708_a(TextFormatting.ITALIC));
            }
        }
    }

    protected boolean hasMoreInformation(ItemStack stack) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip) {
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return new StringTextComponent(LanguageHelper.getLocalization(this.func_77667_c(stack), new Object[0]));
    }
}

