/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import xreliquary.init.ModItems;

public class MobCharmDefinition {
    public static final MobCharmDefinition ZOMBIE = new MobCharmDefinition("minecraft:zombie", s -> s.func_77973_b() == ModItems.ZOMBIE_HEART, "minecraft:zombie", "minecraft:husk", "minecraft:drowned");
    public static final MobCharmDefinition SKELETON = new MobCharmDefinition("minecraft:skeleton", s -> s.func_77973_b() == ModItems.RIB_BONE, "minecraft:skeleton", "minecraft:stray");
    public static final MobCharmDefinition WITHER_SKELETON = new MobCharmDefinition("minecraft:wither_skeleton", s -> s.func_77973_b() == ModItems.WITHERED_RIB, "minecraft:wither_skeleton");
    public static final MobCharmDefinition CREEPER = new MobCharmDefinition("minecraft:creeper", s -> s.func_77973_b() == ModItems.CATALYZING_GLAND, "minecraft:creeper");
    public static final MobCharmDefinition WITCH = new MobCharmDefinition("minecraft:witch", s -> s.func_77973_b() == ModItems.WITCH_HAT, "minecraft:witch");
    public static final MobCharmDefinition ZOMBIE_PIGMAN = new MobCharmDefinition("minecraft:zombie_pigman", s -> s.func_77973_b() == ModItems.ZOMBIE_HEART, "minecraft:zombie_pigman").setResetTargetInLivingUpdateEvent(true);
    public static final MobCharmDefinition CAVE_SPIDER = new MobCharmDefinition("minecraft:cave_spider", s -> s.func_77973_b() == ModItems.CHELICERAE, "minecraft:cave_spider");
    public static final MobCharmDefinition SPIDER = new MobCharmDefinition("minecraft:spider", s -> s.func_77973_b() == ModItems.CHELICERAE, "minecraft:spider");
    public static final MobCharmDefinition ENDERMAN = new MobCharmDefinition("minecraft:enderman", s -> s.func_77973_b() == ModItems.NEBULOUS_HEART, "minecraft:enderman").setResetTargetInLivingUpdateEvent(true);
    public static final MobCharmDefinition GHAST = new MobCharmDefinition("minecraft:ghast", s -> s.func_77973_b() == ModItems.CATALYZING_GLAND, "minecraft:ghast").setResetTargetInLivingUpdateEvent(true);
    public static final MobCharmDefinition SLIME = new MobCharmDefinition("minecraft:slime", s -> s.func_77973_b() == ModItems.SLIME_PEARL, "minecraft:slime").setResetTargetInLivingUpdateEvent(true);
    public static final MobCharmDefinition MAGMA_CUBE = new MobCharmDefinition("minecraft:magma_cube", s -> s.func_77973_b() == ModItems.MOLTEN_CORE, "minecraft:magma_cube").setResetTargetInLivingUpdateEvent(true);
    public static final MobCharmDefinition BLAZE = new MobCharmDefinition("minecraft:blaze", s -> s.func_77973_b() == ModItems.MOLTEN_CORE, "minecraft:blaze");
    public static final MobCharmDefinition GUARDIAN = new MobCharmDefinition("minecraft:guardian", s -> s.func_77973_b() == ModItems.GUARDIAN_SPIKE, "minecraft:guardian");
    private final Set<String> applicableToEntities = new HashSet<String>();
    private boolean resetTargetInLivingUpdateEvent = false;
    private final String registryName;
    private final Predicate<ItemStack> isRepairItem;

    MobCharmDefinition(String registryName, Predicate<ItemStack> isRepairItem, String ... applicableTo) {
        this.registryName = registryName;
        this.isRepairItem = isRepairItem;
        Collections.addAll(this.applicableToEntities, applicableTo);
    }

    public boolean appliesTo(Entity e) {
        ResourceLocation registryName = e.func_200600_R().getRegistryName();
        return registryName != null && this.applicableToEntities.contains(registryName.toString());
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public MobCharmDefinition setResetTargetInLivingUpdateEvent(boolean resetTargetInLivingUpdateEvent) {
        this.resetTargetInLivingUpdateEvent = resetTargetInLivingUpdateEvent;
        return this;
    }

    public boolean resetTargetInLivingUpdateEvent() {
        return this.resetTargetInLivingUpdateEvent;
    }

    public Set<String> getEntities() {
        return this.applicableToEntities;
    }

    public boolean isRepairItem(ItemStack item) {
        return this.isRepairItem.test(item);
    }
}

