/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xreliquary.items.ItemBase;
import xreliquary.util.RandHelper;

public class SalamanderEyeItem
extends ItemBase {
    public SalamanderEyeItem() {
        super("salamander_eye", new Item.Properties().func_200917_a(1));
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.EPIC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (world.field_72995_K || !(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (player.func_184586_b(Hand.MAIN_HAND).func_77973_b() == this || player.func_184586_b(Hand.OFF_HAND).func_77973_b() == this) {
            this.doFireballEffect(player);
            this.doExtinguishEffect(player);
        }
    }

    private void doExtinguishEffect(PlayerEntity player) {
        if (player.func_70027_ad()) {
            player.func_70066_B();
        }
        int x = (int)Math.floor(player.field_70165_t);
        int y = (int)Math.floor(player.field_70163_u);
        int z = (int)Math.floor(player.field_70161_v);
        for (int xOff = -3; xOff <= 3; ++xOff) {
            for (int yOff = -3; yOff <= 3; ++yOff) {
                for (int zOff = -3; zOff <= 3; ++zOff) {
                    if (player.field_70170_p.func_180495_p(new BlockPos(x + xOff, y + yOff, z + zOff)).func_177230_c() != Blocks.field_150480_ab) continue;
                    player.field_70170_p.func_175656_a(new BlockPos(x + xOff, y + yOff, z + zOff), Blocks.field_150350_a.func_176223_P());
                    player.field_70170_p.func_184134_a((double)(x + xOff) + 0.5, (double)(y + yOff) + 0.5, (double)(z + zOff) + 0.5, SoundEvents.field_187646_bt, SoundCategory.NEUTRAL, 0.5f, 2.6f + RandHelper.getRandomMinusOneToOne(player.field_70170_p.field_73012_v) * 0.8f, false);
                }
            }
        }
    }

    private void doFireballEffect(PlayerEntity player) {
        List ghastFireballs = player.field_70170_p.func_217357_a(FireballEntity.class, new AxisAlignedBB(player.field_70165_t - 5.0, player.field_70163_u - 5.0, player.field_70161_v - 5.0, player.field_70165_t + 5.0, player.field_70163_u + 5.0, player.field_70161_v + 5.0));
        for (FireballEntity fireball : ghastFireballs) {
            if (player.func_70032_d((Entity)fireball) < 4.0f) {
                fireball.func_70106_y();
            }
            fireball.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 1.0f);
            player.field_70170_p.func_184134_a(fireball.field_70165_t, fireball.field_70163_u, fireball.field_70161_v, SoundEvents.field_187646_bt, SoundCategory.NEUTRAL, 0.5f, 2.6f + RandHelper.getRandomMinusOneToOne(player.field_70170_p.field_73012_v) * 0.8f, false);
        }
        List blazeFireballs = player.field_70170_p.func_217357_a(SmallFireballEntity.class, new AxisAlignedBB(player.field_70165_t - 3.0, player.field_70163_u - 3.0, player.field_70161_v - 3.0, player.field_70165_t + 3.0, player.field_70163_u + 3.0, player.field_70161_v + 3.0));
        for (SmallFireballEntity fireball : blazeFireballs) {
            for (int particles = 0; particles < 4; ++particles) {
                player.field_70170_p.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, fireball.field_70165_t, fireball.field_70163_u, fireball.field_70161_v, 0.0, 1.0, 1.0);
            }
            player.field_70170_p.func_184134_a(fireball.field_70165_t, fireball.field_70163_u, fireball.field_70161_v, SoundEvents.field_187646_bt, SoundCategory.NEUTRAL, 0.5f, 2.6f + RandHelper.getRandomMinusOneToOne(player.field_70170_p.field_73012_v) * 0.8f, false);
            fireball.func_70106_y();
        }
    }
}

