/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xreliquary.items.ItemBase;
import xreliquary.util.NBTHelper;
import xreliquary.util.RandHelper;

public class ToggleableItem
extends ItemBase {
    private static final String ENABLED_TAG = "enabled";

    public ToggleableItem(String langName, Item.Properties properties) {
        super(langName, properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.isEnabled(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && player.func_70093_af()) {
            this.toggleEnabled(stack);
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * (RandHelper.getRandomMinusOneToOne(player.field_70170_p.field_73012_v) * 0.7f + 1.2f));
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b() || oldStack.func_77962_s() != newStack.func_77962_s();
    }

    public boolean isEnabled(ItemStack stack) {
        return NBTHelper.getBoolean(ENABLED_TAG, stack);
    }

    void toggleEnabled(ItemStack stack) {
        NBTHelper.putBoolean(ENABLED_TAG, stack, !NBTHelper.getBoolean(ENABLED_TAG, stack));
    }
}

