/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import xreliquary.handler.CommonEventHandler;
import xreliquary.handler.HandlerPriority;
import xreliquary.handler.IPlayerHurtHandler;
import xreliquary.init.ModItems;
import xreliquary.items.ItemBase;
import xreliquary.util.InventoryHelper;

public class WitherlessRoseItem
extends ItemBase {
    public WitherlessRoseItem() {
        super("witherless_rose", new Item.Properties().func_200917_a(1));
        CommonEventHandler.registerPlayerHurtHandler(new IPlayerHurtHandler(){

            @Override
            public boolean canApply(PlayerEntity player, LivingAttackEvent event) {
                return event.getSource() == DamageSource.field_82727_n && InventoryHelper.playerHasItem(player, ModItems.WITHERLESS_ROSE);
            }

            @Override
            public boolean apply(PlayerEntity player, LivingAttackEvent event) {
                return true;
            }

            @Override
            public HandlerPriority getPriority() {
                return HandlerPriority.HIGHEST;
            }
        });
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.EPIC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        if (player.func_70644_a(Effects.field_82731_v)) {
            player.func_195063_d(Effects.field_82731_v);
            for (int particles = 0; particles < 10; ++particles) {
                double gauss1 = this.gaussian(world.field_73012_v);
                double gauss2 = this.gaussian(world.field_73012_v);
                world.func_195594_a((IParticleData)ParticleTypes.field_197625_r, player.field_70165_t + gauss1, player.field_70163_u + (double)(player.func_213302_cg() / 2.0f), player.field_70161_v + gauss2, 0.0, 0.0, 1.0);
            }
        }
    }

    private double gaussian(Random rand) {
        return rand.nextGaussian() / 6.0;
    }
}

